/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.PC_Color;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_GresWidget;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.mod_PCcore;
import org.lwjgl.opengl.GL11;

public class PC_GresProgressBar
extends PC_GresWidget {
    protected float fraction = 0.2f;
    protected int colorHex = 0xFFFFFF;
    protected int type = 0;
    protected boolean showLabel = false;
    protected int labelMultiplier = 100;
    private int barWidth;
    protected String labelAppend = "";
    protected int labelWidth = 0;
    private boolean acceptsInput = false;
    private boolean dragging = false;

    public PC_GresProgressBar(int color, int width) {
        super(width, 11);
        this.barWidth = width;
        this.canAddWidget = false;
        this.colorHex = color;
    }

    public PC_GresProgressBar(int color) {
        super(100, 11);
        this.canAddWidget = false;
        this.colorHex = color;
    }

    public float getFraction() {
        return this.fraction;
    }

    public PC_GresProgressBar setFraction(float fraction) {
        this.fraction = fraction;
        return this;
    }

    public int getColor() {
        return this.colorHex;
    }

    public PC_GresProgressBar setColor(int colorHex) {
        this.colorHex = colorHex;
        return this;
    }

    public int getType() {
        return this.type;
    }

    public PC_GresProgressBar setType(int type) {
        this.type = type;
        return this;
    }

    public boolean getShowLabel() {
        return this.showLabel;
    }

    public PC_GresProgressBar setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
        return this;
    }

    public int getLabelMultiplier() {
        return this.labelMultiplier;
    }

    public PC_GresProgressBar setLabelMultiplier(int labelMultiplier) {
        this.labelMultiplier = labelMultiplier;
        return this;
    }

    public int getLabelWidth() {
        return this.labelWidth;
    }

    public PC_GresProgressBar setLabelWidth(int labelWidth) {
        this.labelWidth = labelWidth;
        return this;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public PC_GresProgressBar setBarWidth(int barWidth) {
        this.barWidth = barWidth;
        return this;
    }

    public String getLabelAppend() {
        return this.labelAppend;
    }

    public PC_GresProgressBar setLabelAppend(String labelAppend) {
        this.labelAppend = labelAppend;
        return this;
    }

    public boolean getEditable() {
        return this.acceptsInput;
    }

    public PC_GresProgressBar setEditable(boolean acceptsInput) {
        this.acceptsInput = acceptsInput;
        return this;
    }

    public PC_GresProgressBar configureLabel(String append, String longest, int multiplier) {
        this.setShowLabel(true);
        this.setLabelAppend(append);
        this.setLabelWidth(this.getStringWidth(longest));
        this.setLabelMultiplier(multiplier);
        return this;
    }

    @Override
    public PC_CoordI calcSize() {
        if (this.showLabel) {
            this.size.setTo(this.barWidth + this.labelWidth + 3, 11);
        }
        return this.size.copy();
    }

    @Override
    public void calcChildPositions() {
    }

    @Override
    protected void render(PC_CoordI offsetPos) {
        String texture = mod_PCcore.getImgDir() + "gres/widgets.png";
        this.renderTextureSliced(offsetPos, texture, this.size.offset(this.showLabel ? -(this.labelWidth + 3) : 0, 0), new PC_CoordI(0, 22), new PC_CoordI(256, 11));
        GL11.glBindTexture((int)3553, (int)PC_Utils.mc().renderEngine.getTexture(texture));
        PC_Color colorRGB = new PC_Color(this.colorHex);
        GL11.glColor4f((float)((float)colorRGB.r), (float)((float)colorRGB.g), (float)((float)colorRGB.b), (float)1.0f);
        int inner_x = this.pos.x + offsetPos.x + 1;
        int inner_y = this.pos.y + offsetPos.y;
        int texture_x = 0;
        int texture_y = 11 * (3 + this.type);
        int inner_width = Math.round((float)(this.size.x - 2 - (this.showLabel ? this.labelWidth + 3 : 0)) * this.fraction);
        int inner_height = 11;
        this.drawTexturedModalRect(inner_x, inner_y, texture_x, texture_y, inner_width, inner_height);
        if (this.showLabel) {
            String lbl = Math.round(this.fraction * (float)this.labelMultiplier) + this.labelAppend;
            this.drawString(lbl, this.pos.x + offsetPos.x + this.size.offset((int)(-this.labelWidth), (int)0).x, this.pos.y + offsetPos.y + 2);
        }
    }

    @Override
    public boolean mouseOver(PC_CoordI mpos) {
        return true;
    }

    @Override
    public boolean mouseClick(PC_CoordI mpos, int key) {
        this.dragging = key != -1;
        int inner_width = Math.round(this.size.x - 2 - (this.showLabel ? this.labelWidth + 3 : 0));
        if (!this.acceptsInput) {
            return false;
        }
        if (mpos.x >= 0) {
            this.fraction = (float)mpos.x / (float)inner_width;
            if (this.fraction > 1.0f) {
                this.fraction = 1.0f;
            }
            if (this.fraction < 0.0f) {
                this.fraction = 0.0f;
            }
        }
        return true;
    }

    @Override
    public boolean keyTyped(char c, int key) {
        return false;
    }

    @Override
    public void mouseMove(PC_CoordI mpos) {
        if (this.dragging) {
            this.mouseClick(mpos, 0);
        }
    }

    @Override
    public PC_CoordI getMinSize() {
        return this.calcSize();
    }

    @Override
    public void mouseWheel(int i) {
    }

    @Override
    public void addedToWidget() {
    }
}

