/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Gui;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_GresContainerManager;
import net.minecraft.src.PC_Utils;
import org.lwjgl.opengl.GL11;

public abstract class PC_GresWidget
extends Gui {
    protected static Minecraft mc = PC_Utils.mc();
    public static final int textColorEnabled = 0;
    public static final int textColorShadowEnabled = 1;
    public static final int textColorDisabled = 2;
    public static final int textColorShadowDisabled = 3;
    protected int[] color = new int[]{-16777216, 0, -13421773, 0};
    protected PC_GresWidget parent = null;
    protected ArrayList<PC_GresWidget> childs = new ArrayList();
    protected FontRenderer fontRenderer = null;
    protected PC_CoordI pos = new PC_CoordI(0, 0);
    protected PC_CoordI size = new PC_CoordI(0, 0);
    protected PC_CoordI minSize = new PC_CoordI(0, 0);
    protected int widgetMargin = 4;
    protected int cursorCounter = 0;
    protected boolean canAddWidget = true;
    protected boolean isMouseOver = false;
    protected boolean enabled = true;
    protected boolean hasFocus = false;
    protected String text = "";
    protected PC_GresAlign alignH = PC_GresAlign.CENTER;
    protected PC_GresAlign alignV = PC_GresAlign.CENTER;
    protected PC_GresContainerManager containerManager = null;
    public int id = -1;

    public PC_GresWidget() {
        PC_CoordI minSize = this.getMinSize();
        this.size = minSize.copy();
        this.minSize = minSize.copy();
    }

    public PC_GresWidget(String label) {
        this.text = label;
        PC_CoordI minSize = this.getMinSize();
        this.size = minSize.copy();
        this.minSize = minSize.copy();
    }

    public PC_GresWidget(int width, int height) {
        PC_CoordI minSize = new PC_CoordI(width, height);
        this.size = minSize.copy();
        this.minSize = minSize.copy();
    }

    public PC_GresWidget(int width, int height, String label) {
        this(width, height);
        this.text = label;
    }

    public PC_GresWidget setId(int id) {
        this.id = id;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public FontRenderer getFontRenderer() {
        if (this.fontRenderer == null) {
            return PC_GresWidget.mc.fontRenderer;
        }
        return this.fontRenderer;
    }

    public PC_GresWidget setFontRenderer(FontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
        for (PC_GresWidget w : this.childs) {
            w.setFontRenderer(fontRenderer);
        }
        return this;
    }

    public PC_GresAlign getAlignH() {
        return this.alignH;
    }

    public PC_GresWidget setAlignH(PC_GresAlign alignHorizontal) {
        this.alignH = alignHorizontal;
        return this;
    }

    public PC_GresAlign getAlignV() {
        return this.alignV;
    }

    public PC_GresWidget setAlignV(PC_GresAlign alignVertical) {
        this.alignV = alignVertical;
        return this;
    }

    public boolean getFocus() {
        return this.hasFocus;
    }

    public PC_GresWidget setFocus(boolean focus) {
        this.hasFocus = focus;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public PC_GresWidget setText(String text) {
        this.text = text;
        if (this.parent != null) {
            this.parent.calcChildPositions();
        }
        return this;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public PC_CoordI getMinSize() {
        return this.calcSize().copy();
    }

    public PC_GresWidget setMinSize(PC_CoordI minSize) {
        this.minSize = minSize;
        return this;
    }

    public PC_GresWidget setMinSize(int w, int h) {
        this.minSize.setTo(w, h);
        return this;
    }

    public PC_GresWidget setMinWidth(int w) {
        this.minSize.setTo(w, this.minSize.y);
        return this;
    }

    public PC_GresWidget setMinHeight(int h) {
        this.minSize.setTo(this.minSize.x, h);
        return this;
    }

    public PC_GresWidget setWidgetMargin(int widgetMargin) {
        this.widgetMargin = widgetMargin;
        return this;
    }

    public abstract PC_CoordI calcSize();

    public PC_GresContainerManager getContainerManager() {
        return this.containerManager;
    }

    public PC_GresWidget setContainerManager(PC_GresContainerManager containerManager) {
        this.containerManager = containerManager;
        for (PC_GresWidget w : this.childs) {
            w.setContainerManager(containerManager);
        }
        return this;
    }

    public PC_CoordI getSize() {
        return this.size.copy();
    }

    public PC_GresWidget setSize(int width, int height, boolean calcParent) {
        this.size.setTo(width, height);
        if (this.parent != null && calcParent) {
            this.parent.calcChildPositions();
        }
        return this;
    }

    public PC_GresWidget setSize(int width, int height) {
        return this.setSize(width, height, true);
    }

    public PC_CoordI getPosition() {
        return this.pos;
    }

    public PC_GresWidget setPosition(int x, int y) {
        this.pos.setTo(x, y);
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public PC_GresWidget enable(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public abstract void calcChildPositions();

    public void calcChildPositionsDefault() {
        int maxh = 0;
        int xx = 0;
        int yy = 0;
        if (this.childs != null) {
            for (int i = 0; i < this.childs.size(); ++i) {
                this.childs.get(i).calcChildPositions();
                PC_CoordI childSize = this.childs.get(i).calcSize();
                if (childSize.y > maxh) {
                    maxh = childSize.y;
                }
                if (childSize.x > this.size.x || childSize.y > this.size.y) {
                    if (childSize.x > this.size.x) {
                        this.size.x = childSize.x;
                    }
                    if (childSize.y > this.size.y) {
                        this.size.y = childSize.y;
                    }
                    if (this.parent != null) {
                        this.parent.calcChildPositions();
                    }
                    this.calcChildPositions();
                    return;
                }
                if (xx + this.size.x > this.size.x) {
                    xx = 0;
                    yy += maxh + this.widgetMargin;
                }
                this.childs.get(i).setPosition(xx, yy);
                xx += this.size.x + this.widgetMargin;
            }
        }
    }

    public PC_GresWidget getParent() {
        return this.parent;
    }

    public PC_GresWidget add(PC_GresWidget newwidget) {
        if (!this.canAddWidget) {
            return null;
        }
        newwidget.parent = this;
        newwidget.setFontRenderer(this.fontRenderer);
        newwidget.setContainerManager(this.containerManager);
        this.childs.add(newwidget);
        newwidget.callAddedToWidget();
        this.calcChildPositions();
        return this;
    }

    public PC_GresWidget remove(PC_GresWidget removewidget) {
        if (!this.childs.remove(removewidget)) {
            for (int i = 0; i < this.childs.size(); ++i) {
                this.childs.get(i).remove(removewidget);
            }
        }
        this.calcChildPositions();
        return this;
    }

    public PC_GresWidget removeAll() {
        this.childs.removeAll(this.childs);
        if (this.parent != null) {
            this.parent.calcChildPositions();
        }
        return this;
    }

    public PC_GresWidget setColor(int colorIndex, int color) {
        if (colorIndex < 0 || colorIndex > 3) {
            return this;
        }
        this.color[colorIndex] = color;
        return this;
    }

    public int getColor(int colorIndex) {
        if (colorIndex < 0 || colorIndex > 3) {
            return 0;
        }
        return this.color[colorIndex];
    }

    protected int getStringWidth(String text) {
        FontRenderer fr = this.getFontRenderer();
        return fr.getStringWidth(text);
    }

    protected int getLineHeight() {
        return this.getFontRenderer().FONT_HEIGHT;
    }

    protected void drawString(String text, int x, int y) {
        FontRenderer fr = this.getFontRenderer();
        if (this.color[this.enabled ? 1 : 3] != 0) {
            fr.drawString(text, x + 1, y + 1, this.color[this.enabled ? 1 : 3]);
        }
        fr.drawString(text, x, y, this.color[this.enabled ? 0 : 2]);
    }

    protected void drawStringColor(String text, int x, int y, int colorOverride) {
        FontRenderer fr = this.getFontRenderer();
        if (this.color[this.enabled ? 1 : 3] != 0) {
            fr.drawString(text, x + 1, y + 1, this.color[this.enabled ? 1 : 3]);
        }
        fr.drawString(text, x, y, colorOverride);
    }

    public void updateRenderer(PC_CoordI posOffset) {
        this.render(posOffset);
        if (this.childs != null) {
            for (int i = 0; i < this.childs.size(); ++i) {
                this.childs.get(i).updateRenderer(posOffset.offset(this.pos));
            }
        }
    }

    protected abstract void render(PC_CoordI var1);

    public PC_GresWidget getWidgetUnderMouse(PC_CoordI mousePos) {
        PC_CoordI mpos = mousePos.offset(-this.pos.x, -this.pos.y);
        if (mpos.x < 0 || mpos.x >= this.size.x || mpos.y < 0 || mpos.y >= this.size.y || !this.mouseOver(mpos)) {
            this.isMouseOver = false;
            if (this.childs != null) {
                for (int i = 0; i < this.childs.size(); ++i) {
                    this.childs.get(i).getWidgetUnderMouse(new PC_CoordI(-1, -1));
                }
            }
            return null;
        }
        this.isMouseOver = true;
        if (this.childs != null) {
            for (int i = 0; i < this.childs.size(); ++i) {
                PC_GresWidget widget = this.childs.get(i).getWidgetUnderMouse(mpos);
                if (widget == null) continue;
                ++i;
                while (i < this.childs.size()) {
                    this.childs.get(i).getWidgetUnderMouse(new PC_CoordI(-1, -1));
                    ++i;
                }
                return widget;
            }
        }
        if (!this.mouseOver(mpos)) {
            this.isMouseOver = false;
            return null;
        }
        return this;
    }

    public PC_CoordI getPositionOnScreen() {
        PC_CoordI position = this.parent != null ? this.parent.getPositionOnScreen().offset(this.pos) : this.pos.copy();
        return position;
    }

    protected void renderImage(PC_CoordI offset, String texture, PC_CoordI rectSize, PC_CoordI imgOffset) {
        GL11.glBindTexture((int)3553, (int)PC_Utils.mc().renderEngine.getTexture(texture));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.drawTexturedModalRect(this.pos.x + offset.x, this.pos.y + offset.y, imgOffset.x, imgOffset.y, rectSize.x, rectSize.y);
        GL11.glDisable((int)3042);
    }

    protected static void renderImage_static(Gui gui, String texture, PC_CoordI startPos, PC_CoordI rectSize, PC_CoordI imgOffset) {
        GL11.glBindTexture((int)3553, (int)PC_Utils.mc().renderEngine.getTexture(texture));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        gui.drawTexturedModalRect(startPos.x, startPos.y, imgOffset.x, imgOffset.y, rectSize.x, rectSize.y);
        GL11.glDisable((int)3042);
    }

    protected void renderTextureSliced(PC_CoordI offset, String texture, PC_CoordI rectSize, PC_CoordI imgOffset, PC_CoordI imgSize) {
        GL11.glBindTexture((int)3553, (int)PC_GresWidget.mc.renderEngine.getTexture(texture));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int rxh1 = (int)Math.floor((float)rectSize.x / 2.0f);
        int rxh2 = (int)Math.ceil((float)rectSize.x / 2.0f);
        int ryh1 = (int)Math.floor((float)rectSize.y / 2.0f);
        int ryh2 = (int)Math.ceil((float)rectSize.y / 2.0f);
        this.drawTexturedModalRect(this.pos.x + offset.x, this.pos.y + offset.y, imgOffset.x, imgOffset.y, rxh1, ryh1);
        this.drawTexturedModalRect(this.pos.x + offset.x + rxh1, this.pos.y + offset.y, imgOffset.x + imgSize.x - rxh2, imgOffset.y, rxh2, ryh1);
        this.drawTexturedModalRect(this.pos.x + offset.x, this.pos.y + offset.y + ryh1, imgOffset.x, imgOffset.y + imgSize.y - ryh2, rxh1, ryh2);
        this.drawTexturedModalRect(this.pos.x + offset.x + rxh1, this.pos.y + offset.y + ryh1, imgOffset.x + imgSize.x - rxh2, imgOffset.y + imgSize.y - ryh2, rxh2, ryh2);
        GL11.glDisable((int)3042);
    }

    protected static void renderTextureSliced_static(Gui gui, PC_CoordI startPos, String texture, PC_CoordI rectSize, PC_CoordI imgOffset, PC_CoordI imgSize) {
        GL11.glBindTexture((int)3553, (int)PC_GresWidget.mc.renderEngine.getTexture(texture));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int rxh1 = (int)Math.floor((float)rectSize.x / 2.0f);
        int rxh2 = (int)Math.ceil((float)rectSize.x / 2.0f);
        int ryh1 = (int)Math.floor((float)rectSize.y / 2.0f);
        int ryh2 = (int)Math.ceil((float)rectSize.y / 2.0f);
        gui.drawTexturedModalRect(startPos.x, startPos.y, imgOffset.x, imgOffset.y, rxh1, ryh1);
        gui.drawTexturedModalRect(startPos.x + rxh1, startPos.y, imgOffset.x + imgSize.x - rxh2, imgOffset.y, rxh2, ryh1);
        gui.drawTexturedModalRect(startPos.x, startPos.y + ryh1, imgOffset.x, imgOffset.y + imgSize.y - ryh2, rxh1, ryh2);
        gui.drawTexturedModalRect(startPos.x + rxh1, startPos.y + ryh1, imgOffset.x + imgSize.x - rxh2, imgOffset.y + imgSize.y - ryh2, rxh2, ryh2);
        GL11.glDisable((int)3042);
    }

    public abstract boolean mouseOver(PC_CoordI var1);

    public abstract boolean mouseClick(PC_CoordI var1, int var2);

    public abstract void mouseMove(PC_CoordI var1);

    public abstract void mouseWheel(int var1);

    public abstract boolean keyTyped(char var1, int var2);

    public void callAddedToWidget() {
        this.addedToWidget();
        for (PC_GresWidget w : this.childs) {
            w.callAddedToWidget();
        }
    }

    public abstract void addedToWidget();

    public static enum PC_GresAlign {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        CENTER,
        STRETCH;

    }
}

