/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_GresWidget;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.mod_PCcore;

public class PC_GresWindow
extends PC_GresWidget {
    protected PC_CoordI padding = new PC_CoordI(10, 10);
    protected int gapUnderTitle = 15;

    public PC_GresWindow(int minX, int minY, String title) {
        super(minX, minY, title);
    }

    public PC_GresWindow(String title) {
        super(240, 0, title);
    }

    public PC_GresWindow() {
        super(240, 0, "");
    }

    public PC_GresWidget setWidthForInventory() {
        this.setMinWidth(176);
        this.padding.setTo(7, 7);
        this.size = this.minSize.copy();
        this.minSize = this.minSize.copy();
        this.calcSize();
        return this;
    }

    @Override
    public PC_CoordI calcSize() {
        int textWidth = PC_Utils.mc().fontRenderer.getStringWidth(this.text);
        if (this.size.x < textWidth + this.padding.x * 2 + 12) {
            this.size.x = textWidth + this.padding.y * 2 + 12;
        }
        this.calcChildPositions();
        return this.size.copy();
    }

    @Override
    public void render(PC_CoordI offsetPos) {
        this.renderTextureSliced(offsetPos, mod_PCcore.getImgDir() + "gres/dialog.png", this.size, new PC_CoordI(0, 0), new PC_CoordI(256, 256));
        if (this.text.length() > 0) {
            this.getFontRenderer().drawString(this.text, offsetPos.x + this.pos.x + this.size.x / 2 - this.fontRenderer.getStringWidth(this.text) / 2, offsetPos.y + this.pos.y + 8, 0x404040);
        }
    }

    @Override
    public boolean mouseOver(PC_CoordI pos) {
        return true;
    }

    @Override
    public boolean mouseClick(PC_CoordI pos, int key) {
        return false;
    }

    @Override
    public boolean keyTyped(char c, int key) {
        return false;
    }

    @Override
    public void calcChildPositions() {
        PC_CoordI csize;
        int i;
        int yy = 0;
        int minySize = 0;
        int minmaxxSize = 0;
        int maxxSize = 0;
        int ySize = 0;
        int yPlus = this.getFontRenderer().FONT_HEIGHT + this.gapUnderTitle;
        if (this.text.length() == 0) {
            yPlus = 0;
        }
        int childNum = this.childs.size();
        for (i = 0; i < childNum; ++i) {
            ((PC_GresWidget)this.childs.get(i)).calcChildPositions();
            csize = ((PC_GresWidget)this.childs.get(i)).calcSize();
            PC_CoordI cminSize = ((PC_GresWidget)this.childs.get(i)).getMinSize();
            ySize += csize.y + this.widgetMargin;
            minySize += cminSize.y + this.widgetMargin;
            if (maxxSize < csize.x) {
                maxxSize = csize.x;
            }
            if (minmaxxSize >= cminSize.x) continue;
            minmaxxSize = cminSize.x;
        }
        if (this.alignV == PC_GresWidget.PC_GresAlign.STRETCH) {
            maxxSize = minmaxxSize;
            ySize = minySize;
            for (i = 0; i < childNum; ++i) {
                PC_CoordI cminSize = ((PC_GresWidget)this.childs.get(i)).getMinSize();
                ((PC_GresWidget)this.childs.get(i)).setSize(cminSize.x, cminSize.y, false);
            }
        }
        if (maxxSize + this.padding.x * 2 > this.size.x || ySize + yPlus + this.padding.y > this.size.y) {
            if (maxxSize + this.padding.x * 2 > this.size.x) {
                this.size.x = maxxSize + this.padding.x * 2;
            }
            if (ySize + yPlus + this.padding.y > this.size.y) {
                this.size.y = ySize + yPlus + this.padding.y;
            }
            if (this.parent != null) {
                this.parent.calcChildPositions();
            }
            this.calcChildPositions();
            return;
        }
        ySize -= this.widgetMargin;
        for (i = 0; i < childNum; ++i) {
            csize = ((PC_GresWidget)this.childs.get(i)).getSize();
            int xPos = 0;
            int yPos = 0;
            int s = 0;
            switch (this.alignH) {
                case LEFT: {
                    xPos = this.padding.x;
                    break;
                }
                case RIGHT: {
                    xPos = this.size.x - ((PC_GresWidget)this.childs.get((int)i)).getSize().x - this.padding.x;
                    break;
                }
                case CENTER: {
                    xPos = this.size.x / 2 - ((PC_GresWidget)this.childs.get((int)i)).getSize().x / 2;
                    break;
                }
                case STRETCH: {
                    xPos = this.padding.x;
                    ((PC_GresWidget)this.childs.get(i)).setSize(this.size.x - this.padding.x * 2, ((PC_GresWidget)this.childs.get((int)i)).getSize().y, false);
                }
            }
            switch (this.alignV) {
                case TOP: {
                    yPos = yPlus + yy;
                    break;
                }
                case BOTTOM: {
                    yPos = this.size.y - this.padding.y - ySize + yy;
                    break;
                }
                case CENTER: {
                    yPos = (this.size.y + yPlus - this.padding.y) / 2 - ySize / 2 + yy;
                    break;
                }
                case STRETCH: {
                    s = (this.size.y - yPlus - this.padding.y - ySize + this.widgetMargin - this.widgetMargin * childNum) / childNum;
                    ((PC_GresWidget)this.childs.get(i)).setSize(((PC_GresWidget)this.childs.get((int)i)).getSize().x, ((PC_GresWidget)this.childs.get((int)i)).getSize().y + s, false);
                    yPos = yPlus + yy;
                }
            }
            ((PC_GresWidget)this.childs.get(i)).setPosition(xPos, yPos);
            yy += csize.y + this.widgetMargin + s;
        }
    }

    @Override
    public void mouseMove(PC_CoordI pos) {
    }

    @Override
    public PC_CoordI getMinSize() {
        return this.calcSize();
    }

    @Override
    public void mouseWheel(int i) {
    }

    @Override
    public void addedToWidget() {
    }
}

