/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryLargeChest;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_ISelectiveInventory;
import net.minecraft.src.PC_IStateReportingInventory;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityBrewingStand;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.mod_PCcore;

public class PC_InvUtils {
    public static IInventory getCompositeInventoryAt(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getBlockTileEntity(x, y, z);
        if (te == null || !(te instanceof IInventory) || te instanceof TileEntityBrewingStand) {
            return null;
        }
        IInventory inv = (IInventory)((Object)te);
        int id = world.getBlockId(x, y, z);
        if (id == Block.chest.blockID) {
            if (world.getBlockId(x - 1, y, z) == Block.chest.blockID) {
                inv = new InventoryLargeChest("Large chest", (IInventory)((Object)world.getBlockTileEntity(x - 1, y, z)), inv);
            }
            if (world.getBlockId(x + 1, y, z) == Block.chest.blockID) {
                inv = new InventoryLargeChest("Large chest", inv, (IInventory)((Object)world.getBlockTileEntity(x + 1, y, z)));
            }
            if (world.getBlockId(x, y, z - 1) == Block.chest.blockID) {
                inv = new InventoryLargeChest("Large chest", (IInventory)((Object)world.getBlockTileEntity(x, y, z - 1)), inv);
            }
            if (world.getBlockId(x, y, z + 1) == Block.chest.blockID) {
                inv = new InventoryLargeChest("Large chest", inv, (IInventory)((Object)world.getBlockTileEntity(x, y, z + 1)));
            }
        }
        return inv;
    }

    public static boolean storeItemInSlot(IInventory inventory, ItemStack stackToStore, int slot) {
        if (stackToStore == null || stackToStore.stackSize == 0) {
            return false;
        }
        if (inventory instanceof PC_ISelectiveInventory && !((PC_ISelectiveInventory)((Object)inventory)).canInsertStackTo(slot, stackToStore)) {
            return false;
        }
        ItemStack destination = inventory.getStackInSlot(slot);
        if (destination == null) {
            int numStored = stackToStore.stackSize;
            numStored = Math.min(numStored, stackToStore.getMaxStackSize());
            numStored = Math.min(numStored, inventory.getInventoryStackLimit());
            destination = stackToStore.splitStack(numStored);
            inventory.setInventorySlotContents(slot, destination);
            return true;
        }
        if (destination.itemID == stackToStore.itemID && destination.isStackable() && (!destination.getHasSubtypes() || destination.getItemDamage() == stackToStore.getItemDamage()) && destination.stackSize < inventory.getInventoryStackLimit()) {
            int numStored = stackToStore.stackSize;
            numStored = Math.min(numStored, destination.getMaxStackSize() - destination.stackSize);
            numStored = Math.min(numStored, inventory.getInventoryStackLimit() - destination.stackSize);
            destination.stackSize += numStored;
            stackToStore.stackSize -= numStored;
            return numStored > 0;
        }
        return false;
    }

    public static boolean addItemStackToInventory(IInventory inv, ItemStack itemstack) {
        if (!itemstack.isItemDamaged()) {
            int i;
            do {
                i = itemstack.stackSize;
                itemstack.stackSize = PC_InvUtils.storePartialItemStack(inv, itemstack);
            } while (itemstack.stackSize > 0 && itemstack.stackSize < i);
            return itemstack.stackSize < i;
        }
        int j = PC_InvUtils.getFirstEmptyStack(inv);
        if (j >= 0) {
            inv.setInventorySlotContents(j, ItemStack.copyItemStack(itemstack));
            itemstack.stackSize = 0;
            return true;
        }
        return false;
    }

    public static boolean addWholeItemStackToInventory(IInventory inv, ItemStack itemstack) {
        if (!itemstack.isItemDamaged()) {
            int oldSize;
            do {
                oldSize = itemstack.stackSize;
                itemstack.stackSize = PC_InvUtils.storePartialItemStack(inv, itemstack);
            } while (itemstack.stackSize > 0 && itemstack.stackSize < oldSize);
            return itemstack.stackSize == 0;
        }
        int emptySlot = PC_InvUtils.getFirstEmptyStack(inv);
        if (emptySlot >= 0) {
            inv.setInventorySlotContents(emptySlot, ItemStack.copyItemStack(itemstack));
            itemstack.stackSize = 0;
            return true;
        }
        return false;
    }

    private static int getStackWithFreeSpace(IInventory inv, ItemStack itemstack) {
        for (int slot = 0; slot < inv.getSizeInventory(); ++slot) {
            ItemStack stackAt = inv.getStackInSlot(slot);
            if (stackAt == null || stackAt.itemID != itemstack.itemID || !stackAt.isStackable() || stackAt.stackSize >= stackAt.getMaxStackSize() || stackAt.stackSize >= inv.getInventoryStackLimit() || stackAt.getHasSubtypes() && stackAt.getItemDamage() != itemstack.getItemDamage()) continue;
            return slot;
        }
        return -1;
    }

    private static int storePartialItemStack(IInventory inv, ItemStack itemstack) {
        int canStore;
        int id = itemstack.itemID;
        int size = itemstack.stackSize;
        if (itemstack.getMaxStackSize() == 1) {
            int firstEmpty = PC_InvUtils.getFirstEmptyStack(inv);
            if (firstEmpty < 0) {
                return size;
            }
            if (inv.getStackInSlot(firstEmpty) == null) {
                inv.setInventorySlotContents(firstEmpty, ItemStack.copyItemStack(itemstack));
            }
            return 0;
        }
        int targetSlot = PC_InvUtils.getStackWithFreeSpace(inv, itemstack);
        if (targetSlot < 0) {
            targetSlot = PC_InvUtils.getFirstEmptyStack(inv);
        }
        if (targetSlot < 0) {
            return size;
        }
        if (inv.getStackInSlot(targetSlot) == null) {
            inv.setInventorySlotContents(targetSlot, new ItemStack(id, 0, itemstack.getItemDamage()));
        }
        if ((canStore = size) > inv.getStackInSlot(targetSlot).getMaxStackSize() - inv.getStackInSlot((int)targetSlot).stackSize) {
            canStore = inv.getStackInSlot(targetSlot).getMaxStackSize() - inv.getStackInSlot((int)targetSlot).stackSize;
        }
        if (canStore > inv.getInventoryStackLimit() - inv.getStackInSlot((int)targetSlot).stackSize) {
            canStore = inv.getInventoryStackLimit() - inv.getStackInSlot((int)targetSlot).stackSize;
        }
        if (canStore == 0) {
            return size;
        }
        inv.getStackInSlot((int)targetSlot).stackSize += canStore;
        return size -= canStore;
    }

    private static int getFirstEmptyStack(IInventory inv) {
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            if (inv.getStackInSlot(i) != null) continue;
            return i;
        }
        return -1;
    }

    public static boolean isInventoryFull(IInventory inv) {
        if (inv == null) {
            return false;
        }
        if (inv instanceof PC_IStateReportingInventory) {
            return ((PC_IStateReportingInventory)((Object)inv)).isContainerFull();
        }
        if (inv instanceof TileEntityFurnace) {
            return inv.getStackInSlot(1) != null && inv.getStackInSlot((int)1).stackSize == Math.min(inv.getInventoryStackLimit(), inv.getStackInSlot(1).getMaxStackSize());
        }
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            if (inv.getStackInSlot(i) != null && inv.getStackInSlot((int)i).stackSize >= Math.min(inv.getInventoryStackLimit(), inv.getStackInSlot(i).getMaxStackSize())) continue;
            return false;
        }
        return true;
    }

    public static boolean isInventoryEmpty(IInventory inv) {
        if (inv == null) {
            return true;
        }
        if (inv instanceof PC_IStateReportingInventory) {
            return ((PC_IStateReportingInventory)((Object)inv)).isContainerEmpty();
        }
        if (inv instanceof TileEntityFurnace) {
            return inv.getStackInSlot(1) == null;
        }
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            if (inv.getStackInSlot(i) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean moveStacks(IInventory from, IInventory to) {
        int copied = Math.min(from.getSizeInventory(), to.getSizeInventory());
        for (int i = 0; i < copied; ++i) {
            to.setInventorySlotContents(i, from.getStackInSlot(i));
            from.setInventorySlotContents(i, null);
        }
        return from.getSizeInventory() <= to.getSizeInventory();
    }

    public static int getPlayerArmourValue(EntityPlayerSP player) {
        return player.inventory.getTotalArmorValue();
    }

    public static int getFuelValue(ItemStack itemstack, double strength) {
        if (itemstack == null) {
            return 0;
        }
        int i = itemstack.getItem().shiftedIndex;
        if (i == Block.wood.blockID) {
            return (int)(1200.0 * strength);
        }
        if (i < 256 && Block.blocksList[i].blockMaterial == Material.wood) {
            return (int)(300.0 * strength);
        }
        if (i == Item.stick.shiftedIndex) {
            return (int)(100.0 * strength);
        }
        if (i == Item.paper.shiftedIndex) {
            return (int)(150.0 * strength);
        }
        if (i == Item.coal.shiftedIndex) {
            return (int)(1600.0 * strength);
        }
        if (i == Item.bucketLava.shiftedIndex) {
            return (int)(20000.0 * strength);
        }
        if (i == Block.sapling.blockID) {
            return (int)(100.0 * strength);
        }
        if (i == Item.gunpowder.shiftedIndex) {
            return (int)(500.0 * strength);
        }
        if (i == Item.blazeRod.shiftedIndex) {
            return (int)(2400.0 * strength);
        }
        return (int)((double)ModLoader.addAllFuel(i, itemstack.getItemDamage()) * strength);
    }

    public static int countPowerCrystals(IInventory inventory) {
        boolean[] foundTable = new boolean[]{false, false, false, false, false, false, false, false};
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            if (inventory.getStackInSlot(i) == null || inventory.getStackInSlot((int)i).itemID != mod_PCcore.powerCrystal.blockID) continue;
            foundTable[MathHelper.clamp_int((int)inventory.getStackInSlot((int)i).getItemDamage(), (int)0, (int)7)] = true;
        }
        int cnt = 0;
        for (int i = 0; i < 8; ++i) {
            if (!foundTable[i]) continue;
            ++cnt;
        }
        return cnt;
    }

    public static ItemStack[] mergeStacks(ItemStack[] input) {
        List<ItemStack> list = PC_InvUtils.stacksToList(input);
        PC_InvUtils.mergeStacks(list);
        return PC_InvUtils.stacksToArray(list);
    }

    public static void mergeStacks(List<ItemStack> input) {
        if (input == null) {
            return;
        }
        block0: for (ItemStack st1 : input) {
            if (st1 == null) continue;
            for (ItemStack st2 : input) {
                if (st2 == null || !st2.isItemEqual(st1)) continue;
                int movedToFirst = Math.min(st2.stackSize, st1.getItem().maxStackSize - st1.stackSize);
                if (movedToFirst <= 0) continue block0;
                st1.stackSize += movedToFirst;
                st2.stackSize -= movedToFirst;
            }
        }
        ArrayList<ItemStack> copy = new ArrayList<ItemStack>(input);
        for (int i = copy.size() - 1; i >= 0; --i) {
            if (copy.get(i) != null && copy.get((int)i).stackSize > 0) continue;
            input.remove(i);
        }
    }

    public static List<ItemStack> stacksToList(ItemStack[] stacks) {
        ArrayList<ItemStack> myList = new ArrayList<ItemStack>();
        Collections.addAll(myList, stacks);
        return myList;
    }

    public static ItemStack[] stacksToArray(List<ItemStack> stacks) {
        return stacks.toArray(new ItemStack[stacks.size()]);
    }
}

