/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.PC_PropertyManager;
import net.minecraft.src.StringTranslate;

public class PC_Lang {
    private HashMap<String, String> defaults;
    private String module;
    private static final String deflang = "en_US";

    public static String tr(String identifier) {
        return StringTranslate.getInstance().translateKey(identifier).trim();
    }

    public static String tr(String identifier, String[] replacements) {
        return StringTranslate.getInstance().translateKeyFormat(identifier, replacements);
    }

    public PC_Lang(String moduleName, HashMap<String, String> en_US) {
        this.defaults = en_US;
        this.module = moduleName;
        this.addLocalizations(deflang, this.defaults);
    }

    private void addLocalizations(String lang, HashMap<String, String> locs) {
        for (Map.Entry<String, String> a : locs.entrySet()) {
            ModLoader.addLocalization(a.getKey(), lang, a.getValue());
        }
    }

    public void loadTranstalions() {
        File folder = new File(Minecraft.getMinecraftDir(), "/PowerCraft/lang/");
        String[] files = folder.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.matches("[a-z]{2,3}_[A-Z]{2,3}-" + PC_Lang.this.module + "[.]lang");
            }
        });
        if (files == null) {
            PC_Logger.severe("Received NULL instead of list of translations.");
            return;
        }
        for (String filename : files) {
            PC_Logger.finest("* loading names from file " + filename + "...");
            String language = filename.substring(0, filename.indexOf(45));
            PC_PropertyManager p = new PC_PropertyManager("/PowerCraft/lang/" + filename, language + " translation of " + this.module + " module.");
            p.cfgSilent(true);
            for (Map.Entry<String, String> a : this.defaults.entrySet()) {
                p.putString(a.getKey(), a.getValue());
            }
            p.apply();
            for (String key : this.defaults.keySet()) {
                ModLoader.addLocalization(key, language, p.getString(key).trim());
            }
        }
        PC_Logger.finer("Translations loaded.");
    }

    public void generateDefaultTranslationFile() {
        PC_PropertyManager p = new PC_PropertyManager("/PowerCraft/lang/en_US-" + this.module + ".lang", "English (default, immutable) translation of " + this.module + " module.\n" + "To add your own translation, copy this file, change language prefix and transtalte the names.");
        p.cfgSilent(true);
        for (Map.Entry<String, String> a : this.defaults.entrySet()) {
            p.putString(a.getKey(), a.getValue());
        }
        p.apply();
    }
}

