/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.src.BaseMod;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_CraftingToolGroup;
import net.minecraft.src.PC_IActivatorListener;
import net.minecraft.src.PC_InveditManager;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.PC_PropertyManager;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.PC_Struct3;
import net.minecraft.src.PCco_CraftingToolManager;
import net.minecraft.src.PCco_ItemActivator;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntitySpecialRenderer;

public abstract class PC_Module
extends BaseMod {
    public static Minecraft mc;
    private PC_PropertyManager conf;
    public PC_Lang lang;
    public static final Hashtable<String, PC_Module> modules;

    public PC_PropertyManager cfg() {
        return this.conf;
    }

    public PC_Module() {
        modules.put(this.getModuleName(), this);
    }

    public abstract String getModuleName();

    public static final boolean isModuleLoaded(String name) {
        return modules.containsKey(name);
    }

    public static final PC_Module getModule(String name) {
        return modules.get(name);
    }

    @Override
    public abstract String getVersion();

    @Override
    public String getPriorities() {
        return "after:mod_PCcore";
    }

    @Override
    public void modsLoaded() {
        PC_InveditManager.sendToTMI();
    }

    private String getNameTagForObject(Object obj) {
        String name = null;
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Item) {
            Item item = (Item)obj;
            if (item.getItemName() != null) {
                name = String.valueOf(item.getItemName()) + ".name";
            }
        } else if (obj instanceof Block) {
            Block block = (Block)obj;
            if (block.getBlockName() != null) {
                name = String.valueOf(block.getBlockName()) + ".name";
            }
        } else if (obj instanceof ItemStack) {
            ItemStack itemstack = (ItemStack)obj;
            String s3 = Item.itemsList[itemstack.itemID].getItemNameIS(itemstack);
            if (s3 != null) {
                name = String.valueOf(s3) + ".name";
            }
        } else {
            PC_Logger.warning("Trying to add name to invalid object (not Block, Item or ItemStack)");
        }
        return name;
    }

    @Override
    public final void load() {
        try {
            if (mc == null) {
                mc = ModLoader.getMinecraftInstance();
                PC_Logger.fine("\nInitializing Minecraft instance.");
            }
            PC_Logger.fine("\n\nLoading module " + this.getModuleName());
            PC_Logger.finer("Calling pre-init hook...");
            this.preInit();
            PC_Logger.finer("Initializing properties...");
            this.conf = new PC_PropertyManager("/PowerCraft/" + this.getModuleName() + ".cfg", "PowerCraft " + this.getModuleName() + " module\nconfiguration file");
            this.initProperties(this.conf);
            PC_Logger.finer("Registering entities...");
            ArrayList<PC_Struct3<Class<? extends Entity>, String, Integer>> entities = new ArrayList<PC_Struct3<Class<? extends Entity>, String, Integer>>();
            this.registerEntities(entities);
            for (PC_Struct3<Class<? extends Entity>, String, Integer> entry : entities) {
                ModLoader.registerEntityID(entry.getA(), entry.getB(), entry.getC());
            }
            PC_Logger.finer("Registering tile entities...");
            ArrayList<PC_Struct3<Class<? extends TileEntity>, String, TileEntitySpecialRenderer>> tileentities = new ArrayList<PC_Struct3<Class<? extends TileEntity>, String, TileEntitySpecialRenderer>>();
            this.registerTileEntities(tileentities);
            for (PC_Struct3<Class<? extends TileEntity>, String, TileEntitySpecialRenderer> entry : tileentities) {
                if (entry.c == null) {
                    ModLoader.registerTileEntity((Class)entry.a, (String)entry.b);
                    continue;
                }
                ModLoader.registerTileEntity((Class)entry.a, (String)entry.b, (TileEntitySpecialRenderer)entry.c);
            }
            PC_Logger.finer("Registering block model renderers...");
            this.registerBlockRenderers();
            PC_Logger.finer("Registering blocks...");
            ArrayList<Block> blocks = new ArrayList<Block>();
            this.registerBlocks(blocks);
            for (Block block : blocks) {
                ModLoader.registerBlock(block);
            }
            PC_Logger.finer("Registering items...");
            this.registerItems();
            PC_Logger.finer("Preloading textures...");
            ArrayList<String> textures = new ArrayList<String>();
            this.preloadTextures(textures);
            for (String texture : textures) {
                PC_Renderer.preloadTexture(texture);
            }
            PC_Logger.finer("Adding texture overrides...");
            this.setTextures();
            PC_Logger.finer("Adding default names...");
            HashMap<Object, String> names = new HashMap<Object, String>();
            HashMap<String, String> en_US = new HashMap<String, String>();
            this.setNames(names);
            for (Map.Entry<Object, String> loc : names.entrySet()) {
                if (loc.getKey() == null || loc.getValue() == null) {
                    PC_Logger.severe("Trying to use null when adding names.");
                    continue;
                }
                String nametag = this.getNameTagForObject(loc.getKey());
                if (nametag == null) {
                    PC_Logger.severe("Setting name to invalid object.");
                    continue;
                }
                en_US.put(nametag, loc.getValue());
            }
            this.lang = new PC_Lang(this.getModuleName(), en_US);
            PC_Logger.finer("Generating default translation file (en_US) if not exists");
            this.lang.generateDefaultTranslationFile();
            PC_Logger.finer("Loading translations from /PowerCraft/lang");
            this.lang.loadTranstalions();
            PC_Logger.finer("Adding recipes...");
            this.addRecipes();
            PC_Logger.finer("Calling post-init hook...");
            this.postInit();
            PC_Logger.fine("Module loaded");
        }
        catch (RuntimeException e) {
            PC_Logger.severe("\nAn error occured, probably due to wrong IDs in your property files.");
            PC_Logger.severe("Read this log file carefully to locate the problem.\n\n");
            PC_Logger.throwing("PowerCraft module " + this.getModuleName() + " - method name: " + this.getName(), "load()", e);
            throw e;
        }
    }

    public static final void addStackRangeToCraftingTool(PC_CraftingToolGroup group, int id, int damage1, int damage2, int stackSize) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int dmg = damage1; dmg <= damage2; ++dmg) {
            list.add(new ItemStack(id, stackSize, dmg));
        }
        PCco_CraftingToolManager.addStacks(group.index, list.toArray(new ItemStack[list.size()]));
    }

    public static final void addStacksToCraftingTool(PC_CraftingToolGroup group, ItemStack ... stacks) {
        PCco_CraftingToolManager.addStacks(group.index, stacks);
    }

    public static final void registerActivatorListener(PC_IActivatorListener listener) {
        PCco_ItemActivator.registerListener(listener);
    }

    public static final void removeBlockItem(int id) {
        Item.itemsList[id] = null;
    }

    public static final void setBlockItem(int id, Item item) {
        Item.itemsList[id] = item;
    }

    public abstract void preInit();

    public abstract void initProperties(PC_PropertyManager var1);

    public abstract void registerEntities(List<PC_Struct3<Class<? extends Entity>, String, Integer>> var1);

    public abstract void registerTileEntities(List<PC_Struct3<Class<? extends TileEntity>, String, TileEntitySpecialRenderer>> var1);

    public abstract void registerBlockRenderers();

    public abstract void registerBlocks(List<Block> var1);

    public abstract void registerItems();

    public abstract void preloadTextures(List<String> var1);

    public abstract void setTextures();

    public abstract void setNames(Map<Object, String> var1);

    public abstract void addRecipes();

    public abstract void postInit();

    static {
        modules = new Hashtable();
    }
}

