/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.FurnaceRecipes;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_GresGui;
import net.minecraft.src.PC_IGresBase;
import net.minecraft.src.PC_INBT;
import net.minecraft.src.mod_PCcore;

public class PC_Utils {
    public static Minecraft mc() {
        return ModLoader.getMinecraftInstance();
    }

    public static boolean isCreative() {
        return ModLoader.getMinecraftInstance().playerController.isInCreativeMode();
    }

    public static boolean areObjectsEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static void openGres(EntityPlayer entityplayer, PC_IGresBase gres) {
        ModLoader.openGUI(entityplayer, new PC_GresGui(gres));
    }

    public static void openGui(EntityPlayer entityplayer, GuiScreen gui) {
        ModLoader.openGUI(entityplayer, gui);
    }

    public static void writeWrappedToNBT(NBTTagCompound parent, String wrapperTagName, PC_INBT stored) {
        NBTTagCompound tag = new NBTTagCompound();
        stored.writeToNBT(tag);
        parent.setCompoundTag(wrapperTagName, tag);
    }

    public static void readWrappedFromNBT(NBTTagCompound parent, String wrapperTagName, PC_INBT loaded) {
        loaded.readFromNBT(parent.getCompoundTag(wrapperTagName));
    }

    public static boolean isFuel(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        int i = itemstack.getItem().shiftedIndex;
        return i < 256 && Block.blocksList[i] != null && Block.blocksList[i].blockMaterial == Material.wood || i == Item.stick.shiftedIndex || i == Item.coal.shiftedIndex || i == Item.bucketLava.shiftedIndex || i == Block.sapling.blockID || ModLoader.addAllFuel(i, itemstack.getItemDamage()) > 0;
    }

    public static boolean isSmeltable(ItemStack itemstack) {
        return itemstack != null && FurnaceRecipes.smelting().getSmeltingResult(itemstack.getItem().shiftedIndex) != null;
    }

    public static boolean isPlacingReversed() {
        return mod_PCcore.instance.cfg().isKeyDown("global.key.reverse_placing");
    }

    public static int reverseSide(int l) {
        if (l == 0) {
            l = 2;
        } else if (l == 2) {
            l = 0;
        } else if (l == 1) {
            l = 3;
        } else if (l == 3) {
            l = 1;
        }
        return l;
    }

    public static void chatMsg(String msg, boolean clear) {
        if (clear) {
            ModLoader.getMinecraftInstance().ingameGUI.clearChatMessages();
        }
        ModLoader.getMinecraftInstance().thePlayer.addChatMessage(msg);
    }

    public static List<Integer> parseIntList(String list) {
        if (list == null) {
            return null;
        }
        String[] parts = list.split(",");
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (String part : parts) {
            try {
                intList.add(Integer.parseInt(part));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return intList;
    }

    public static String floatToString(float f) {
        String s = Float.toString(f);
        s = s.replaceAll("([0-9]+\\.[0-9]+)00+[0-9]+", "$1");
        s = s.replaceAll("0+$", "");
        s = s.replaceAll("\\.$", "");
        return s;
    }

    public static String doubleToString(double d) {
        String s = Double.toString(d);
        s = s.replaceAll("([0-9]+\\.[0-9]+)00+[0-9]+", "$1");
        s = s.replaceAll("0+$", "");
        s = s.replaceAll("\\.$", "");
        return s;
    }

    public static double ticksToSecs(int ticks) {
        return (double)ticks * 0.05;
    }

    public static int ticksToSecsInt(int ticks) {
        return Math.round((float)ticks * 0.05f);
    }

    public static int secsToTicks(double secs) {
        return (int)Math.round(secs * 20.0);
    }

    public static String formatTimeTicks(int ticks) {
        return PC_Utils.formatTimeSecs(PC_Utils.ticksToSecsInt(ticks));
    }

    public static String formatTimeSecs(int secs) {
        int mins = 0;
        int hours = 0;
        if (secs >= 60) {
            mins = secs / 60;
            secs %= 60;
        }
        if (mins >= 60) {
            hours = mins / 60;
            mins %= 60;
        }
        return (hours > 0 ? hours + ":" : "") + (hours > 0 || mins > 0 ? mins + ":" : "") + secs;
    }
}

