/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockBreakable;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PC_Color;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PCco_Renderer;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCcore;

public class PCco_BlockPowerCrystal
extends BlockBreakable
implements PC_ISwapTerrain,
ITextureProvider {
    public static boolean makeSound;

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        this.onBlockPlaced(world, i, j, k, 0);
    }

    @Override
    public int getBlockColor() {
        return PC_Color.crystal_colors[2];
    }

    @Override
    public int getRenderColor(int i) {
        return PC_Color.crystal_colors[MathHelper.clamp_int(i, 0, 7)];
    }

    @Override
    public int colorMultiplier(IBlockAccess iblockaccess, int i, int j, int k) {
        return PC_Color.crystal_colors[MathHelper.clamp_int(iblockaccess.getBlockMetadata(i, j, k), 0, 7)];
    }

    public PCco_BlockPowerCrystal(int i, int j) {
        super(i, j, Material.glass, false);
    }

    @Override
    public int getRenderBlockPass() {
        return 1;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return true;
    }

    @Override
    public int quantityDropped(Random random) {
        return 1;
    }

    @Override
    protected int damageDropped(int i) {
        return i;
    }

    @Override
    public int idDropped(int i, Random random, int j) {
        return this.blockID;
    }

    @Override
    public int getMobilityFlag() {
        return 0;
    }

    @Override
    public String getTerrainFile() {
        return mod_PCcore.getTerrainFile();
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return PCco_Renderer.crystalRenderer;
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        int meta;
        EntityPlayer player;
        int id_under = world.getBlockId(i, j - 1, k);
        if (makeSound && mod_PCcore.soundsEnabled && (player = world.getClosestPlayer((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, 12.0)) != null && (id_under == Block.stone.blockID || id_under == 7 || id_under == this.blockID)) {
            int distance = (int)Math.round(player.getDistanceSq((double)i + 0.5, (double)j + 0.5, (double)k + 0.5) / 10.0);
            if (distance == 0) {
                distance = 1;
            }
            if (random.nextInt(distance) == 0) {
                world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.orb", 0.15f, 0.5f * ((random.nextFloat() - random.nextFloat()) * 0.7f + 1.8f));
            }
        }
        if ((meta = world.getBlockMetadata(i, j, k)) == 8) {
            world.setBlockMetadataWithNotify(i, j, k, 0);
            meta = 0;
        }
        double r = PC_Color.red(this.getRenderColor(meta));
        double g = PC_Color.green(this.getRenderColor(meta));
        double b = PC_Color.blue(this.getRenderColor(meta));
        r = r > 0.0 ? r : 0.001;
        g = g > 0.0 ? g : 0.001;
        b = b > 0.0 ? b : 0.001;
        float y = (float)j + random.nextFloat();
        float x = (float)i + random.nextFloat();
        float z = (float)k + random.nextFloat();
        world.spawnParticle("reddust", x, y, z, r, g, b);
    }
}

