/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.PC_PropertyManager;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.World;
import net.minecraft.src.mod_PCcore;

public class PCco_ItemOreSniffer
extends Item {
    private static String[] names = new String[4096];

    public PCco_ItemOreSniffer(int i) {
        super(i);
        this.setMaxStackSize(1);
        this.setMaxDamage(500);
    }

    private String makeNameId(int id) {
        String f = "0000" + Integer.toString(id);
        return "block_" + f.substring(f.length() - 4);
    }

    public void initNames() {
        PC_Logger.finer("Loading sniffer colors.");
        PC_PropertyManager namecfg = new PC_PropertyManager("/PowerCraft/sniffer_colors.cfg", "PowerCraft Mobile module\n*** Setup file for Ore Sniffer tool ***\n\nSyntax: block_NNNN = CL (C = color, L = one letter).\n\n Colors:\n 0 black\n 1 dark blue\n 2 dark green\n 3 dark aqua\n 4 dark red\n 5 purple\n 6 gold-orange\n 7 grey\n 8 dark grey\n 9 indigo\n a bright green\n b aqua\n c red\n d pink\n e yellow\n f white");
        namecfg.cfgSeparateSections(false);
        PCco_ItemOreSniffer.names[0] = "f ";
        Integer q = 1;
        while (q < 4096) {
            Block bl = Block.blocksList[q];
            if (bl != null && names[q] == null) {
                PCco_ItemOreSniffer.names[q.intValue()] = "\u00a7f-";
                if (namecfg.getString(this.makeNameId(q)) != null && namecfg.getString(this.makeNameId(q)).length() == 1) {
                    PCco_ItemOreSniffer.names[q.intValue()] = namecfg.getString(this.makeNameId(q));
                } else if (bl.hasTileEntity()) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "d$";
                } else if (bl.blockMaterial == Material.leaves || bl.blockMaterial == Material.plants || bl.blockMaterial == Material.vine) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "a&";
                } else if (bl.blockMaterial == Material.ground) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "8%";
                } else if (bl.blockMaterial == Material.wood) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "6W";
                } else if (bl.blockMaterial == Material.iron) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "4#";
                } else if (bl.blockMaterial == Material.cloth) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "f%";
                } else if (bl.blockMaterial == Material.fire) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "cf";
                } else if (bl.blockMaterial == Material.circuits || bl.blockMaterial == Material.redstoneLight) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "4.";
                } else if (bl.blockMaterial == Material.glass || bl.blockMaterial == Material.ice) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "b#";
                } else if (bl.blockMaterial == Material.snow) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "f_";
                } else if (bl.blockMaterial == Material.craftedSnow) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "f#";
                } else if (bl.blockMaterial == Material.cactus) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "2#";
                } else if (bl.blockMaterial == Material.clay) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "7C";
                } else if (bl.blockMaterial == Material.pumpkin) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "6P";
                } else if (bl.blockMaterial == Material.portal) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "5P";
                } else if (bl.blockMaterial == Material.web) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "f.";
                } else if (bl.blockMaterial == Material.piston) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "4=";
                } else if (bl.blockMaterial.isSolid()) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "8#";
                } else if (bl.blockMaterial.isLiquid()) {
                    PCco_ItemOreSniffer.names[q.intValue()] = "9~";
                }
                namecfg.putString(this.makeNameId(q), names[q]);
            }
            Integer n = q;
            Integer n2 = q = Integer.valueOf(q + 1);
        }
        namecfg.putString(this.makeNameId(Block.stone.blockID), "8#");
        namecfg.putString(this.makeNameId(Block.waterMoving.blockID), "9~");
        namecfg.putString(this.makeNameId(Block.waterStill.blockID), "9~");
        namecfg.putString(this.makeNameId(Block.lavaMoving.blockID), "c*");
        namecfg.putString(this.makeNameId(Block.lavaStill.blockID), "c*");
        namecfg.putString(this.makeNameId(Block.bedrock.blockID), "0@");
        namecfg.putString(this.makeNameId(Block.oreCoal.blockID), "7C");
        namecfg.putString(this.makeNameId(Block.oreDiamond.blockID), "bD");
        namecfg.putString(this.makeNameId(Block.oreLapis.blockID), "1L");
        namecfg.putString(this.makeNameId(Block.oreIron.blockID), "7I");
        namecfg.putString(this.makeNameId(Block.oreGold.blockID), "6G");
        namecfg.putString(this.makeNameId(Block.oreRedstone.blockID), "cR");
        namecfg.putString(this.makeNameId(Block.oreRedstoneGlowing.blockID), "cR");
        namecfg.putString(this.makeNameId(Block.blockDiamond.blockID), "bD");
        namecfg.putString(this.makeNameId(Block.blockLapis.blockID), "1L");
        namecfg.putString(this.makeNameId(Block.blockSteel.blockID), "7I");
        namecfg.putString(this.makeNameId(Block.blockGold.blockID), "6G");
        namecfg.putString(this.makeNameId(Block.dirt.blockID), "4%");
        namecfg.putString(this.makeNameId(Block.grass.blockID), "2%");
        namecfg.putString(this.makeNameId(Block.gravel.blockID), "7%");
        namecfg.putString(this.makeNameId(Block.sand.blockID), "e%");
        namecfg.putString(this.makeNameId(Block.torchWood.blockID), "ft");
        namecfg.putString(this.makeNameId(Block.torchRedstoneIdle.blockID), "4t");
        namecfg.putString(this.makeNameId(Block.torchRedstoneActive.blockID), "ct");
        namecfg.putString(this.makeNameId(Block.redstoneWire.blockID), "cr");
        namecfg.putString(this.makeNameId(Block.cobblestone.blockID), "8#");
        namecfg.putString(this.makeNameId(Block.stoneBrick.blockID), "8#");
        namecfg.putString(this.makeNameId(Block.sandStone.blockID), "6#");
        namecfg.putString(this.makeNameId(Block.obsidian.blockID), "1O");
        namecfg.putString(this.makeNameId(Block.planks.blockID), "6W");
        namecfg.putString(this.makeNameId(Block.wood.blockID), "6W");
        namecfg.putString(this.makeNameId(Block.rail.blockID), "f_");
        namecfg.putString(this.makeNameId(Block.railPowered.blockID), "f_");
        namecfg.putString(this.makeNameId(Block.railDetector.blockID), "f_");
        namecfg.putString(this.makeNameId(Block.ladder.blockID), "6|");
        namecfg.putString(this.makeNameId(Block.fence.blockID), "6+");
        namecfg.putString(this.makeNameId(Block.pressurePlateStone.blockID), "7_");
        namecfg.putString(this.makeNameId(Block.pressurePlatePlanks.blockID), "6_");
        namecfg.putString(this.makeNameId(Block.mushroomBrown.blockID), "4m");
        namecfg.putString(this.makeNameId(Block.mushroomRed.blockID), "cm");
        namecfg.putString(this.makeNameId(Block.mushroomCapBrown.blockID), "4M");
        namecfg.putString(this.makeNameId(Block.mushroomCapRed.blockID), "cM");
        namecfg.putString(this.makeNameId(Block.glowStone.blockID), "e#");
        namecfg.putString(this.makeNameId(Block.redstoneLampIdle.blockID), "e#");
        namecfg.putString(this.makeNameId(Block.redstoneLampActive.blockID), "e#");
        namecfg.putString(this.makeNameId(Block.netherrack.blockID), "4#");
        namecfg.putString(this.makeNameId(Block.slowSand.blockID), "7%");
        namecfg.putString(this.makeNameId(Block.netherBrick.blockID), "4#");
        namecfg.putString(this.makeNameId(Block.netherStalk.blockID), "c&");
        namecfg.putString(this.makeNameId(Block.whiteStone.blockID), "f#");
        namecfg.putString(this.makeNameId(mod_PCcore.powerCrystal.blockID), "aX");
        namecfg.putString(this.makeNameId(mod_PCcore.powerCrystal.blockID), "aX");
        namecfg.apply();
        for (int i = 0; i < 4096; ++i) {
            if (namecfg.getString(this.makeNameId(i)) == null) continue;
            PCco_ItemOreSniffer.names[i] = namecfg.getString(this.makeNameId(i));
        }
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l) {
        int[] offsetX = new int[]{0, 0, 0, 0, 1, -1};
        int[] offsetZ = new int[]{0, 0, 1, -1, 0, 0};
        int[] offsetY = new int[]{1, -1, 0, 0, 0, 0};
        int MoveX = offsetX[l];
        int MoveY = offsetY[l];
        int MoveZ = offsetZ[l];
        ArrayList<Integer> blocks = new ArrayList<Integer>(35);
        int shift = 0;
        if (entityplayer.isSneaking()) {
            shift = 36;
        }
        for (int q = shift; q < shift + 35; ++q) {
            blocks.add(world.getBlockId(i + MoveX * q, j + MoveY * q, k + MoveZ * q));
        }
        String msg = "";
        for (Integer id : blocks) {
            msg = msg + "\u00a7" + names[id];
        }
        PC_Utils.chatMsg("\u00a77" + PC_Lang.tr("pc.sniffer.sniffing") + (shift > 0 ? "  " + PC_Lang.tr("pc.sniffer.away") : ""), true);
        PC_Utils.chatMsg("\u00a77>\u00a7f " + msg + " \u00a77<", false);
        itemstack.damageItem(1, entityplayer);
        return false;
    }

    @Override
    public void addInformation(ItemStack itemstack, List list) {
        list.add(PC_Lang.tr("pc.sniffer.desc"));
    }
}

