/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.src.CraftingManager;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IRecipe;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.ShapedRecipes;
import net.minecraft.src.ShapelessRecipes;
import net.minecraft.src.Slot;
import org.lwjgl.input.Keyboard;

public class PCco_SlotDirectCrafting
extends Slot {
    public static boolean recursiveCrafting = true;
    public static boolean survivalCheating = false;
    private EntityPlayer thePlayer;
    public ItemStack product;
    private static final int RECURSION_LIMIT = 50;
    private boolean available = false;
    private Hashtable<String, Integer> allocatedStacks = new Hashtable();
    private int lastRecipe = -1;
    private int recursionCount = 0;
    private ArrayList<String> stacksSeekedInThisRecursion = new ArrayList();
    private ArrayList<String> recipeBannedStacks = new ArrayList();
    private ArrayList<ItemStack> toConsume = new ArrayList();
    private ArrayList<ItemStack> toGiveBack = new ArrayList();

    public PCco_SlotDirectCrafting(EntityPlayer entityplayer, ItemStack product, int index, int x, int y) {
        super(null, index, x, y);
        this.thePlayer = entityplayer;
        this.product = product;
    }

    @Override
    public boolean isItemValid(ItemStack itemstack) {
        return false;
    }

    @Override
    public void onPickupFromSlot(ItemStack itemstack) {
        super.onPickupFromSlot(itemstack);
        this.doCrafting();
        this.updateAvailability();
    }

    @Override
    public ItemStack decrStackSize(int i) {
        if (this.available) {
            ItemStack output = this.product.copy();
            if ((PC_Utils.isCreative() || survivalCheating) && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157))) {
                output.stackSize = output.getMaxStackSize();
            }
            return output;
        }
        return null;
    }

    @Override
    public ItemStack getStack() {
        if (this.available && this.product != null) {
            ItemStack output = this.product.copy();
            if ((PC_Utils.isCreative() || survivalCheating) && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157))) {
                output.stackSize = output.getMaxStackSize();
            }
            return output;
        }
        return null;
    }

    @Override
    public void putStack(ItemStack itemstack) {
    }

    public void setProduct(ItemStack itemstack) {
        this.product = itemstack;
    }

    @Override
    public void onSlotChanged() {
    }

    @Override
    public int getSlotStackLimit() {
        if (this.product == null) {
            return 1;
        }
        return this.product.getMaxStackSize();
    }

    private boolean isAvailable() {
        IRecipe irecipe;
        if (this.product == null) {
            return false;
        }
        if (ModLoader.getMinecraftInstance().playerController.isInCreativeMode() || survivalCheating) {
            return true;
        }
        this.lastRecipe = -1;
        int recipe_number = -1;
        do {
            this.lastRecipe = recipe_number;
            irecipe = this.getNextRecipeForProduct(this.product);
            recipe_number = this.lastRecipe;
            if (irecipe == null) {
                return false;
            }
            this.recursionCount = 0;
            this.allocatedStacks.clear();
            this.toConsume.clear();
            this.toGiveBack.clear();
            this.stacksSeekedInThisRecursion.clear();
            this.recipeBannedStacks.clear();
            this.recipeBannedStacks.add(this.getStackDescriptor(this.product));
            this.recipeBannedStacks.add(this.getStackDescriptorAnyMeta(this.product));
        } while (!this.tryToFindMaterialsForRecipe(irecipe) || this.toConsume.size() == 1 && this.toConsume.get(0).isItemEqual(this.product) || this.toConsume.get((int)0).itemID == this.product.itemID && this.toConsume.get(0).getItemDamage() == -1);
        return true;
    }

    private void doCrafting() {
        IRecipe irecipe;
        if (this.product == null) {
            return;
        }
        if (ModLoader.getMinecraftInstance().playerController.isInCreativeMode() || survivalCheating) {
            return;
        }
        this.lastRecipe = -1;
        int recipe_number = -1;
        do {
            this.lastRecipe = recipe_number;
            irecipe = this.getNextRecipeForProduct(this.product);
            recipe_number = this.lastRecipe;
            if (irecipe == null) {
                return;
            }
            this.recursionCount = 0;
            this.allocatedStacks.clear();
            this.toConsume.clear();
            this.toGiveBack.clear();
            this.stacksSeekedInThisRecursion.clear();
            this.recipeBannedStacks.clear();
            this.recipeBannedStacks.add(this.getStackDescriptor(this.product));
            this.recipeBannedStacks.add(this.getStackDescriptorAnyMeta(this.product));
        } while (!this.tryToFindMaterialsForRecipe(irecipe) || this.toConsume.size() == 1 && this.toConsume.get(0).isItemEqual(this.product) || this.toConsume.get((int)0).itemID == this.product.itemID && this.toConsume.get(0).getItemDamage() == -1);
        for (ItemStack stack : this.toConsume) {
            this.consumePlayerItems(stack, stack.stackSize);
        }
        if (irecipe.getRecipeOutput().stackSize > this.product.stackSize) {
            this.toGiveBack.add(new ItemStack(irecipe.getRecipeOutput().itemID, irecipe.getRecipeOutput().stackSize - this.product.stackSize, this.product.getItemDamage()));
        }
        for (ItemStack stack : this.toGiveBack) {
            this.thePlayer.inventory.addItemStackToInventory(stack);
            if (stack.stackSize <= 0) continue;
            this.thePlayer.dropPlayerItem(stack);
        }
    }

    private String getStackDescriptor(ItemStack stack) {
        return Item.itemsList[stack.itemID].getItemName() + "@" + stack.getItemDamage();
    }

    private String getStackDescriptorAnyMeta(ItemStack stack) {
        return Item.itemsList[stack.itemID].getItemName() + "@-1";
    }

    private boolean allocatePlayerItems(ItemStack stack1, int needed) {
        if (stack1 == null) {
            return true;
        }
        if (this.recipeBannedStacks.contains(this.getStackDescriptor(stack1))) {
            return false;
        }
        Integer alloc = this.allocatedStacks.get(this.getStackDescriptor(stack1));
        if (alloc == null) {
            alloc = 0;
        }
        if (ModLoader.getMinecraftInstance().playerController.isInCreativeMode() || survivalCheating) {
            return true;
        }
        int counter = 0;
        for (int i = 0; i < this.thePlayer.inventory.getSizeInventory(); ++i) {
            ItemStack curStack = this.thePlayer.inventory.getStackInSlot(i);
            if (curStack == null || !curStack.isItemEqual(stack1) && (curStack.itemID != stack1.itemID || stack1.getItemDamage() != -1) || (counter += curStack.stackSize) - alloc < needed) continue;
            this.allocatedStacks.put(this.getStackDescriptor(stack1), alloc + needed);
            return true;
        }
        if (counter - alloc >= needed) {
            this.allocatedStacks.put(this.getStackDescriptor(stack1), alloc + needed);
            return true;
        }
        return false;
    }

    private int countPlayerItems(ItemStack wanted) {
        if (wanted == null) {
            return 0;
        }
        if (this.recipeBannedStacks.contains(this.getStackDescriptor(wanted))) {
            return 0;
        }
        Integer alloc = this.allocatedStacks.get(this.getStackDescriptor(wanted));
        if (alloc == null) {
            alloc = 0;
        }
        if (ModLoader.getMinecraftInstance().playerController.isInCreativeMode() || survivalCheating) {
            return -1;
        }
        int counter = 0;
        for (int i = 0; i < this.thePlayer.inventory.getSizeInventory(); ++i) {
            ItemStack curStack = this.thePlayer.inventory.getStackInSlot(i);
            if (curStack == null || !curStack.isItemEqual(wanted) && (curStack.itemID != wanted.itemID || wanted.getItemDamage() != -1)) continue;
            counter += curStack.stackSize;
        }
        return counter - alloc;
    }

    private boolean consumePlayerItems(ItemStack stack1, int count) {
        if (ModLoader.getMinecraftInstance().playerController.isInCreativeMode() || survivalCheating) {
            return true;
        }
        if (stack1 == null) {
            return true;
        }
        for (int i = 0; i < this.thePlayer.inventory.getSizeInventory(); ++i) {
            ItemStack curStack = this.thePlayer.inventory.getStackInSlot(i);
            if (curStack == null || !curStack.isItemEqual(stack1) && (curStack.itemID != stack1.itemID || stack1.getItemDamage() != -1)) continue;
            if (curStack.stackSize > count) {
                curStack.stackSize -= count;
                return true;
            }
            if (curStack.stackSize > count) continue;
            count -= curStack.stackSize;
            this.thePlayer.inventory.setInventorySlotContents(i, null);
        }
        return count <= 0;
    }

    private IRecipe getNextRecipeForProduct(ItemStack prod) {
        int k;
        ArrayList recipes = new ArrayList(CraftingManager.getInstance().getRecipeList());
        if (this.lastRecipe == recipes.size() - 1) {
            return null;
        }
        for (k = this.lastRecipe + 1; k < recipes.size(); ++k) {
            IRecipe irecipe = (IRecipe)recipes.get(k);
            try {
                if (!irecipe.getRecipeOutput().isItemEqual(prod) && (irecipe.getRecipeOutput().itemID != prod.itemID || prod.getItemDamage() != -1)) continue;
                this.lastRecipe = k;
                return irecipe;
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        this.lastRecipe = k;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private boolean tryToFindMaterialsForRecipe(IRecipe irecipe) {
        if (ModLoader.getMinecraftInstance().playerController.isInCreativeMode() || PCco_SlotDirectCrafting.survivalCheating) {
            return true;
        }
        ++this.recursionCount;
        if (this.recursionCount > 50) {
            return false;
        }
        try {
            if (irecipe instanceof ShapedRecipes) {
                tmps = (ItemStack[])ModLoader.getPrivateValue(ShapedRecipes.class, (Object)irecipe, 2);
            } else if (irecipe instanceof ShapelessRecipes) {
                foo = (List)ModLoader.getPrivateValue(ShapelessRecipes.class, (Object)irecipe, 1);
                tmps = foo.toArray(new ItemStack[foo.size()]);
            } else {
                return false;
            }
            recipeStacks = new ItemStack[tmps.length];
            for (i = 0; i < tmps.length; ++i) {
                if (tmps[i] == null) continue;
                recipeStacks[i] = tmps[i].copy();
            }
            for (i = 0; i < recipeStacks.length; ++i) {
                if (recipeStacks[i] == null) continue;
                recipeStacks[i].stackSize = 1;
                for (j = i + 1; j < recipeStacks.length; ++j) {
                    if (recipeStacks[j] == null || !recipeStacks[j].isItemEqual(recipeStacks[i])) continue;
                    ++recipeStacks[i].stackSize;
                    recipeStacks[j] = null;
                }
            }
            for (i = 0; i < recipeStacks.length; ++i) {
                if (recipeStacks[i] == null) continue;
                if (!this.allocatePlayerItems(recipeStacks[i], recipeStacks[i].stackSize)) {
                    if (!PCco_SlotDirectCrafting.recursiveCrafting) {
                        return false;
                    }
                    if (this.stacksSeekedInThisRecursion.contains(this.getStackDescriptor(recipeStacks[i]))) {
                        return false;
                    }
                    if (this.recipeBannedStacks.contains(this.getStackDescriptor(recipeStacks[i]))) {
                        return false;
                    }
                    if (this.recursionCount > 50) {
                        return false;
                    }
                    needed = recipeStacks[i].copy();
                    availableDirectly = this.countPlayerItems(needed);
                    if (availableDirectly > 0) {
                        needed.stackSize -= availableDirectly;
                        alloc = this.allocatedStacks.get(this.getStackDescriptor(needed));
                        if (alloc == null) {
                            alloc = 0;
                        }
                        this.allocatedStacks.put(this.getStackDescriptor(needed), alloc + availableDirectly);
                        consumed = new ItemStack(needed.itemID, availableDirectly, needed.getItemDamage());
                        this.toConsume.add(consumed);
                        if (needed.stackSize <= 0) continue;
                    }
                    anymeta = false;
                    tmpmeta = 0;
                    if (needed.getItemDamage() < 0) {
                        needed.setItemDamage(tmpmeta);
                        anymeta = true;
                    }
                    recipe_number = -1;
                    block8: while (true) {
                        this.lastRecipe = recipe_number;
                        irecipe2 = this.getNextRecipeForProduct(needed);
                        recipe_number = this.lastRecipe;
                        if (irecipe2 == null) {
                            if (anymeta && tmpmeta <= 15) {
                                needed.setItemDamage(++tmpmeta);
                                recipe_number = -1;
                                continue;
                            }
                            return false;
                        }
                        do {
                            this.stacksSeekedInThisRecursion.add(this.getStackDescriptor(recipeStacks[i]));
                            if (this.tryToFindMaterialsForRecipe(irecipe2)) ** break;
                            continue block8;
                            this.stacksSeekedInThisRecursion.remove(this.getStackDescriptor(recipeStacks[i]));
                            needed.stackSize -= irecipe2.getRecipeOutput().stackSize;
                        } while (needed.stackSize > 0);
                        break;
                    }
                    if (needed.stackSize >= 0) continue;
                    got = needed.copy();
                    got.stackSize = Math.abs(got.stackSize);
                    if (got.getItemDamage() < 0) {
                        got.setItemDamage(0);
                    }
                    this.toGiveBack.add(got);
                    continue;
                }
                this.toConsume.add(recipeStacks[i]);
            }
            return true;
        }
        catch (IllegalArgumentException et) {
            et.printStackTrace();
        }
        catch (SecurityException es) {
            es.printStackTrace();
        }
        catch (NoSuchFieldException en) {
            en.printStackTrace();
        }
        return false;
    }

    public void updateAvailability() {
        this.available = this.isAvailable();
    }
}

