/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.PC_Module;
import net.minecraft.src.PC_PropertyManager;
import net.minecraft.src.mod_PCcore;

public class PCco_ThreadDownloadTranslations
extends Thread {
    @Override
    public void run() {
        try {
            URL url = new URL("http://dl.dropbox.com/u/64454818/POWERCRAFT_DATA/lang.zip");
            ZipInputStream zin = new ZipInputStream(url.openStream());
            PC_Logger.fine("\n\nLanguage pack update v" + mod_PCcore.updateLangVersion + " downloaded.");
            PC_Logger.fine("Starting extraction of language files");
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                File file = new File(Minecraft.getMinecraftDir() + "/PowerCraft" + "/lang/" + ze.getName());
                if (ze.getName().matches("en_US.+")) {
                    PC_Logger.finer(" - SKIPPING " + ze.getName());
                    continue;
                }
                if (file.exists()) {
                    PC_Logger.finer(" - Updated " + ze.getName());
                    file.delete();
                } else {
                    PC_Logger.finer(" - New file " + ze.getName());
                }
                FileOutputStream fout = new FileOutputStream(file);
                int c = zin.read();
                while (c != -1) {
                    fout.write(c);
                    c = zin.read();
                }
                zin.closeEntry();
                fout.close();
            }
            zin.close();
            PC_Logger.fine("Language pack updated.\n\n");
            PC_Logger.fine("Loading translations from updated files.\n");
            for (PC_Module module : PC_Module.modules.values()) {
                PC_Logger.finer("Loading translations for module " + module.getModuleName());
                if (module.lang != null) {
                    module.lang.loadTranstalions();
                }
                PC_Logger.finer("\n");
            }
            PC_Logger.fine("All translations loaded.\n");
            PC_Logger.fine("Saving Language Pack version number to property file CORE.cfg");
            PC_PropertyManager cfg = mod_PCcore.instance.cfg();
            cfg.enableValidation(false);
            cfg.cfgSilent(true);
            cfg.setValue("cfg.currentLangVersion", mod_PCcore.updateLangVersion);
            cfg.apply();
            cfg.enableValidation(true);
            cfg.cfgSilent(false);
            PC_Logger.fine("Forcing ModLoader to update Minecraft's list of translations.");
            ModLoader.setPrivateValue(ModLoader.class, null, "langPack", null);
        }
        catch (Exception e) {
            PC_Logger.throwing("PCco_ThreadDownloadTranslations", "run", e);
            e.printStackTrace();
        }
    }
}

