/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCde_Renderer;
import net.minecraft.src.PCde_TileEntityDeco;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCdeco;

public class PCde_BlockDeco
extends BlockContainer
implements PC_IBlockType,
PC_ISwapTerrain,
ITextureProvider {
    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PCde_TileEntityDeco();
    }

    @Override
    public String getTerrainFile() {
        return mod_PCdeco.getTerrainFile();
    }

    public PCde_BlockDeco(int i, int j, Material material) {
        super(i, j, material);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int side, int meta) {
        if (meta == 0) {
            return 22;
        }
        if (meta == 1) {
            return 129;
        }
        return 0;
    }

    @Override
    public int colorMultiplier(IBlockAccess iblockaccess, int x, int y, int z) {
        PCde_TileEntityDeco ted = this.getTE(iblockaccess, x, y, z);
        if (ted.type == 0) {
            return 0xFFFFFF;
        }
        if (ted.type == 1) {
            return 0xCC0000;
        }
        return 0xFFFFFF;
    }

    @Override
    public int getRenderColor(int i) {
        if (i == 0) {
            return 0x999999;
        }
        if (i == 1) {
            return 0xCC0000;
        }
        return 0xFFFFFF;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        PCde_TileEntityDeco ted = this.getTE(iblockaccess, i, j, k);
        if (ted.type == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        if (ted.type == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, ArrayList arraylist) {
        PCde_TileEntityDeco ted = this.getTE(world, x, y, z);
        if (ted.type == 0 || ted.type == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            return;
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public PCde_TileEntityDeco getTE(IBlockAccess iblockaccess, int x, int y, int z) {
        TileEntity te = iblockaccess.getBlockTileEntity(x, y, z);
        if (te == null) {
            return null;
        }
        return (PCde_TileEntityDeco)te;
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        PCde_TileEntityDeco ted = this.getTE(iblockaccess, x, y, z);
        if (ted.type == 0) {
            return 22;
        }
        if (ted.type == 1) {
            return 129;
        }
        return 0;
    }

    @Override
    protected int damageDropped(int i) {
        return 0;
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return -1;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (iblockaccess.getBlockMetadata(i, j, k) == 0) {
            return true;
        }
        return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        PCde_TileEntityDeco teg = this.getTE(world, x, y, z);
        if (teg != null && !PC_Utils.isCreative()) {
            this.dropBlockAsItem_do(world, x, y, z, new ItemStack(mod_PCdeco.deco, 1, teg.type));
        }
        super.onBlockRemoval(world, x, y, z);
    }

    @Override
    public int getRenderBlockPass() {
        return 0;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return true;
    }

    @Override
    public int getRenderType() {
        return PCde_Renderer.decorativeBlockRenderer;
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        PCde_TileEntityDeco ted = this.getTE(world, pos.x, pos.y, pos.z);
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("DECORATIVE");
        set.add("PASSIVE");
        if (ted != null && ted.type == 1) {
            set.add("HARVEST_STOP");
        }
        if (ted != null && ted.type != 1) {
            set.add("TRANSLUCENT");
        }
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

