/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PC_BlockUtils;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCde_Renderer;
import net.minecraft.src.PCde_TileEntityWalkable;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCdeco;

public class PCde_BlockWalkable
extends BlockContainer
implements PC_IBlockType,
PC_ISwapTerrain,
ITextureProvider {
    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PCde_TileEntityWalkable();
    }

    @Override
    public String getTerrainFile() {
        return mod_PCdeco.getTerrainFile();
    }

    public PCde_BlockWalkable(int i, int j, Material material) {
        super(i, j, material);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int side, int meta) {
        if (meta == 0) {
            return 22;
        }
        return 0;
    }

    @Override
    public int colorMultiplier(IBlockAccess iblockaccess, int x, int y, int z) {
        PCde_TileEntityWalkable ted = this.getTE(iblockaccess, x, y, z);
        if (ted.type == 0) {
            return 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    @Override
    public int getRenderColor(int i) {
        if (i == 0) {
            return 0xCCCCCC;
        }
        return 0xFFFFFF;
    }

    public static boolean[] getFencesShownLedge(World world, PC_CoordI pos) {
        boolean[] sides = new boolean[]{false, false, false, false, true};
        sides[0] = PCde_BlockWalkable.isFallBlock(world, pos.offset(1, 0, 0)) && PCde_BlockWalkable.isFallBlock(world, pos.offset(1, -1, 0));
        sides[1] = PCde_BlockWalkable.isFallBlock(world, pos.offset(-1, 0, 0)) && PCde_BlockWalkable.isFallBlock(world, pos.offset(-1, -1, 0));
        sides[2] = PCde_BlockWalkable.isFallBlock(world, pos.offset(0, 0, 1)) && PCde_BlockWalkable.isFallBlock(world, pos.offset(0, -1, 1));
        sides[3] = PCde_BlockWalkable.isFallBlock(world, pos.offset(0, 0, -1)) && PCde_BlockWalkable.isFallBlock(world, pos.offset(0, -1, -1));
        sides[4] = !PCde_BlockWalkable.isClimbBlock(world, pos.offset(0, -1, 0));
        return sides;
    }

    public static boolean[] getFencesShownStairsAbsolute(World world, PC_CoordI pos) {
        boolean[] fences = new boolean[]{false, false, false, false};
        int j = pos.getMeta(world);
        if (j == 0) {
            fences[1] = true;
            fences[0] = true;
        } else if (j == 1) {
            fences[3] = true;
            fences[2] = true;
        } else if (j == 2) {
            fences[1] = true;
            fences[0] = true;
        } else if (j == 3) {
            fences[3] = true;
            fences[2] = true;
        }
        fences[0] = fences[0] & (PCde_BlockWalkable.isFallBlock(world, pos.offset(1, 0, 0)) && PCde_BlockWalkable.isFallBlock(world, pos.offset(1, -1, 0)));
        fences[1] = fences[1] & (PCde_BlockWalkable.isFallBlock(world, pos.offset(-1, 0, 0)) && PCde_BlockWalkable.isFallBlock(world, pos.offset(-1, -1, 0)));
        fences[2] = fences[2] & (PCde_BlockWalkable.isFallBlock(world, pos.offset(0, 0, 1)) && PCde_BlockWalkable.isFallBlock(world, pos.offset(0, -1, 1)));
        fences[3] = fences[3] & (PCde_BlockWalkable.isFallBlock(world, pos.offset(0, 0, -1)) && PCde_BlockWalkable.isFallBlock(world, pos.offset(0, -1, -1)));
        return fences;
    }

    public static boolean[] getFencesShownStairsRelative(World world, PC_CoordI pos) {
        boolean[] fences = PCde_BlockWalkable.getFencesShownStairsAbsolute(world, pos);
        boolean[] rel = new boolean[]{false, false};
        int j = pos.getMeta(world);
        if (j == 0) {
            rel[0] = fences[0];
            rel[1] = fences[1];
        } else if (j == 1) {
            rel[0] = fences[2];
            rel[1] = fences[3];
        } else if (j == 2) {
            rel[0] = fences[1];
            rel[1] = fences[0];
        } else if (j == 3) {
            rel[0] = fences[3];
            rel[1] = fences[2];
        }
        return rel;
    }

    private static boolean isFallBlock(World world, PC_CoordI pos) {
        int id = pos.getId(world);
        if (id == 0 || Block.blocksList[id] == null) {
            return true;
        }
        if (id == Block.ladder.blockID || id == Block.vine.blockID) {
            return false;
        }
        if (Block.blocksList[id].getCollisionBoundingBoxFromPool(world, pos.x, pos.y, pos.z) == null) {
            return true;
        }
        if (Block.blocksList[id].blockMaterial.isLiquid() || !Block.blocksList[id].blockMaterial.isSolid()) {
            return true;
        }
        return PC_BlockUtils.getBlockFlags(world, pos).contains("BELT");
    }

    private static boolean isClimbBlock(World world, PC_CoordI pos) {
        int id = pos.getId(world);
        if (id == 0 || Block.blocksList[id] == null) {
            return false;
        }
        return id == Block.ladder.blockID || id == Block.vine.blockID;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        PCde_TileEntityWalkable ted = this.getTE(iblockaccess, i, j, k);
        if (ted.type == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
            return;
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, ArrayList arraylist) {
        PCde_TileEntityWalkable ted = this.getTE(world, x, y, z);
        if (ted.type == 0) {
            boolean[] fences = PCde_BlockWalkable.getFencesShownLedge(world, new PC_CoordI(x, y, z));
            if (fences[0]) {
                this.setBlockBounds(0.9375f, 0.0f, 0.0f, 1.0f, 1.3f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            }
            if (fences[1]) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.0625f, 1.3f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            }
            if (fences[2]) {
                this.setBlockBounds(0.0f, 0.0f, 0.9375f, 1.0f, 1.3f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            }
            if (fences[3]) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.3f, 0.0625f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            }
            if (fences[4]) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            }
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        if (ted.type == 1) {
            int j = world.getBlockMetadata(x, y, z);
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            if (j == 0) {
                this.setBlockBounds(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 0.5f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            } else if (j == 1) {
                this.setBlockBounds(0.5f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            } else if (j == 2) {
                this.setBlockBounds(0.0f, 0.5f, 0.5f, 1.0f, 1.0f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            } else if (j == 3) {
                this.setBlockBounds(0.0f, 0.5f, 0.0f, 0.5f, 1.0f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            }
            boolean[] fences = PCde_BlockWalkable.getFencesShownStairsAbsolute(world, new PC_CoordI(x, y, z));
            if (fences[0]) {
                this.setBlockBounds(0.9375f, 0.0f, 0.0f, 1.0f, 1.8f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            }
            if (fences[1]) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.0625f, 1.8f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            }
            if (fences[2]) {
                this.setBlockBounds(0.0f, 0.0f, 0.9375f, 1.0f, 1.8f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            }
            if (fences[3]) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.8f, 0.0625f);
                super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
            }
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.getCollidingBoundingBoxes(world, x, y, z, axisalignedbb, arraylist);
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLiving entityliving) {
        PCde_TileEntityWalkable tew = this.getTE(world, x, y, z);
        if (tew.type == 1) {
            int dir = ((MathHelper.floor_double((double)(entityliving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3) + 2) % 4;
            if (PC_Utils.isPlacingReversed()) {
                dir = PC_Utils.reverseSide(dir);
            }
            world.setBlockMetadataWithNotify(x, y, z, dir);
        }
    }

    public PCde_TileEntityWalkable getTE(IBlockAccess iblockaccess, int x, int y, int z) {
        TileEntity te = iblockaccess.getBlockTileEntity(x, y, z);
        if (te == null) {
            return null;
        }
        return (PCde_TileEntityWalkable)te;
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        PCde_TileEntityWalkable ted = this.getTE(iblockaccess, x, y, z);
        if (ted.type == 0) {
            return 22;
        }
        return 0;
    }

    @Override
    protected int damageDropped(int i) {
        return 0;
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return -1;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (iblockaccess.getBlockMetadata(i, j, k) == 0) {
            return true;
        }
        return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        PCde_TileEntityWalkable teg = this.getTE(world, x, y, z);
        if (teg != null && !PC_Utils.isCreative()) {
            this.dropBlockAsItem_do(world, x, y, z, new ItemStack(mod_PCdeco.walkable, 1, teg.type));
        }
        super.onBlockRemoval(world, x, y, z);
    }

    @Override
    public int getRenderBlockPass() {
        return 0;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return PCde_Renderer.walkableBlockRenderer;
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        PCde_TileEntityWalkable tew = this.getTE(world, pos.x, pos.y, pos.z);
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("IRON_LEDGE");
        set.add("DECORATIVE");
        set.add("PASSIVE");
        if (tew != null && tew.type != 1) {
            set.add("TRANSLUCENT");
        }
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

