/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.Direction;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCde_TileEntityWalkable;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.mod_PCdeco;

public class PCde_ItemBlockWalkable
extends ItemBlock {
    public PCde_ItemBlockWalkable(int i) {
        super(i);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @Override
    public int getBlockID() {
        return mod_PCdeco.walkable.blockID;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l) {
        PCde_TileEntityWalkable tew;
        TileEntity te;
        int id = world.getBlockId(i, j, k);
        if (id == Block.snow.blockID) {
            l = 1;
        } else if (id != Block.vine.blockID && id != Block.tallGrass.blockID && id != Block.deadBush.blockID) {
            if (l == 0) {
                --j;
            }
            if (l == 1) {
                ++j;
            }
            if (l == 2) {
                --k;
            }
            if (l == 3) {
                ++k;
            }
            if (l == 4) {
                --i;
            }
            if (l == 5) {
                ++i;
            }
        }
        if (itemstack.stackSize == 0) {
            return false;
        }
        if (!entityplayer.canPlayerEdit(i, j, k)) {
            return false;
        }
        if (world.getBlockId(i, j - 1, k) == mod_PCdeco.walkable.blockID && (te = world.getBlockTileEntity(i, j - 1, k)) != null && te instanceof PCde_TileEntityWalkable && (tew = (PCde_TileEntityWalkable)te) != null) {
            int dir = ((MathHelper.floor_double((double)(entityplayer.rotationYaw * 4.0f / 360.0f) + 0.5) & 3) + 2) % 4;
            if (itemstack.getItemDamage() == 0 && PC_Utils.isPlacingReversed()) {
                dir = PC_Utils.reverseSide(dir);
            }
            int meta = world.getBlockMetadata(i, j - 1, k);
            i -= Direction.offsetX[dir];
            k -= Direction.offsetZ[dir];
            if (tew.type == 1) {
                if (meta == dir) {
                    if (!PC_Utils.isPlacingReversed()) {
                        ++j;
                    } else if (!PC_Utils.isPlacingReversed()) {
                        ++j;
                    }
                } else if (PC_Utils.isPlacingReversed() && itemstack.getItemDamage() == 1) {
                    --j;
                }
            } else if (tew.type == 0 && itemstack.getItemDamage() == 1 && PC_Utils.isPlacingReversed()) {
                --j;
            }
            --j;
        }
        if (j == 255 && Block.blocksList[this.getBlockID()].blockMaterial.isSolid()) {
            return false;
        }
        if (world.canBlockBePlacedAt(mod_PCdeco.walkable.blockID, i, j, k, false, l)) {
            Block block = mod_PCdeco.walkable;
            if (world.setBlock(i, j, k, block.blockID)) {
                PCde_TileEntityWalkable ted = (PCde_TileEntityWalkable)world.getBlockTileEntity(i, j, k);
                if (ted == null) {
                    ted = (PCde_TileEntityWalkable)((BlockContainer)block).getBlockEntity();
                }
                ted.type = itemstack.getItemDamage();
                world.setBlockTileEntity(i, j, k, ted);
                block.onBlockPlaced(world, i, j, k, l);
                block.onBlockPlacedBy(world, i, j, k, entityplayer);
                world.markBlocksDirty(i, j, k, i, j, k);
                world.markBlockNeedsUpdate(i, j, k);
                world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, block.stepSound.getStepSound(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                --itemstack.stackSize;
            }
        }
        return true;
    }

    @Override
    public String getItemNameIS(ItemStack itemstack) {
        return super.getItemName() + "." + itemstack.getItemDamage();
    }
}

