/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.PC_Color;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PClo_TileEntityLight;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PClogic;

public class PClo_BlockLight
extends BlockContainer
implements PC_ISwapTerrain,
PC_IBlockType,
ITextureProvider {
    private static boolean changingState = false;
    private boolean on;
    private int[] meta2side = new int[]{1, 2, 3, 4, 5, 0};

    protected PClo_BlockLight(int id, boolean lit) {
        super(id, 66, Material.circuits);
        this.on = lit;
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PClo_TileEntityLight();
    }

    @Override
    public String getTerrainFile() {
        return mod_PClogic.getTerrainFile();
    }

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public int getRenderType() {
        return PC_Renderer.swapTerrainRenderer;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int i, int j, int k, int l) {
        if (l == 0 && world.isBlockNormalCube(i, j + 1, k)) {
            return true;
        }
        if (l == 1 && world.isBlockNormalCube(i, j - 1, k)) {
            return true;
        }
        if (l == 2 && world.isBlockNormalCube(i, j, k + 1)) {
            return true;
        }
        if (l == 3 && world.isBlockNormalCube(i, j, k - 1)) {
            return true;
        }
        if (l == 4 && world.isBlockNormalCube(i + 1, j, k)) {
            return true;
        }
        return l == 5 && world.isBlockNormalCube(i - 1, j, k);
    }

    @Override
    public void onBlockPlaced(World world, int i, int j, int k, int l) {
        int i1 = 0;
        if (l == 1 && world.isBlockNormalCube(i, j - 1, k)) {
            i1 = 0;
        }
        if (l == 2 && world.isBlockNormalCube(i, j, k + 1)) {
            i1 = 1;
        } else if (l == 3 && world.isBlockNormalCube(i, j, k - 1)) {
            i1 = 2;
        } else if (l == 4 && world.isBlockNormalCube(i + 1, j, k)) {
            i1 = 3;
        } else if (l == 5 && world.isBlockNormalCube(i - 1, j, k)) {
            i1 = 4;
        }
        if (l == 0 && world.isBlockNormalCube(i, j + 1, k)) {
            i1 = 5;
        }
        world.setBlockMetadataWithNotify(i, j, k, i1);
        PClo_BlockLight.onPoweredBlockChange(world, i, j, k, world.isBlockIndirectlyGettingPowered(i, j, k) || this.isAttachmentBlockPowered(world, i, j, k, i1) || this.isBlockUnderAttachmentPowered(world, i, j, k, i1));
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        if (world.isBlockNormalCube(i, j - 1, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i - 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            return true;
        }
        if (world.isBlockNormalCube(i, j + 1, k)) {
            return true;
        }
        return world.isBlockNormalCube(i, j, k + 1);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return false;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        boolean powered;
        if (changingState) {
            return;
        }
        int sidemeta = world.getBlockMetadata(i, j, k);
        if (!this.canPlaceBlockOnSide(world, i, j, k, this.meta2side[sidemeta])) {
            world.setBlockWithNotify(i, j, k, 0);
            return;
        }
        boolean bl = powered = world.isBlockIndirectlyGettingPowered(i, j, k) || this.isAttachmentBlockPowered(world, i, j, k, sidemeta) || this.isBlockUnderAttachmentPowered(world, i, j, k, sidemeta);
        if (this.on && !powered) {
            world.scheduleBlockUpdate(i, j, k, this.blockID, 1);
        } else if (!this.on && powered) {
            world.scheduleBlockUpdate(i, j, k, this.blockID, 1);
        }
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        boolean powered;
        int sidemeta = world.getBlockMetadata(i, j, k);
        boolean bl = powered = world.isBlockIndirectlyGettingPowered(i, j, k) || this.isAttachmentBlockPowered(world, i, j, k, sidemeta) || this.isBlockUnderAttachmentPowered(world, i, j, k, sidemeta);
        if (this.on && !powered) {
            PClo_BlockLight.onPoweredBlockChange(world, i, j, k, false);
        } else if (!this.on && powered) {
            PClo_BlockLight.onPoweredBlockChange(world, i, j, k, true);
        }
    }

    private boolean isAttachmentBlockPowered(World world, int x, int y, int z, int side) {
        if (side == 0) {
            return world.isBlockGettingPowered(x, y - 1, z);
        }
        if (side == 1) {
            return world.isBlockGettingPowered(x, y, z + 1);
        }
        if (side == 2) {
            return world.isBlockGettingPowered(x, y, z - 1);
        }
        if (side == 3) {
            return world.isBlockGettingPowered(x + 1, y, z);
        }
        if (side == 4) {
            return world.isBlockGettingPowered(x - 1, y, z);
        }
        if (side == 5) {
            return world.isBlockGettingPowered(x, y + 1, z);
        }
        return false;
    }

    private boolean isBlockUnderAttachmentPowered(World world, int x, int y, int z, int side) {
        if (side == 0) {
            return world.isBlockGettingPowered(x, y - 2, z) && world.getBlockId(x, y - 2, z) != 0;
        }
        if (side == 1) {
            return world.isBlockGettingPowered(x, y - 1, z + 1) && world.getBlockId(x, y - 1, z + 1) != 0;
        }
        if (side == 2) {
            return world.isBlockGettingPowered(x, y - 1, z - 1) && world.getBlockId(x, y - 1, z - 1) != 0;
        }
        if (side == 3) {
            return world.isBlockGettingPowered(x + 1, y - 1, z) && world.getBlockId(x + 1, y - 1, z) != 0;
        }
        if (side == 4) {
            return world.isBlockGettingPowered(x - 1, y - 1, z) && world.getBlockId(x - 1, y - 1, z) != 0;
        }
        if (side == 5) {
            return world.isBlockGettingPowered(x, y + 2, z) && world.getBlockId(x - 1, y + 2, z) != 0;
        }
        return false;
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        TileEntity te;
        if (!changingState && (te = world.getBlockTileEntity(i, j, k)) != null && !PC_Utils.isCreative()) {
            PClo_TileEntityLight teg = (PClo_TileEntityLight)te;
            this.dropBlockAsItem_do(world, i, j, k, new ItemStack(mod_PClogic.lightOn, 1, teg.getColor()));
        }
        super.onBlockRemoval(world, i, j, k);
    }

    public static void onPoweredBlockChange(World world, int x, int y, int z, boolean rs_state) {
        int l = world.getBlockMetadata(x, y, z);
        TileEntity tileentity = world.getBlockTileEntity(x, y, z);
        changingState = true;
        if (rs_state) {
            world.setBlockWithNotify(x, y, z, mod_PClogic.lightOn.blockID);
        } else {
            world.setBlockWithNotify(x, y, z, mod_PClogic.lightOff.blockID);
        }
        world.setBlockMetadataWithNotify(x, y, z, l);
        changingState = false;
        if (tileentity != null) {
            tileentity.validate();
            world.setBlockTileEntity(x, y, z, tileentity);
        }
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        int i1 = iblockaccess.getBlockMetadata(i, j, k);
        float sidehalf = 0.1875f;
        float height = 0.125f;
        if (i1 == 0) {
            this.setBlockBounds(0.5f - sidehalf, 0.0f, 0.5f - sidehalf, 0.5f + sidehalf, height, 0.5f + sidehalf);
        } else if (i1 == 1) {
            this.setBlockBounds(0.5f - sidehalf, 0.5f - sidehalf, 1.0f - height, 0.5f + sidehalf, 0.5f + sidehalf, 1.0f);
        } else if (i1 == 2) {
            this.setBlockBounds(0.5f - sidehalf, 0.5f - sidehalf, 0.0f, 0.5f + sidehalf, 0.5f + sidehalf, height);
        } else if (i1 == 3) {
            this.setBlockBounds(1.0f - height, 0.5f - sidehalf, 0.5f - sidehalf, 1.0f, 0.5f + sidehalf, 0.5f + sidehalf);
        } else if (i1 == 4) {
            this.setBlockBounds(0.0f, 0.5f - sidehalf, 0.5f - sidehalf, height, 0.5f + sidehalf, 0.5f + sidehalf);
        }
        if (i1 == 5) {
            this.setBlockBounds(0.5f - sidehalf, 1.0f - height, 0.5f - sidehalf, 0.5f + sidehalf, 1.0f, 0.5f + sidehalf);
        }
    }

    @Override
    public void setBlockBoundsForItemRender() {
        float sidehalf = 0.1875f;
        float height = 0.15f;
        this.setBlockBounds(0.5f - sidehalf, 0.5f - sidehalf, 0.5f - height / 2.0f, 0.5f + sidehalf, 0.5f + sidehalf, 0.5f + height / 2.0f);
    }

    @Override
    public int getBlockColor() {
        return 0xF0F0F0;
    }

    @Override
    public int getRenderColor(int i) {
        return PClo_TileEntityLight.getHexColor(i, true);
    }

    @Override
    public int colorMultiplier(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.getColorHex(iblockaccess, i, j, k);
    }

    private int getColorHex(IBlockAccess w, int i, int j, int k) {
        TileEntity te = w.getBlockTileEntity(i, j, k);
        if (te == null) {
            return 0xFF0000;
        }
        PClo_TileEntityLight tei = (PClo_TileEntityLight)te;
        return tei.getHexColor(this.on);
    }

    @Override
    public int quantityDropped(Random random) {
        return 0;
    }

    @Override
    public int idDropped(int i, Random random, int j) {
        return -1;
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (!this.on) {
            return;
        }
        int l = world.getBlockMetadata(i, j, k);
        int color_hex = this.getColorHex(world, i, j, k);
        double ii = (double)i + 0.5;
        double jj = (double)j + 0.5;
        double kk = (double)k + 0.5;
        double h = 0.22;
        double r = PC_Color.red(color_hex);
        double g = PC_Color.green(color_hex);
        double b = PC_Color.blue(color_hex);
        r = r == 0.0 ? 0.001 : r;
        g = g == 0.0 ? 0.001 : g;
        double d = b = b == 0.0 ? 0.001 : b;
        if (l == 0) {
            world.spawnParticle("reddust", ii, (double)j + h, kk, r, g, b);
        } else if (l == 1) {
            world.spawnParticle("reddust", ii, jj, (double)(k + 1) - h, r, g, b);
        } else if (l == 2) {
            world.spawnParticle("reddust", ii, jj, (double)k + h, r, g, b);
        } else if (l == 3) {
            world.spawnParticle("reddust", (double)(i + 1) - h, jj, kk, r, g, b);
        } else if (l == 4) {
            world.spawnParticle("reddust", (double)i + h, jj, kk, r, g, b);
        }
        if (l == 5) {
            world.spawnParticle("reddust", i, jj + 1.0 - h, kk, r, g, b);
        }
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("TRANSLUCENT");
        set.add("REDSTONE");
        set.add("LOGIC");
        set.add("LIGHT");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

