/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PClo_Renderer;
import net.minecraft.src.PClo_TileEntitySensor;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.mod_PClogic;

public class PClo_BlockSensor
extends BlockContainer
implements PC_IBlockType,
PC_ISwapTerrain {
    protected PClo_BlockSensor(int id) {
        super(id, 6, Material.circuits);
        this.setLightOpacity(0);
        PClo_BlockSensor.opaqueCubeLookup[id] = false;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PClo_TileEntitySensor();
    }

    @Override
    protected int damageDropped(int i) {
        return i;
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, ArrayList arraylist) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.255f, 1.0f);
        super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
        this.setBlockBounds(0.375f, 0.2f, 0.375f, 0.625f, 0.7f, 0.625f);
        super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
        this.setBlockBounds(0.3125f, 0.5f, 0.3125f, 0.6875f, 0.875f, 0.6875f);
        super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool(i, j, k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer player) {
        Block bhold;
        ItemStack ihold = player.getCurrentEquippedItem();
        if (ihold != null && ihold.getItem() instanceof ItemBlock && ihold.getItem().shiftedIndex != this.blockID && (bhold = Block.blocksList[ihold.getItem().shiftedIndex]) instanceof PC_IBlockType) {
            return false;
        }
        PClo_BlockSensor.changeDelay(world, new PC_CoordI(i, j, k), player.isSneaking() ? -1 : 1);
        return true;
    }

    @Override
    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        PClo_BlockSensor.printRange(world, new PC_CoordI(i, j, k));
    }

    public static void changeDelay(World world, PC_CoordI pos, int increment) {
        PClo_TileEntitySensor ent = (PClo_TileEntitySensor)pos.getTileEntity(world);
        ent.changeRange(increment);
    }

    public static void printRange(World world, PC_CoordI pos) {
        PClo_TileEntitySensor ent = (PClo_TileEntitySensor)pos.getTileEntity(world);
        ent.printRange();
    }

    @Override
    public String getTerrainFile() {
        return mod_PClogic.getTerrainFile();
    }

    @Override
    public int getRenderType() {
        return PClo_Renderer.sensorRenderer;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        if (!world.getBlockMaterial(i, j - 1, k).isSolid()) {
            return false;
        }
        return super.canPlaceBlockAt(world, i, j, k);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return ((PClo_TileEntitySensor)iblockaccess.getBlockTileEntity((int)i, (int)j, (int)k)).active;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return this.isPoweringTo(world, i, j, k, l);
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (!((PClo_TileEntitySensor)world.getBlockTileEntity((int)i, (int)j, (int)k)).active) {
            return;
        }
        double ii = (double)i + 0.2 + random.nextDouble() * 0.6;
        double jj = (double)j + 0.5 + random.nextDouble() * 0.4;
        double kk = (double)k + 0.2 + random.nextDouble() * 0.6;
        world.spawnParticle("reddust", ii, jj, kk, 0.0, 0.0, 0.0);
    }

    @Override
    public int getBlockTexture(IBlockAccess world, int i, int j, int k, int l) {
        int meta = world.getBlockMetadata(i, j, k);
        switch (meta) {
            case 0: {
                return 4;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 37;
            }
        }
        return 48;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int s, int m) {
        switch (m) {
            case 0: {
                return 4;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 37;
            }
        }
        return 48;
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("TRANSLUCENT");
        set.add("REDSTONE");
        set.add("LOGIC");
        set.add("SENSOR");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

