/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_GresButton;
import net.minecraft.src.PC_GresLabel;
import net.minecraft.src.PC_GresLayoutH;
import net.minecraft.src.PC_GresLayoutV;
import net.minecraft.src.PC_GresTextEdit;
import net.minecraft.src.PC_GresWidget;
import net.minecraft.src.PC_GresWindow;
import net.minecraft.src.PC_IGresBase;
import net.minecraft.src.PC_IGresGui;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PClo_BlockRadio;
import net.minecraft.src.PClo_RadioManager;
import net.minecraft.src.PClo_TileEntityRadio;
import net.minecraft.src.mod_PClogic;

public class PClo_GuiRadioChannel
implements PC_IGresBase {
    private String errMsg = "";
    public static final int RECEIVER = 1;
    public static final int TRANSMITTER = 0;
    private int type;
    private PC_CoordI pos;
    private String oldChannel;
    private String editedString;
    private int dim = 0;
    private PC_GresWidget buttonOK;
    private PC_GresWidget buttonCancel;
    private PC_GresWidget edit;
    private PC_GresWidget txError;

    public PClo_GuiRadioChannel(int dimen, PC_CoordI blockPos, String s, int radiotype) {
        this.editedString = s;
        this.oldChannel = new String(s);
        this.type = radiotype;
        this.pos = blockPos;
        this.dim = dimen;
    }

    @Override
    public EntityPlayer getPlayer() {
        return PC_Utils.mc().thePlayer;
    }

    @Override
    public void initGui(PC_IGresGui gui) {
        String title = "";
        title = this.type == 0 ? PC_Lang.tr("tile.PCloRadio.tx.name") : PC_Lang.tr("tile.PCloRadio.rx.name");
        PC_GresWindow w = new PC_GresWindow(title);
        w.setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        PC_GresWidget vg = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
        vg.add(new PC_GresLabel(PC_Lang.tr("pc.gui.radio.channel")));
        this.edit = new PC_GresTextEdit(this.editedString, 8, PC_GresTextEdit.PC_GresInputType.TEXT).setMinWidth(130);
        vg.add(this.edit);
        w.add(vg);
        PC_GresWidget hg = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.txError = new PC_GresLabel("").setColor(0, 0x990000);
        hg.add(this.txError);
        w.add(hg);
        hg = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.buttonCancel = new PC_GresButton(PC_Lang.tr("pc.gui.cancel")).setId(1);
        hg.add(this.buttonCancel);
        this.buttonOK = new PC_GresButton(PC_Lang.tr("pc.gui.ok")).setId(0);
        hg.add(this.buttonOK);
        w.add(hg);
        gui.add(w);
        gui.setPausesGame(true);
        this.actionPerformed(this.edit, gui);
    }

    @Override
    public void onGuiClosed(PC_IGresGui gui) {
    }

    @Override
    public void actionPerformed(PC_GresWidget widget, PC_IGresGui gui) {
        if (widget.getId() == 0) {
            String newChannel = this.edit.getText().trim();
            PClo_TileEntityRadio ter = PClo_BlockRadio.getTE(PC_Utils.mc().theWorld, this.pos.x, this.pos.y, this.pos.z);
            if (this.type == 0) {
                PClo_RadioManager.setTransmitterChannel(this.dim, this.pos, this.oldChannel, newChannel, ter.isActive());
            } else {
                PClo_RadioManager.setReceiverChannel(this.dim, this.pos, newChannel);
            }
            ter.channel = newChannel;
            ter.dim = this.dim;
            if (this.type == 1) {
                boolean bl = ter.active = PClo_RadioManager.getSignalStrength(newChannel) > 0;
                if (ter.active) {
                    PC_Utils.mc().theWorld.setBlockMetadataWithNotify(this.pos.x, this.pos.y, this.pos.z, 1);
                }
            }
            PC_Utils.mc().theWorld.scheduleBlockUpdate(this.pos.x, this.pos.y, this.pos.z, mod_PClogic.radio.blockID, 1);
            gui.close();
        } else if (widget.getId() == 1) {
            gui.close();
        }
        if (widget == this.edit) {
            if (this.edit.getText().trim().length() == 0) {
                this.errMsg = "pc.gui.radio.errChannel";
                this.txError.setText(PC_Lang.tr(this.errMsg));
            } else {
                this.txError.setText("");
            }
        }
    }

    @Override
    public void onEscapePressed(PC_IGresGui gui) {
        gui.close();
    }

    @Override
    public void onReturnPressed(PC_IGresGui gui) {
        this.actionPerformed(this.buttonOK, gui);
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory) {
    }
}

