/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Hashtable;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_Struct2;
import net.minecraft.src.PClo_TileEntityRadio;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.mod_PClogic;

public class PClo_RadioManager {
    private static Minecraft mc = ModLoader.getMinecraftInstance();
    public static Hashtable<PC_CoordI, PC_Struct2<String, Integer>> receivers = new Hashtable();
    public static Hashtable<String, Hashtable<PC_Struct2<PC_CoordI, Integer>, Boolean>> signals = new Hashtable();
    private static String worldName = null;

    private static void checkWorldChange() {
        if (PClo_RadioManager.mc.theWorld.worldInfo.getWorldName() != worldName) {
            receivers.clear();
            signals.clear();
            worldName = PClo_RadioManager.mc.theWorld.worldInfo.getWorldName();
        }
    }

    public static void registerReceiver(int dimension, PC_CoordI pos, String channel) {
        PClo_RadioManager.checkWorldChange();
        receivers.put(pos, new PC_Struct2<String, Integer>(channel, dimension));
    }

    public static void unregisterReceiver(PC_CoordI pos) {
        PClo_RadioManager.checkWorldChange();
        receivers.remove(pos);
    }

    public static void setTransmitterState(int dimension, PC_CoordI pos, String channel, boolean state) {
        boolean newState;
        PClo_RadioManager.checkWorldChange();
        if (!signals.containsKey(channel)) {
            signals.put(channel, new Hashtable());
        }
        boolean oldState = PClo_RadioManager.getSignalStrength(channel) > 0;
        signals.get(channel).put(new PC_Struct2<PC_CoordI, Integer>(pos, dimension), state);
        boolean bl = newState = PClo_RadioManager.getSignalStrength(channel) > 0;
        if (oldState != newState) {
            for (PC_CoordI recpos : receivers.keySet()) {
                PClo_TileEntityRadio ter;
                TileEntity te;
                if (!receivers.get(recpos).get1().equals(channel) || receivers.get(recpos).get2().intValue() != PClo_RadioManager.mc.theWorld.worldInfo.getDimension() || (te = PClo_RadioManager.mc.theWorld.getBlockTileEntity(recpos.x, recpos.y, recpos.z)) == null || !(ter = (PClo_TileEntityRadio)te).isReceiver() || recpos.getId(PClo_RadioManager.mc.theWorld) != mod_PClogic.radio.blockID) continue;
                PClo_RadioManager.mc.theWorld.setBlockMetadata(recpos.x, recpos.y, recpos.z, newState ? 1 : 0);
                ter.setStateWithNotify(newState);
                ter.updateBlock();
            }
        }
    }

    public static void setTransmitterChannel(int dimension, PC_CoordI pos, String oldChannel, String newChannel, boolean state) {
        PClo_RadioManager.checkWorldChange();
        PClo_RadioManager.setTransmitterState(dimension, pos, oldChannel, false);
        signals.get(oldChannel).remove(new PC_Struct2<PC_CoordI, Integer>(pos, dimension));
        PClo_RadioManager.setTransmitterState(dimension, pos, newChannel, state);
    }

    public static void setReceiverChannel(int dimension, PC_CoordI pos, String newChannel) {
        PClo_RadioManager.checkWorldChange();
        PClo_RadioManager.unregisterReceiver(pos);
        PClo_RadioManager.registerReceiver(dimension, pos, newChannel);
    }

    public static int getSignalStrength(String channel) {
        PClo_RadioManager.checkWorldChange();
        if (!signals.containsKey(channel)) {
            return 0;
        }
        int cnt = 0;
        for (Map.Entry<PC_Struct2<PC_CoordI, Integer>, Boolean> a : signals.get(channel).entrySet()) {
            if (!a.getValue().booleanValue() || a.getKey().get2().intValue() != PClo_RadioManager.mc.theWorld.worldInfo.getDimension()) continue;
            ++cnt;
        }
        return cnt;
    }

    public static void sendRemotePulse(String channel) {
        PClo_RadioManager.checkWorldChange();
        for (PC_CoordI recpos : receivers.keySet()) {
            PC_Struct2<String, Integer> receiver = receivers.get(recpos);
            if (!receiver.get1().equals(channel)) continue;
            World world = PClo_RadioManager.mc.theWorld;
            recpos.setMeta(world, 1);
            world.notifyBlocksOfNeighborChange(recpos.x, recpos.y, recpos.z, mod_PClogic.radio.blockID);
            world.notifyBlocksOfNeighborChange(recpos.x, recpos.y - 1, recpos.z, mod_PClogic.radio.blockID);
            world.markBlocksDirty(recpos.x, recpos.y, recpos.z, recpos.x, recpos.y, recpos.z);
            world.scheduleBlockUpdate(recpos.x, recpos.y, recpos.z, mod_PClogic.radio.blockID, 10);
        }
    }

    public static void unregisterTx(int dimension, PC_CoordI pos, String channel) {
        PClo_RadioManager.checkWorldChange();
        PClo_RadioManager.setTransmitterState(dimension, pos, channel, false);
        signals.get(channel).remove(new PC_Struct2<PC_CoordI, Integer>(pos, dimension));
    }
}

