/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.PC_InvUtils;
import net.minecraft.src.PClo_BlockGate;
import net.minecraft.src.PClo_TileEntityPulsar;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.mod_PClogic;

public class PClo_TileEntityGate
extends TileEntity {
    public int gateType = -1;
    public boolean prevClockState = false;
    private int updateIgnoreCounter = 10;
    private long lastUpdateTime = 0L;
    public boolean zombie = false;
    public String programm = "";
    private boolean dOutputState = false;
    private boolean[] dBuffer = new boolean[20];
    private int dPointer = 0;
    private boolean dResetDone = false;
    private int rRemainingTicks;
    private int rHoldTime = 20;
    private static final int PLUS = 1;
    private static final int MINUS = -1;
    private int crossing_X = 1;
    private int crossing_Z = 1;
    public boolean[] powered = new boolean[]{false, false, false, false};

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        if (this.zombie) {
            return;
        }
        long t = System.currentTimeMillis();
        if (t - this.lastUpdateTime < 5L) {
            return;
        }
        this.lastUpdateTime = t;
        if (this.gateType != 21 && this.gateType != 22) {
            if (this.updateIgnoreCounter-- <= 0) {
                this.updateIgnoreCounter = 6;
            } else {
                return;
            }
        }
        this.updateContainingBlockInfo();
        Block block = this.getBlockType();
        if (block == null || block.blockID != mod_PClogic.gateOn.blockID && block.blockID != mod_PClogic.gateOff.blockID) {
            return;
        }
        int blockID = block.blockID;
        boolean active = ((PClo_BlockGate)Block.blocksList[blockID]).active;
        switch (this.gateType) {
            case 21: {
                if (PClo_BlockGate.powered_from_input(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 1)) {
                    if (this.dResetDone) break;
                    for (int i = 0; i < this.dBuffer.length; ++i) {
                        this.dBuffer[i] = false;
                    }
                    this.dPointer = 0;
                    if (this.dOutputState) {
                        this.dOutputState = false;
                        this.updateBlock();
                    }
                    this.dResetDone = true;
                    break;
                }
                this.dResetDone = false;
                if (PClo_BlockGate.powered_from_input(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 2)) break;
                this.bufferPush(PClo_BlockGate.powered_from_input(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 0));
                if (this.dOutputState == active) break;
                this.updateBlock();
                break;
            }
            case 22: {
                if (PClo_BlockGate.powered_from_input(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 0)) {
                    this.repeaterStartHolding();
                }
                if (this.rRemainingTicks > 0) {
                    --this.rRemainingTicks;
                }
                if (this.rRemainingTicks == 0 && active) {
                    this.updateBlock();
                    break;
                }
                if (this.rRemainingTicks <= 0 || active) break;
                this.updateBlock();
                break;
            }
            case 16: {
                if (this.worldObj.isDaytime() == active) break;
                this.updateBlock();
                break;
            }
            case 17: {
                if (this.worldObj.isRaining() == active) break;
                this.updateBlock();
                break;
            }
            case 18: {
                if (this.isChestEmpty() == active) break;
                this.updateBlock();
                break;
            }
            case 19: {
                if (this.isChestFull() != active) {
                    this.updateBlock();
                }
            }
            case 20: {
                this.stopSpawning_stopPulsar(this.worldObj.getBlockTileEntity(this.xCoord + 1, this.yCoord, this.zCoord), active);
                this.stopSpawning_stopPulsar(this.worldObj.getBlockTileEntity(this.xCoord - 1, this.yCoord, this.zCoord), active);
                this.stopSpawning_stopPulsar(this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord + 1), active);
                this.stopSpawning_stopPulsar(this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord - 1), active);
                this.stopSpawning_stopPulsar(this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord + 1, this.zCoord), active);
                this.stopSpawning_stopPulsar(this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord - 1, this.zCoord), active);
            }
        }
    }

    private void updateBlock() {
        this.worldObj.scheduleBlockUpdate(this.xCoord, this.yCoord, this.zCoord, this.getBlockType().blockID, 1);
    }

    private void stopSpawning_stopPulsar(TileEntity te, boolean active) {
        if (te != null) {
            if (te instanceof TileEntityMobSpawner) {
                ((TileEntityMobSpawner)te).delay = 500;
            } else if (te != null && te instanceof PClo_TileEntityPulsar && active) {
                ((PClo_TileEntityPulsar)te).paused = true;
                ((PClo_TileEntityPulsar)te).active = false;
                ((PClo_TileEntityPulsar)te).delayTimer = 0;
                ((PClo_TileEntityPulsar)te).updateBlock();
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound maintag) {
        super.readFromNBT(maintag);
        this.gateType = maintag.getInteger("type");
        this.prevClockState = maintag.getBoolean("clock");
        if (this.gateType == 21) {
            NBTTagList taglist = maintag.getTagList("DelayBuffer");
            int length = maintag.getInteger("DelayLength");
            this.dBuffer = new boolean[length];
            this.dOutputState = maintag.getBoolean("DelayState");
            for (int i = 0; i < length; ++i) {
                NBTTagCompound booltag = (NBTTagCompound)taglist.tagAt(i);
                this.dBuffer[booltag.getInteger((String)"Index")] = booltag.getBoolean("state");
            }
        }
        if (this.gateType == 25) {
            this.programm = maintag.getString("programm");
        }
        if (this.gateType == 22) {
            this.rHoldTime = maintag.getInteger("RepeaterHoldTime");
            this.rRemainingTicks = maintag.getInteger("RepeaterTicksRem");
        }
        if (this.gateType == 23) {
            this.crossing_X = maintag.getInteger("CrossingX");
            this.crossing_Z = maintag.getInteger("CrossingZ");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound maintag) {
        super.writeToNBT(maintag);
        maintag.setInteger("type", this.gateType);
        maintag.setBoolean("clock", this.prevClockState);
        if (this.gateType == 21) {
            NBTTagList listtag = new NBTTagList();
            for (int i = 0; i < this.dBuffer.length; ++i) {
                NBTTagCompound booltag = new NBTTagCompound();
                booltag.setInteger("Index", i);
                booltag.setBoolean("state", this.dBuffer[i]);
                listtag.appendTag(booltag);
            }
            maintag.setTag("DelayBuffer", listtag);
            maintag.setInteger("DelayLength", this.dBuffer.length);
            maintag.setBoolean("DelayState", this.dOutputState);
        }
        if (this.gateType == 25) {
            maintag.setString("programm", this.programm);
        }
        if (this.gateType == 22) {
            maintag.setInteger("RepeaterHoldTime", this.rHoldTime);
            maintag.setInteger("RepeaterTicksRem", this.rRemainingTicks);
        }
        if (this.gateType == 23) {
            maintag.setInteger("CrossingX", this.crossing_X);
            maintag.setInteger("CrossingZ", this.crossing_Z);
        }
    }

    public boolean isChestFull() {
        int i1 = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord) & 3;
        int N0 = 0;
        int N1 = 1;
        int N2 = 2;
        int N3 = 3;
        if (i1 == N0) {
            return PClo_TileEntityGate.isFullChestAt(this.worldObj, this.xCoord, this.yCoord, this.zCoord + 1);
        }
        if (i1 == N1) {
            return PClo_TileEntityGate.isFullChestAt(this.worldObj, this.xCoord - 1, this.yCoord, this.zCoord);
        }
        if (i1 == N2) {
            return PClo_TileEntityGate.isFullChestAt(this.worldObj, this.xCoord, this.yCoord, this.zCoord - 1);
        }
        if (i1 == N3) {
            return PClo_TileEntityGate.isFullChestAt(this.worldObj, this.xCoord + 1, this.yCoord, this.zCoord);
        }
        return false;
    }

    public boolean isChestEmpty() {
        int i1 = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord) & 3;
        int N0 = 0;
        int N1 = 1;
        int N2 = 2;
        int N3 = 3;
        if (i1 == N0) {
            return PClo_TileEntityGate.isEmptyChestAt(this.worldObj, this.xCoord, this.yCoord, this.zCoord + 1);
        }
        if (i1 == N1) {
            return PClo_TileEntityGate.isEmptyChestAt(this.worldObj, this.xCoord - 1, this.yCoord, this.zCoord);
        }
        if (i1 == N2) {
            return PClo_TileEntityGate.isEmptyChestAt(this.worldObj, this.xCoord, this.yCoord, this.zCoord - 1);
        }
        if (i1 == N3) {
            return PClo_TileEntityGate.isEmptyChestAt(this.worldObj, this.xCoord + 1, this.yCoord, this.zCoord);
        }
        return true;
    }

    private static boolean isEmptyChestAt(IBlockAccess blockaccess, int x, int y, int z) {
        return PC_InvUtils.isInventoryEmpty(PC_InvUtils.getCompositeInventoryAt(blockaccess, x, y, z));
    }

    private static boolean isFullChestAt(IBlockAccess blockaccess, int x, int y, int z) {
        return PC_InvUtils.isInventoryFull(PC_InvUtils.getCompositeInventoryAt(blockaccess, x, y, z));
    }

    public void bufferResize(int length) {
        this.dBuffer = new boolean[length];
        System.gc();
        this.dPointer = 0;
        this.dOutputState = false;
    }

    private void bufferPush(boolean state) {
        this.dOutputState = this.dBuffer[this.dPointer];
        this.dBuffer[this.dPointer] = state;
        ++this.dPointer;
        if (this.dPointer >= this.dBuffer.length) {
            this.dPointer = 0;
        }
    }

    public boolean getBufferOutput() {
        return this.dOutputState;
    }

    public int getDelayBufferLength() {
        return this.dBuffer.length;
    }

    public void setRepeaterHoldTime(int ticks) {
        this.rHoldTime = ticks;
        this.rRemainingTicks = Math.min(this.rHoldTime, this.rRemainingTicks);
    }

    public void repeaterStartHolding() {
        this.rRemainingTicks = this.rHoldTime;
    }

    public boolean isRepeaterOutputActive() {
        return this.rRemainingTicks > 0;
    }

    public int repeaterGetHoldTime() {
        return this.rHoldTime;
    }

    public int getCrossingVariant() {
        if (this.crossing_X == 1 && this.crossing_Z == 1) {
            return 0;
        }
        if (this.crossing_X == -1 && this.crossing_Z == 1) {
            return 1;
        }
        if (this.crossing_X == 1 && this.crossing_Z == -1) {
            return 2;
        }
        if (this.crossing_X == -1 && this.crossing_Z == -1) {
            return 3;
        }
        return -1;
    }

    public void toggleCrossingX() {
        this.crossing_X *= -1;
        PClo_BlockGate.hugeUpdate(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord));
        this.worldObj.markBlocksDirty(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
        this.worldObj.markBlockNeedsUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public void toggleCrossingZ() {
        this.crossing_Z *= -1;
        PClo_BlockGate.hugeUpdate(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord));
        this.worldObj.markBlocksDirty(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
        this.worldObj.markBlockNeedsUpdate(this.xCoord, this.yCoord, this.zCoord);
    }
}

