/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.TileEntity;
import net.minecraft.src.mod_PCcore;

public class PClo_TileEntityPulsar
extends TileEntity {
    public boolean paused = false;
    public int delayTimer = 0;
    public int delay = 10;
    public int holdtime = 4;
    public boolean active;
    public boolean silent;

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setShort("timer", (short)this.delayTimer);
        nbttagcompound.setShort("delay", (short)this.delay);
        nbttagcompound.setShort("holdtime", (short)this.holdtime);
        nbttagcompound.setBoolean("on", this.active);
        nbttagcompound.setBoolean("paused", this.paused);
        nbttagcompound.setBoolean("silent", this.silent);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.delayTimer = nbttagcompound.getShort("timer");
        this.delay = nbttagcompound.getShort("delay");
        this.holdtime = nbttagcompound.getShort("holdtime");
        this.active = nbttagcompound.getBoolean("on");
        this.paused = nbttagcompound.getBoolean("paused");
        this.silent = nbttagcompound.getBoolean("silent");
        if (this.delay < 2) {
            this.delay = 2;
        }
        if (this.holdtime < 1 || this.holdtime >= this.delay - 1) {
            this.holdtime = this.delay > 6 ? 3 : 1;
        }
    }

    public void setDelay(int i) {
        this.delay = i;
        if (this.delay <= 3) {
            this.delay = 3;
        }
        if (this.holdtime < 1 || this.holdtime >= this.delay - 1) {
            this.holdtime = this.delay > 6 ? 3 : 1;
        }
    }

    public void setHoldTime(int i) {
        this.holdtime = i;
        if (this.holdtime < 1 || this.holdtime >= this.delay - 1) {
            this.holdtime = this.delay > 6 ? 3 : 1;
        }
    }

    public void changeDelay(int i) {
        this.delay += i;
        if (this.delay <= 3) {
            this.delay = 3;
        }
    }

    public void printDelay() {
        PC_Utils.chatMsg(PC_Lang.tr("pc.pulsar.clickMsg", new String[]{this.delay + "", (double)this.delay / 20.0 + ""}), true);
    }

    public void printDelayTime() {
        PC_Utils.chatMsg(PC_Lang.tr("pc.pulsar.clickMsgTime", new String[]{this.delay + "", (double)this.delay / 20.0 + "", this.delay - this.delayTimer + ""}), true);
    }

    @Override
    public void updateEntity() {
        if (this.paused) {
            return;
        }
        if (this.delayTimer < 0) {
            this.active = true;
            this.updateBlock();
        }
        ++this.delayTimer;
        if (this.delayTimer >= this.holdtime) {
            this.active = false;
            this.updateBlock();
        }
        if (this.delayTimer >= this.delay) {
            if (!this.silent && mod_PCcore.soundsEnabled) {
                this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "random.click", 0.15f, 0.6f);
            }
            this.delayTimer = -1;
        }
    }

    public void updateBlock() {
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType().blockID);
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType().blockID);
        this.worldObj.markBlocksDirty(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean canUpdate() {
        return true;
    }

    public void setSilent(boolean flag) {
        this.silent = flag;
    }
}

