/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.PClo_RadioManager;
import net.minecraft.src.TileEntity;
import net.minecraft.src.mod_PClogic;

public class PClo_TileEntityRadio
extends TileEntity {
    public String channel = mod_PClogic.default_radio_channel;
    public int type = 0;
    public boolean active = false;
    public int dim = 0;
    private boolean registered = false;

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setString("channel", this.channel);
        nbttagcompound.setInteger("type", this.type);
        nbttagcompound.setBoolean("active", this.active);
        nbttagcompound.setInteger("dim", this.dim);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.channel = nbttagcompound.getString("channel");
        this.type = nbttagcompound.getInteger("type");
        this.active = nbttagcompound.getBoolean("active");
        this.dim = nbttagcompound.getInteger("dim");
    }

    @Override
    public void updateEntity() {
        if (!this.registered) {
            if (this.type == 1) {
                PC_Logger.finest("Radio receiver at [" + this.xCoord + ";" + this.yCoord + ";" + this.zCoord + "] registers to RadioManager");
                PClo_RadioManager.registerReceiver(this.dim, new PC_CoordI(this.xCoord, this.yCoord, this.zCoord), this.channel);
            } else {
                PC_Logger.finest("Radio transmitter at [" + this.xCoord + ";" + this.yCoord + ";" + this.zCoord + "] registers to RadioManager with signal state = " + this.active);
                PClo_RadioManager.setTransmitterState(this.dim, new PC_CoordI(this.xCoord, this.yCoord, this.zCoord), this.channel, this.active);
            }
            this.registered = true;
        }
    }

    public void updateBlock() {
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType().blockID);
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType().blockID);
        this.worldObj.markBlocksDirty(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean canUpdate() {
        return true;
    }

    public void setType(int typeindex) {
        this.type = typeindex;
    }

    public boolean isTransmitter() {
        return this.type == 0;
    }

    public boolean isReceiver() {
        return this.type == 1;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setStateWithNotify(boolean act) {
        if (this.isTransmitter() && this.active != act) {
            PClo_RadioManager.setTransmitterState(this.dim, new PC_CoordI(this.xCoord, this.yCoord, this.zCoord), this.channel, act);
        }
        this.active = act;
    }

    public String getChannel() {
        return this.channel;
    }
}

