/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityCreature;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySlime;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.TileEntity;
import net.minecraft.src.mod_PClogic;

public class PClo_TileEntitySensor
extends TileEntity {
    public boolean active = false;
    public int range = mod_PClogic.default_sensor_range;

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.active = nbttagcompound.getBoolean("on");
        this.range = nbttagcompound.getInteger("range");
        if (this.range < 1) {
            this.range = mod_PClogic.default_sensor_range;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("on", this.active);
        nbttagcompound.setInteger("range", this.range);
    }

    public void changeRange(int incr) {
        if (incr > 0) {
            ++this.range;
        }
        if (incr < 0) {
            --this.range;
        }
        if (this.range < 1) {
            this.range = 1;
        }
        if (this.range > 512) {
            this.range = 512;
        }
        String msg = "";
        if (this.range == 1) {
            msg = PC_Lang.tr("pc.sensor.rangeChanged.1", new String[]{this.range + ""});
        }
        if (this.range > 1 && this.range < 5) {
            msg = PC_Lang.tr("pc.sensor.rangeChanged.2-4", new String[]{this.range + ""});
        }
        if (this.range >= 5) {
            msg = PC_Lang.tr("pc.sensor.rangeChanged.5+", new String[]{this.range + ""});
        }
        PC_Utils.chatMsg(msg, true);
    }

    public void printRange() {
        String msg = "";
        if (this.range == 1) {
            msg = PC_Lang.tr("pc.sensor.range.1", new String[]{this.range + ""});
        }
        if (this.range > 1 && this.range < 5) {
            msg = PC_Lang.tr("pc.sensor.range.2-4", new String[]{this.range + ""});
        }
        if (this.range >= 5) {
            msg = PC_Lang.tr("pc.sensor.range.5+", new String[]{this.range + ""});
        }
        PC_Utils.chatMsg(msg, true);
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        int size = 0;
        if (this.getGroup() == 0) {
            size += this.worldObj.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBoxFromPool(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 1, this.yCoord + 1, this.zCoord + 1).expand(this.getRange(), this.getRange(), this.getRange())).size();
        } else if (this.getGroup() == 1) {
            size += this.worldObj.getEntitiesWithinAABB(EntityAnimal.class, AxisAlignedBB.getBoundingBoxFromPool(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 1, this.yCoord + 1, this.zCoord + 1).expand(this.getRange(), this.getRange(), this.getRange())).size();
            size += this.worldObj.getEntitiesWithinAABB(EntityCreature.class, AxisAlignedBB.getBoundingBoxFromPool(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 1, this.yCoord + 1, this.zCoord + 1).expand(this.getRange(), this.getRange(), this.getRange())).size();
            size += this.worldObj.getEntitiesWithinAABB(EntitySlime.class, AxisAlignedBB.getBoundingBoxFromPool(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 1, this.yCoord + 1, this.zCoord + 1).expand(this.getRange(), this.getRange(), this.getRange())).size();
        } else if (this.getGroup() == 2) {
            size += this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBoxFromPool(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 1, this.yCoord + 1, this.zCoord + 1).expand(this.getRange(), this.getRange(), this.getRange())).size();
        }
        if (size > 0) {
            if (!this.active) {
                this.active = true;
                this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType().blockID);
                this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType().blockID);
                this.worldObj.markBlocksDirty(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
                this.worldObj.markBlockNeedsUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        } else if (this.active) {
            this.active = false;
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType().blockID);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType().blockID);
            this.worldObj.markBlocksDirty(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.markBlockNeedsUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public int getGroup() {
        return this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
    }

    public int getRange() {
        return this.range;
    }
}

