/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.Block;
import net.minecraft.src.BlockRail;
import net.minecraft.src.BlockRedstoneRepeater;
import net.minecraft.src.BlockTorch;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityCow;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.EntityMooshroom;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.Facing;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_BlockUtils;
import net.minecraft.src.PC_Color;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_CropHarvestingManager;
import net.minecraft.src.PC_IBeamHandler;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_ICropBlock;
import net.minecraft.src.PC_ISpecialInventoryTextures;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_InvUtils;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.PC_TreeHarvestingManager;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCma_BeamTracer;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCcore;
import net.minecraft.src.mod_PCmachines;

public class PCma_BlockHarvester
extends Block
implements PC_ISwapTerrain,
PC_IBlockType,
PC_ISpecialInventoryTextures,
ITextureProvider,
PC_IBeamHandler {
    private static final int TXDOWN = 109;
    private static final int TXTOP = 155;
    private static final int TXSIDE = 139;
    private static final int TXFRONT = 107;
    private static final int TXBACK = 123;
    public static final int ENDBLOCK = 98;
    private ArrayList<ItemStack> drops = new ArrayList();

    @Override
    public String getTerrainFile() {
        return mod_PCmachines.getTerrainFile();
    }

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return PC_Renderer.swapTerrainRenderer;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int s, int m) {
        if (s == 1) {
            return 155;
        }
        if (s == 0) {
            return 109;
        }
        if (m == s) {
            return 107;
        }
        if (m == 2 && s == 3 || m == 3 && s == 2 || m == 4 && s == 5 || m == 5 && s == 4) {
            return 123;
        }
        return 139;
    }

    @Override
    public int getInvTexture(int i, int m) {
        if (i == 1) {
            return 155;
        }
        if (i == 0) {
            return 109;
        }
        if (i == 3) {
            return 107;
        }
        if (i == 4) {
            return 123;
        }
        return 139;
    }

    protected PCma_BlockHarvester(int i) {
        super(i, Material.ground);
        this.setStepSound(Block.soundPowderFootstep);
    }

    @Override
    public boolean isBlockSolid(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return true;
    }

    @Override
    public int tickRate() {
        return 4;
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return false;
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
        int l = MathHelper.floor_double((double)(entityliving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (PC_Utils.isPlacingReversed()) {
            l = PC_Utils.reverseSide(l);
        }
        if (l == 0) {
            l = 2;
        } else if (l == 1) {
            l = 5;
        } else if (l == 2) {
            l = 3;
        } else if (l == 3) {
            l = 4;
        }
        if (this.isIndirectlyPowered(world, i, j, k)) {
            world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
        }
        world.setBlockMetadataWithNotify(i, j, k, l);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        if (this.isIndirectlyPowered(world, i, j, k)) {
            this.harvestBlocks(world, i, j, k, l);
            l |= 8;
        }
        world.setBlockMetadataWithNotify(i, j, k, l);
    }

    private boolean isIndirectlyPowered(World world, int i, int j, int k) {
        if (world.isBlockIndirectlyGettingPowered(i, j, k)) {
            return true;
        }
        return world.isBlockIndirectlyGettingPowered(i, j - 1, k);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        boolean flag;
        if (l > 0 && Block.blocksList[l].canProvidePower() && (flag = this.isIndirectlyPowered(world, i, j, k))) {
            world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
        }
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (this.isIndirectlyPowered(world, i, j, k)) {
            this.harvestBlocks(world, i, j, k, world.getBlockMetadata(i, j, k));
        }
    }

    private void harvestBlocks(World world, int x, int y, int z, int deviceMeta) {
        int incZ = Facing.offsetsZForSide[deviceMeta &= 7];
        int incX = Facing.offsetsXForSide[deviceMeta];
        PC_CoordI move = new PC_CoordI(incX, 0, incZ);
        PC_CoordI cnt = new PC_CoordI(x, y, z);
        PCma_BeamTracer beamTracer = new PCma_BeamTracer(world, this);
        beamTracer.setStartCoord(cnt);
        beamTracer.setStartMove(move);
        beamTracer.setCanChangeColor(false);
        beamTracer.setReflectedByMirror(true);
        beamTracer.setReflectedByPrism(true);
        beamTracer.setDetectEntities(true);
        beamTracer.setParticlesBidirectional(false);
        beamTracer.setTotalLengthLimit(8000);
        beamTracer.setMaxLengthAfterCrystal(2000);
        beamTracer.setStartLength(30);
        beamTracer.setCrystalAddedLength(100);
        PC_Color color = new PC_Color();
        color.setTo(0.001, 1.0, 0.001);
        color.setMeta(2);
        beamTracer.setColor(color);
        if (world.getBlockId(x, y - 1, z) == 98) {
            beamTracer.setStartLength(1);
            beamTracer.setMaxLengthAfterCrystal(1);
        }
        this.drops.clear();
        beamTracer.flash();
        if (this.drops != null) {
            PC_InvUtils.mergeStacks(this.drops);
            for (ItemStack stack : this.drops) {
                this.dispenseItem(world, cnt, stack);
            }
        }
    }

    @Override
    public boolean onBlockHit(World world, PC_CoordI coord, PC_CoordI startCoord) {
        int underId;
        int id = coord.getId(world);
        int meta = coord.getMeta(world);
        if (id == 49 || id == 7 || id == 98) {
            return true;
        }
        if (PC_TreeHarvestingManager.isBlockTreeSapling(id, meta) && ((underId = coord.offset(0, -1, 0).getId(world)) == Block.dirt.blockID || underId == Block.grass.blockID || underId == Block.mycelium.blockID)) {
            return false;
        }
        if (id == 0 || id == Block.glass.blockID || id == Block.thinGlass.blockID || id == Block.redstoneLampActive.blockID || id == Block.redstoneLampIdle.blockID || Block.blocksList[id] == null || id == 8 || id == 9 || id == 10 || id == 11 || id == Block.sapling.blockID || id == Block.pumpkinStem.blockID || id == Block.melonStem.blockID || id == Block.cake.blockID || id == Block.fire.blockID || Block.blocksList[id] instanceof BlockTorch || id == Block.redstoneWire.blockID || id == Block.lever.blockID || id == Block.button.blockID || Block.blocksList[id] instanceof BlockRedstoneRepeater || id == Block.pistonStickyBase.blockID || id == Block.pistonBase.blockID || id == Block.pistonExtension.blockID || id == Block.pistonMoving.blockID || Block.blocksList[id] instanceof BlockRail || PC_BlockUtils.getBlockFlags(world, coord).contains("NO_HARVEST")) {
            return false;
        }
        if (PC_BlockUtils.getBlockFlags(world, coord).contains("HARVEST_STOP")) {
            return true;
        }
        if (PC_TreeHarvestingManager.isBlockTreeWood(id, meta)) {
            ItemStack[] output = PC_TreeHarvestingManager.harvestTreeAt(world, coord);
            if (output != null) {
                for (ItemStack stack : output) {
                    this.addToDispenseList(stack);
                }
            }
            return true;
        }
        if (Block.blocksList[id] instanceof PC_ICropBlock) {
            ItemStack[] harvested;
            if (!((PC_ICropBlock)((Object)Block.blocksList[id])).isMature(world, coord)) {
                return false;
            }
            if (mod_PCcore.soundsEnabled) {
                world.playAuxSFX(2001, coord.x, coord.y, coord.z, id + (meta << 12));
            }
            if ((harvested = ((PC_ICropBlock)((Object)Block.blocksList[id])).machineHarvest(world, coord)) != null) {
                for (ItemStack stack : harvested) {
                    this.addToDispenseList(stack);
                }
            }
        }
        if (PC_CropHarvestingManager.isBlockRegisteredCrop(id)) {
            if (PC_CropHarvestingManager.canHarvestBlock(id, meta)) {
                int newMeta;
                ItemStack[] harvested = PC_CropHarvestingManager.getHarvestedStacks(id, meta);
                if (harvested != null) {
                    for (ItemStack stack : harvested) {
                        if (mod_PCcore.soundsEnabled) {
                            world.playAuxSFX(2001, coord.x, coord.y, coord.z, id + (meta << 12));
                        }
                        this.addToDispenseList(stack);
                    }
                }
                if ((newMeta = PC_CropHarvestingManager.getReplantMeta(id)) == -1) {
                    world.setBlockWithNotify(coord.x, coord.y, coord.z, 0);
                } else {
                    world.setBlockMetadataWithNotify(coord.x, coord.y, coord.z, newMeta);
                }
                return true;
            }
            return false;
        }
        if (world.getBlockTileEntity(coord.x, coord.y, coord.z) != null && world.getBlockTileEntity(coord.x, coord.y, coord.z) instanceof IInventory) {
            return false;
        }
        int dropId = Block.blocksList[id].idDropped(id, world.rand, meta);
        int dropMeta = Block.blocksList[id].damageDropped(meta);
        int dropQuant = Block.blocksList[id].quantityDropped(world.rand);
        if (mod_PCcore.soundsEnabled) {
            world.playAuxSFX(2001, coord.x, coord.y, coord.z, id + (meta << 12));
        }
        world.setBlockWithNotify(coord.x, coord.y, coord.z, id == Block.ice.blockID ? Block.waterMoving.blockID : 0);
        if (id == Block.tallGrass.blockID) {
            dropId = Item.seeds.shiftedIndex;
            if (world.rand.nextInt(5) != 0) {
                return true;
            }
        }
        if (dropId <= 0) {
            dropId = id;
        }
        if (dropQuant <= 0) {
            dropQuant = 1;
        }
        this.addToDispenseList(new ItemStack(dropId, dropQuant, dropMeta));
        return true;
    }

    @Override
    public boolean onEntityHit(World world, Entity[] array, PC_CoordI startCoord) {
        for (Entity entity : array) {
            EntityMooshroom mooshroom;
            if (entity instanceof EntityMinecart) {
                EntityMinecart cart = (EntityMinecart)entity;
                if (cart == null || cart.isDead) continue;
                int l = world.getBlockMetadata(startCoord.x, startCoord.y, startCoord.z) & 7;
                int iPLUS1 = -Facing.offsetsXForSide[l];
                int kPLUS1 = -Facing.offsetsZForSide[l];
                cart.posX = (double)startCoord.x + (double)iPLUS1 * 1.5;
                cart.posY = startCoord.y;
                cart.posZ = (double)startCoord.z + (double)kPLUS1 * 1.5;
                cart.attackEntityFrom(DamageSource.generic, 1000);
                continue;
            }
            if (entity instanceof EntitySheep) {
                EntitySheep sheep = (EntitySheep)entity;
                if (sheep == null || sheep.isDead || sheep.getSheared()) continue;
                sheep.setSheared(true);
                this.addToDispenseList(new ItemStack(Block.cloth.blockID, 1 + world.rand.nextInt(3), sheep.getFleeceColor()));
                continue;
            }
            if (!(entity instanceof EntityMooshroom) || (mooshroom = (EntityMooshroom)entity) == null || mooshroom.isDead || mooshroom.getGrowingAge() < 0) continue;
            EntityCow entitycow = new EntityCow(world);
            entitycow.setLocationAndAngles(mooshroom.posX, mooshroom.posY, mooshroom.posZ, mooshroom.rotationYaw, mooshroom.rotationPitch);
            entitycow.setEntityHealth(mooshroom.getHealth());
            entitycow.renderYawOffset = mooshroom.renderYawOffset;
            mooshroom.setDead();
            mooshroom.deathTime = 0;
            world.spawnParticle("largeexplode", mooshroom.posX, mooshroom.posY + (double)(mooshroom.height / 2.0f), mooshroom.posZ, 0.0, 0.0, 0.0);
            world.spawnEntityInWorld(entitycow);
            this.addToDispenseList(new ItemStack(Block.mushroomRed.blockID, 1 + world.rand.nextInt(5), 0));
        }
        return false;
    }

    private void addToDispenseList(ItemStack stack) {
        this.drops.add(stack);
    }

    private void dispenseItem(World worlda, PC_CoordI devPos, ItemStack itemstack) {
        World world = ModLoader.getMinecraftInstance().theWorld;
        if (itemstack == null || itemstack.stackSize <= 0) {
            return;
        }
        int l = world.getBlockMetadata(devPos.x, devPos.y, devPos.z) & 7;
        int dispIncX = -Facing.offsetsXForSide[l];
        int dispIncZ = -Facing.offsetsZForSide[l];
        double dx = (double)devPos.x + (double)dispIncX * 0.6 + 0.5;
        double dy = (double)devPos.y + 0.5;
        double dz = (double)devPos.z + (double)dispIncZ * 0.6 + 0.5;
        EntityItem entityitem = new EntityItem(world, dx, dy - 0.3, dz, itemstack);
        double throwSpeed = world.rand.nextDouble() * 0.1 + 0.2;
        Set<String> blocktype = PC_BlockUtils.getBlockFlags(world, devPos.offset(dispIncX, 0, dispIncZ));
        if (blocktype.contains("BELT") || blocktype.contains("LIFT")) {
            entityitem.motionX = 0.0;
            entityitem.motionY = 0.0;
            entityitem.motionZ = 0.0;
        } else {
            entityitem.motionX = (double)dispIncX * throwSpeed;
            entityitem.motionY = 0.2f;
            entityitem.motionZ = (double)dispIncZ * throwSpeed;
        }
        entityitem.delayBeforeCanPickup = 5;
        world.spawnEntityInWorld(entityitem);
        if (mod_PCcore.soundsEnabled) {
            world.playAuxSFX(1000, devPos.x, devPos.y, devPos.z, 0);
        }
        world.playAuxSFX(2000, devPos.x, devPos.y, devPos.z, dispIncX + 1 + (dispIncZ + 1) * 3);
    }

    @Override
    public int quantityDropped(Random random) {
        return 1;
    }

    @Override
    public int getMobilityFlag() {
        return 0;
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("HARVEST_STOP");
        set.add("HARVESTER");
        set.add("REDSTONE");
        set.add("MACHINE");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

