/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_ISpecialInventoryTextures;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCma_GuiLaserTypeDecide;
import net.minecraft.src.PCma_Renderer;
import net.minecraft.src.PCma_TileEntityLaser;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCmachines;

public class PCma_BlockLaser
extends BlockContainer
implements PC_IBlockType,
PC_ISpecialInventoryTextures,
PC_ISwapTerrain,
ITextureProvider {
    private static final int TXWOOD = 4;
    private static final int TXGUNON = 20;

    @Override
    public TileEntity getBlockEntity() {
        return new PCma_TileEntityLaser();
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return PCma_Renderer.laserRenderer;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int s, int m) {
        if (s == 1) {
            return 4;
        }
        if (s == 0) {
            return 4;
        }
        if (m == s) {
            return 20;
        }
        if (m == 2 && s == 3 || m == 3 && s == 2 || m == 4 && s == 5 || m == 5 && s == 4) {
            return 4;
        }
        return 4;
    }

    @Override
    public int getInvTexture(int i, int m) {
        if (i == 1) {
            return 4;
        }
        if (i == 0) {
            return 4;
        }
        if (i == 3) {
            return 20;
        }
        if (i == 4) {
            return 4;
        }
        return 4;
    }

    protected PCma_BlockLaser(int i) {
        super(i, Material.ground);
        this.setStepSound(Block.soundMetalFootstep);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool(i, j, k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool(i, j, k, (double)i + 1.0, (double)j + (double)0.7f, (double)k + 1.0);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.3f, 0.3f, 0.2f, 0.7f, 0.7f, 0.8f);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return false;
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
        int l = MathHelper.floor_double((double)(entityliving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        boolean reverse = PC_Utils.isPlacingReversed();
        if (reverse) {
            l = PC_Utils.reverseSide(l);
        }
        if (l == 0) {
            l = 2;
        } else if (l == 1) {
            l = 5;
        } else if (l == 2) {
            l = 3;
        } else if (l == 3) {
            l = 4;
        }
        world.setBlockMetadataWithNotify(i, j, k, l);
        if (entityliving instanceof EntityPlayer) {
            PCma_TileEntityLaser te = (PCma_TileEntityLaser)world.getBlockTileEntity(i, j, k);
            if (te == null) {
                return;
            }
            if (world.getBlockId(i, j - 1, k) == mod_PCmachines.roaster.blockID) {
                te.setType(1);
            } else {
                PC_Utils.openGres((EntityPlayer)entityliving, new PCma_GuiLaserTypeDecide(te));
            }
        }
    }

    @Override
    public int quantityDropped(Random random) {
        return 1;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return ((PCma_TileEntityLaser)iblockaccess.getBlockTileEntity((int)i, (int)j, (int)k)).active;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return this.isPoweringTo(world, i, j, k, l);
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
        super.onBlockRemoval(world, i, j, k);
    }

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public String getTerrainFile() {
        return mod_PCmachines.getTerrainFile();
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("HARVEST_STOP");
        set.add("LASER");
        set.add("REDSTONE");
        set.add("MACHINE");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

