/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCma_Renderer;
import net.minecraft.src.PCma_TileEntityOptical;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.mod_PCcore;
import net.minecraft.src.mod_PCmachines;

public class PCma_BlockOptical
extends BlockContainer
implements PC_IBlockType {
    protected PCma_BlockOptical(int id) {
        super(id, Material.glass);
        float f = 0.4f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.1f, 0.5f - f, 0.5f + f, f1 - 0.1f, 0.5f + f);
    }

    @Override
    public int getRenderType() {
        return PCma_Renderer.opticalRenderer;
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PCma_TileEntityOptical();
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int i) {
        return true;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int idDropped(int par1, Random random, int par3) {
        return -1;
    }

    @Override
    public int quantityDropped(Random random) {
        return 0;
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        if (!PC_Utils.isCreative()) {
            if (PCma_BlockOptical.isMirror(world, i, j, k)) {
                this.dropBlockAsItem_do(world, i, j, k, new ItemStack(mod_PCmachines.optical, 1, 0));
            } else {
                this.dropBlockAsItem_do(world, i, j, k, new ItemStack(mod_PCmachines.optical, 1, 1));
                PCma_TileEntityOptical teo = PCma_BlockOptical.getTE(world, i, j, k);
                if (teo != null) {
                    for (int q = 0; q <= 9; ++q) {
                        if (!teo.getPrismSide(q)) continue;
                        this.dropBlockAsItem_do(world, i, j, k, new ItemStack(Block.thinGlass, 1));
                    }
                }
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        super.onNeighborBlockChange(par1World, par2, par3, par4, par5);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer player) {
        ItemStack ihold = player.getCurrentEquippedItem();
        if (ihold != null) {
            Block bhold;
            if (ihold.itemID == mod_PCcore.powerCrystal.blockID) {
                PCma_TileEntityOptical teo = PCma_BlockOptical.getTE(world, i, j, k);
                if (teo != null) {
                    teo.setMirrorColor(ihold.getItemDamage());
                }
                return true;
            }
            if (ihold.getItem() instanceof ItemBlock && ihold.itemID != this.blockID && (bhold = Block.blocksList[ihold.getItem().shiftedIndex]) instanceof PC_IBlockType) {
                return false;
            }
        }
        if (PCma_BlockOptical.isMirror(world, i, j, k)) {
            int m = MathHelper.floor_double((double)((player.rotationYaw + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF;
            world.setBlockMetadataWithNotify(i, j, k, m);
        } else {
            PCma_TileEntityOptical teo;
            int angle = MathHelper.floor_double((double)((player.rotationYaw + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF;
            angle &= 0xE;
            angle >>= 1;
            if ((angle += 2) > 7) {
                angle -= 8;
            }
            angle += 2;
            if (MathHelper.abs((float)player.posX - ((float)i + 0.5f)) < 1.3f && MathHelper.abs((float)player.posZ - ((float)k + 0.5f)) < 1.3f) {
                double d = player.posY + 1.82 - (double)player.yOffset;
                if (d - (double)j > 2.0) {
                    angle = 1;
                }
                if ((double)j - d > 0.0) {
                    angle = 0;
                }
            }
            boolean drop = true;
            if (ihold != null && ihold.getItem().shiftedIndex == Block.thinGlass.blockID && !PCma_BlockOptical.isGlassPanelOnSide(world, i, j, k, angle)) {
                teo = PCma_BlockOptical.getTE(world, i, j, k);
                if (teo != null) {
                    teo.setPrismSide(angle, true);
                }
                if (!PC_Utils.isCreative()) {
                    --ihold.stackSize;
                }
                drop = false;
            }
            if (drop && PCma_BlockOptical.isGlassPanelOnSide(world, i, j, k, angle)) {
                teo = PCma_BlockOptical.getTE(world, i, j, k);
                if (teo != null) {
                    teo.setPrismSide(angle, false);
                }
                if (!PC_Utils.isCreative()) {
                    this.dropBlockAsItem_do(world, i, j, k, new ItemStack(Block.thinGlass, 1));
                }
            }
        }
        return true;
    }

    public static PCma_TileEntityOptical getTE(IBlockAccess iblockaccess, int x, int y, int z) {
        TileEntity te = iblockaccess.getBlockTileEntity(x, y, z);
        if (te == null) {
            return null;
        }
        PCma_TileEntityOptical tem = (PCma_TileEntityOptical)te;
        return tem;
    }

    public static boolean isGlassPanelOnSide(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        PCma_TileEntityOptical teo = PCma_BlockOptical.getTE(iblockaccess, x, y, z);
        if (teo == null) {
            return false;
        }
        return PCma_BlockOptical.getTE(iblockaccess, x, y, z).getPrismSide(side);
    }

    public static boolean isMirror(IBlockAccess iblockaccess, int x, int y, int z) {
        PCma_TileEntityOptical teo = PCma_BlockOptical.getTE(iblockaccess, x, y, z);
        return teo != null && teo.isMirror();
    }

    public static int getMirrorColor(IBlockAccess iblockaccess, int x, int y, int z) {
        PCma_TileEntityOptical teo = PCma_BlockOptical.getTE(iblockaccess, x, y, z);
        if (teo == null) {
            return 0;
        }
        return teo.getMirrorColor();
    }

    public static boolean isPrism(IBlockAccess iblockaccess, int x, int y, int z) {
        PCma_TileEntityOptical teo = PCma_BlockOptical.getTE(iblockaccess, x, y, z);
        return teo != null && teo.isPrism();
    }

    @Override
    public int getRenderColor(int i) {
        if (i == 0) {
            return 0x999999;
        }
        return 0xFFFFCC;
    }

    @Override
    public int colorMultiplier(IBlockAccess iblockaccess, int i, int j, int k) {
        if (PCma_BlockOptical.isMirror(iblockaccess, i, j, k)) {
            return 0x999999;
        }
        return 0xFFFFCC;
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("TRANSLUCENT");
        set.add("OPTICAL");
        if (PCma_BlockOptical.isMirror(world, pos.x, pos.y, pos.z)) {
            set.add("MIRROR");
        } else {
            set.add("PRISM");
        }
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

