/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_BlockUtils;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_InvUtils;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.mod_PCcore;

public class PCma_EntityFishingMachine
extends Entity {
    private Random rand = new Random();
    private int fishTimer = 100;
    private int waterCheckTimer = 200;
    private int bodyCheckTimer = 100;
    private int burningFuel = 0;
    private PC_CoordI buildPos;
    private int[][] fishPattern = new int[][]{{85, 5, 85}, {5, 42, 5}, {85, 5, 85}};

    public PCma_EntityFishingMachine(World world) {
        super(world);
        this.preventEntitySpawning = true;
        this.setSize(1.0f, 6.0f);
        this.yOffset = 4.0f;
        this.entityCollisionReduction = 1.0f;
        this.stepHeight = 0.0f;
        this.isImmuneToFire = true;
    }

    public PCma_EntityFishingMachine(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1 + (double)this.yOffset, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
        this.dataWatcher.addObject(17, new Integer(0));
        this.dataWatcher.addObject(18, new Integer(1));
        this.dataWatcher.addObject(19, new Integer(0));
    }

    @Override
    public AxisAlignedBB getCollisionBox(Entity entity) {
        return this.boundingBox;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public double getMountedYOffset() {
        return 0.0;
    }

    @Override
    public boolean handleWaterMovement() {
        return false;
    }

    @Override
    public boolean attackEntityFrom(DamageSource damagesource, int i) {
        if (damagesource != DamageSource.outOfWorld && (this.worldObj.isRemote || this.isDead || damagesource.getSourceOfDamage() == null && damagesource != DamageSource.explosion)) {
            return true;
        }
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() + i * 7);
        this.setBeenAttacked();
        if (this.getDamageTaken() > 40) {
            this.turnIntoBlocks();
        }
        return true;
    }

    @Override
    public void performHurtAnimation() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11);
    }

    @Override
    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    public void setVelocity(double d, double d1, double d2) {
        this.motionX = d;
        this.motionY = d1;
        this.motionZ = d2;
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    public boolean tryToBuildFishingMachine(ItemStack stack, EntityPlayer player, World world, PC_CoordI pos) {
        if (this.checkForFishingMachineNearby(pos)) {
            this.spawnFishingMachine(world);
            stack.damageItem(1, player);
            return true;
        }
        return false;
    }

    private boolean checkForFishingMachineNearby(PC_CoordI pos) {
        if (pos.getId(this.worldObj) == 85) {
            int fish = 0;
            boolean errorWater = false;
            fish = this.checkForFishingMachineAt(pos.offset(-2, 0, 0));
            switch (fish) {
                case 0: {
                    pos.offset(-2, 0, 0).offset(1, 0, 1).setBlock(this.worldObj, 0, 0);
                    return true;
                }
                case 2: {
                    errorWater = true;
                }
            }
            fish = this.checkForFishingMachineAt(pos.offset(0, 0, -2));
            switch (fish) {
                case 0: {
                    pos.offset(0, 0, -2).offset(1, 0, 1).setBlock(this.worldObj, 0, 0);
                    return true;
                }
                case 2: {
                    errorWater = true;
                }
            }
            fish = this.checkForFishingMachineAt(pos.offset(-2, 0, -2));
            switch (fish) {
                case 0: {
                    pos.offset(-2, 0, -2).offset(1, 0, 1).setBlock(this.worldObj, 0, 0);
                    return true;
                }
                case 2: {
                    errorWater = true;
                }
            }
            fish = this.checkForFishingMachineAt(pos.offset(0, 0, 0));
            switch (fish) {
                case 0: {
                    pos.offset(0, 0, 0).offset(1, 0, 1).setBlock(this.worldObj, 0, 0);
                    return true;
                }
                case 2: {
                    errorWater = true;
                }
            }
            if (errorWater) {
                PC_Utils.chatMsg(PC_Lang.tr("pc.fisher.errWater"), false);
            } else {
                PC_Utils.chatMsg(PC_Lang.tr("pc.fisher.errStructure"), false);
            }
        } else if (pos.getId(this.worldObj) == 5) {
            PC_Utils.chatMsg(PC_Lang.tr("pc.fisher.errClickedPlanks"), false);
        }
        return false;
    }

    private int checkForFishingMachineAt(PC_CoordI pos) {
        this.buildPos = pos.copy();
        if (!this.isBodyComplete(true)) {
            return 1;
        }
        if (!this.hasEnoughWater()) {
            return 2;
        }
        this.setLocationAndAngles((double)pos.x + 1.5, (float)pos.y - this.yOffset, (double)pos.z + 1.5, 0.0f, 0.0f);
        return 0;
    }

    private void spawnFishingMachine(World world) {
        world.spawnEntityInWorld(this);
    }

    private boolean hasEnoughWater() {
        int nonWaters = 0;
        int critical = 0;
        for (int x = this.buildPos.x; x <= this.buildPos.x + 2; ++x) {
            for (int z = this.buildPos.z; z <= this.buildPos.z + 2; ++z) {
                for (int y = this.buildPos.y - 1; y > this.buildPos.y - 8; --y) {
                    int id = new PC_CoordI(x, y, z).getId(this.worldObj);
                    if (id == 8 || id == 9) continue;
                    ++nonWaters;
                    if ((x != this.buildPos.x + 1 || z != this.buildPos.z + 1) && y < this.buildPos.y - 3) continue;
                    ++critical;
                }
            }
        }
        return nonWaters <= 20 && critical <= 2;
    }

    private boolean isBodyComplete(boolean building) {
        for (int x = this.buildPos.x; x <= this.buildPos.x + 2; ++x) {
            for (int z = this.buildPos.z; z <= this.buildPos.z + 2; ++z) {
                if (this.worldObj.getBlockId(x, this.buildPos.y, z) == this.fishPattern[x - this.buildPos.x][z - this.buildPos.z] || !building && x == this.buildPos.x + 1 && z == this.buildPos.z + 1) continue;
                return false;
            }
        }
        return this.buildPos.offset(1, 1, 1).getId(this.worldObj) == 54;
    }

    private void checkWaterState() {
        if (!this.hasEnoughWater()) {
            this.turnIntoBlocks();
        }
    }

    private void checkBodyState() {
        if (!this.isBodyComplete(false)) {
            this.turnIntoBlocks();
        }
    }

    private void catchFish() {
        int i;
        PC_CoordI[] outputs = new PC_CoordI[]{this.buildPos.offset(-1, 0, 1), this.buildPos.offset(3, 0, 1), this.buildPos.offset(1, 0, -1), this.buildPos.offset(1, 0, 3)};
        for (i = 0; i <= 3; ++i) {
            if (!PC_BlockUtils.hasFlag(this.worldObj, outputs[i], "BELT") && !PC_BlockUtils.hasFlag(this.worldObj, outputs[i], "LIFT")) continue;
            this.ejectFish_do(outputs[i], false);
            return;
        }
        for (i = 0; i <= 3; ++i) {
            if (outputs[i].getId(this.worldObj) != 0) continue;
            this.ejectFish_do(outputs[i], true);
            return;
        }
    }

    private void ejectFish_do(PC_CoordI out, boolean fast) {
        ItemStack caught = new ItemStack(this.rand.nextInt(6) == 0 ? Item.dyePowder : Item.fishRaw, 1, 0);
        EntityItem entityitem = new EntityItem(this.worldObj, (double)out.x + 0.5, (double)out.y + 0.5, (double)out.z + 0.5, caught);
        if (!fast) {
            entityitem.motionX = 0.0;
            entityitem.motionY = 0.0;
            entityitem.motionZ = 0.0;
        }
        entityitem.delayBeforeCanPickup = 10;
        this.worldObj.spawnEntityInWorld(entityitem);
        if (mod_PCcore.soundsEnabled) {
            this.worldObj.playSoundAtEntity(entityitem, "random.splash", 0.2f, 0.5f + this.rand.nextFloat() * 0.3f);
        }
    }

    @Override
    public void onUpdate() {
        boolean running;
        super.onUpdate();
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0) {
            this.setDamageTaken(this.getDamageTaken() - 1);
        }
        if (running = this.checkFuel()) {
            for (int i = 0; i < 2; ++i) {
                double buX = this.posX - 0.3 + (double)(this.rand.nextFloat() * 0.6f);
                double buY = this.posY + (double)this.yOffset - 4.8 + (double)(this.rand.nextFloat() * 0.6f);
                double buZ = this.posZ - 0.3 + (double)(this.rand.nextFloat() * 0.6f);
                this.worldObj.spawnParticle("bubble", buX, buY, buZ, 0.0, 0.01f, 0.0);
            }
            if (this.rand.nextInt(20) == 0 && mod_PCcore.soundsEnabled) {
                this.worldObj.playSoundAtEntity(this, "random.splash", 0.08f, 0.5f + this.rand.nextFloat() * 0.3f);
            }
            if (this.rand.nextInt(2) == 0) {
                double chimX = this.posX - (double)0.1f + (double)(this.rand.nextFloat() * 0.2f);
                double chimY = this.posY + (double)2.4f;
                double chimZ = this.posZ - (double)0.8f + (double)(this.rand.nextFloat() * 0.2f);
                this.worldObj.spawnParticle("largesmoke", chimX, chimY, chimZ, 0.0, 0.0, 0.0);
            }
            this.rotationYaw -= 15.0f;
            if (this.rotationYaw <= 0.0f) {
                this.rotationYaw += 360.0f;
                this.prevRotationYaw = this.rotationYaw + 15.0f;
            }
        }
        if (--this.waterCheckTimer == 0) {
            this.waterCheckTimer += 300;
            this.checkWaterState();
        }
        if (--this.bodyCheckTimer == 0) {
            this.bodyCheckTimer += 80;
            this.checkBodyState();
        }
        if (running && --this.fishTimer == 0) {
            this.fishTimer = 250 + this.rand.nextInt(350);
            this.catchFish();
        }
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound tag) {
        tag.setInteger("buildX", this.buildPos.x);
        tag.setInteger("buildY", this.buildPos.y);
        tag.setInteger("buildZ", this.buildPos.z);
        tag.setInteger("fishTimer", this.fishTimer);
        tag.setInteger("burningFuel", this.burningFuel);
        tag.setInteger("waterCheckTimer", this.waterCheckTimer);
        tag.setInteger("bodyCheckTimer", this.bodyCheckTimer);
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound tag) {
        this.buildPos = new PC_CoordI(tag.getInteger("buildX"), tag.getInteger("buildY"), tag.getInteger("buildZ"));
        this.fishTimer = tag.getInteger("fishTimer");
        this.burningFuel = tag.getInteger("burningFuel");
        this.waterCheckTimer = tag.getInteger("waterCheckTimer");
        this.bodyCheckTimer = tag.getInteger("bodyCheckTimer");
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        return Block.chest.blockActivated(this.worldObj, this.buildPos.x + 1, this.buildPos.y + 1, this.buildPos.z + 1, entityplayer);
    }

    public void setDamageTaken(int i) {
        this.dataWatcher.updateObject(19, i);
    }

    public int getDamageTaken() {
        return this.dataWatcher.getWatchableObjectInt(19);
    }

    public void setTimeSinceHit(int i) {
        this.dataWatcher.updateObject(17, i);
    }

    public int getTimeSinceHit() {
        return this.dataWatcher.getWatchableObjectInt(17);
    }

    public void setForwardDirection(int i) {
        this.dataWatcher.updateObject(18, i);
    }

    public int getForwardDirection() {
        return this.dataWatcher.getWatchableObjectInt(18);
    }

    private void turnIntoBlocks() {
        this.buildPos.offset(1, 0, 1).setBlock(this.worldObj, 42, 0);
        this.setDead();
    }

    private IInventory getChestInventory() {
        TileEntity te = this.buildPos.offset(1, 1, 1).getTileEntity(this.worldObj);
        if (te instanceof IInventory) {
            return (IInventory)((Object)te);
        }
        return null;
    }

    private boolean checkFuel() {
        if (this.burningFuel > 11) {
            this.burningFuel -= 3;
            return true;
        }
        IInventory inv = this.getChestInventory();
        if (inv == null) {
            this.turnIntoBlocks();
            return false;
        }
        for (int s = 0; s < inv.getSizeInventory(); ++s) {
            ItemStack stack = inv.getStackInSlot(s);
            int cost = PC_InvUtils.getFuelValue(stack, 1.0);
            if (cost <= 0) continue;
            this.burningFuel += cost;
            if (stack.getItem().hasContainerItem()) {
                inv.setInventorySlotContents(s, new ItemStack(stack.getItem().getContainerItem(), 1, 0));
            } else {
                inv.decrStackSize(s, 1);
            }
            return true;
        }
        return false;
    }
}

