/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.DamageSource;
import net.minecraft.src.EntityCow;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityMooshroom;
import net.minecraft.src.EntityThrowable;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.PCma_IThrownItem;
import net.minecraft.src.World;

public class PCma_EntityThrownBucket
extends EntityThrowable
implements PCma_IThrownItem {
    public boolean isBowl = false;

    public PCma_EntityThrownBucket(World world, double d, double d1, double d2, boolean bowl) {
        super(world, d, d1, d2);
        this.isBowl = bowl;
    }

    @Override
    protected void onImpact(MovingObjectPosition movingobjectposition) {
        if (movingobjectposition.entityHit != null) {
            if (movingobjectposition.entityHit instanceof EntityCow) {
                if (movingobjectposition.entityHit instanceof EntityMooshroom) {
                    if (this.isBowl) {
                        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.bowlSoup, 1, 0));
                        entityitem.motionX = this.motionX;
                        entityitem.motionY = this.motionY;
                        entityitem.motionZ = this.motionZ;
                        this.worldObj.spawnEntityInWorld(entityitem);
                    } else {
                        this.dropOrigItem();
                    }
                } else if (!this.isBowl) {
                    EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.bucketMilk, 1, 0));
                    entityitem.motionX = this.motionX;
                    entityitem.motionY = this.motionY;
                    entityitem.motionZ = this.motionZ;
                    this.worldObj.spawnEntityInWorld(entityitem);
                } else {
                    this.dropOrigItem();
                }
            } else {
                this.dropOrigItem();
            }
            movingobjectposition.entityHit.attackEntityFrom(DamageSource.causeThrownDamage(this, this.thrower), 0);
        } else {
            this.dropOrigItem();
        }
        if (!this.worldObj.isRemote) {
            this.setDead();
        }
    }

    private void dropOrigItem() {
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(this.isBowl ? Item.bowlEmpty : Item.bucketEmpty, 1, 0));
        entityitem.motionX = this.motionX;
        entityitem.motionY = this.motionY;
        entityitem.motionZ = this.motionZ;
        this.worldObj.spawnEntityInWorld(entityitem);
    }

    @Override
    public void setThrowableHeading(double d, double d1, double d2, float f, float f1) {
        super.setThrowableHeading(d, d1, d2, f, f1);
        float f2 = MathHelper.sqrt_double(d * d + d1 * d1 + d2 * d2);
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d += ((double)0.7f + this.rand.nextGaussian() * (double)0.3f) * (double)0.0075f * (double)f1;
        d1 += ((double)0.7f + this.rand.nextGaussian() * (double)0.3f) * (double)0.0075f * (double)f1;
        d2 += ((double)0.7f + this.rand.nextGaussian() * (double)0.3f) * (double)0.0075f * (double)f1;
        this.motionX = d *= (double)f;
        this.motionY = d1 *= (double)f;
        this.motionZ = d2 *= (double)f;
        float f3 = MathHelper.sqrt_double(d * d + d2 * d2);
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
    }

    @Override
    public byte getIconIndex() {
        return (byte)(this.isBowl ? Item.bowlEmpty.iconIndex : Item.bucketEmpty.iconIndex);
    }
}

