/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PCma_TileEntityOptical;
import net.minecraft.src.World;
import net.minecraft.src.mod_PClogic;
import net.minecraft.src.mod_PCmachines;

public class PCma_ItemBlockOptical
extends ItemBlock {
    public PCma_ItemBlockOptical(int i) {
        super(i);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @Override
    public int getBlockID() {
        return mod_PCmachines.optical.blockID;
    }

    @Override
    public String getItemNameIS(ItemStack itemstack) {
        return super.getItemName() + "." + (itemstack.getItemDamage() == 0 ? "mirror" : "prism");
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l) {
        int id = world.getBlockId(i, j, k);
        if (id == Block.snow.blockID) {
            l = 1;
        } else if (id != Block.vine.blockID && id != Block.tallGrass.blockID && id != Block.deadBush.blockID) {
            if (l == 0) {
                --j;
            }
            if (l == 1) {
                ++j;
            }
            if (l == 2) {
                --k;
            }
            if (l == 3) {
                ++k;
            }
            if (l == 4) {
                --i;
            }
            if (l == 5) {
                ++i;
            }
        }
        if (itemstack.stackSize == 0) {
            return false;
        }
        if (!entityplayer.canPlayerEdit(i, j, k)) {
            return false;
        }
        if (j == 255 && Block.blocksList[this.getBlockID()].blockMaterial.isSolid()) {
            return false;
        }
        if (world.canBlockBePlacedAt(this.getBlockID(), i, j, k, false, l)) {
            Block block = mod_PCmachines.optical;
            if (world.setBlock(i, j, k, block.blockID)) {
                int meta = MathHelper.floor_double((double)((entityplayer.rotationYaw + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF;
                if (itemstack.getItemDamage() != 0) {
                    meta = 0;
                }
                world.setBlockAndMetadataWithNotify(i, j, k, mod_PCmachines.optical.blockID, meta);
                PCma_TileEntityOptical teo = (PCma_TileEntityOptical)world.getBlockTileEntity(i, j, k);
                if (teo == null) {
                    teo = new PCma_TileEntityOptical();
                }
                if (itemstack.getItemDamage() == 0) {
                    teo.setMirror();
                } else {
                    teo.setPrism();
                }
                world.setBlockTileEntity(i, j, k, teo);
                mod_PCmachines.optical.onBlockPlaced(world, i, j, k, i);
                mod_PCmachines.optical.onBlockPlacedBy(world, i, j, k, entityplayer);
                world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, block.stepSound.getStepSound(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                world.markBlocksDirty(i, j, k, i, j, k);
                world.markBlockNeedsUpdate(i, j, k);
                --itemstack.stackSize;
            }
        }
        return true;
    }

    @Override
    public String getItemName() {
        return mod_PClogic.lightOff.getBlockName();
    }

    @Override
    public int getIconFromDamage(int i) {
        return mod_PCmachines.optical.getBlockTextureFromSideAndMetadata(1, 0);
    }
}

