/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import net.minecraft.src.Block;
import net.minecraft.src.Container;
import net.minecraft.src.CraftingManager;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.PC_ISpecialInsertInventory;
import net.minecraft.src.PC_IStateReportingInventory;
import net.minecraft.src.PCma_ContainerFake;
import net.minecraft.src.TileEntity;
import net.minecraft.src.mod_PCcore;

public class PCma_TileEntityAutomaticWorkbench
extends TileEntity
implements IInventory,
PC_IStateReportingInventory,
PC_ISpecialInsertInventory {
    private static Container fakeContainer = new PCma_ContainerFake();
    private ItemStack[] actContents = new ItemStack[18];

    private InventoryCrafting getStorageAsCraftingGrid(Container container) {
        if (container == null) {
            container = fakeContainer;
        }
        InventoryCrafting craftGrid = new InventoryCrafting(container, 3, 3);
        for (int n = 0; n < 9; ++n) {
            craftGrid.setInventorySlotContents(n, this.getStackInSlot(n));
        }
        return craftGrid;
    }

    private InventoryCrafting getRecipeAsCraftingGrid(Container container) {
        if (container == null) {
            container = fakeContainer;
        }
        InventoryCrafting craftGrid = new InventoryCrafting(container, 3, 3);
        for (int n = 9; n < 18; ++n) {
            craftGrid.setInventorySlotContents(n - 9, this.getStackInSlot(n));
        }
        return craftGrid;
    }

    private boolean areProductsMatching() {
        ItemStack recipe = this.getRecipeProduct();
        ItemStack storage = this.getStorageProduct();
        if (recipe == null || storage == null) {
            return false;
        }
        return storage.isStackEqual(recipe);
    }

    public ItemStack getStorageProduct() {
        ItemStack product = CraftingManager.getInstance().findMatchingRecipe(this.getStorageAsCraftingGrid(null));
        if (product != null) {
            return product.copy();
        }
        return null;
    }

    public ItemStack getRecipeProduct() {
        ItemStack product = CraftingManager.getInstance().findMatchingRecipe(this.getRecipeAsCraftingGrid(null));
        if (product != null) {
            return product.copy();
        }
        return null;
    }

    @Override
    public boolean isContainerEmpty() {
        for (int i = 0; i < 9; ++i) {
            if (this.getStackInSlot(i) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isContainerFull() {
        for (int i = 0; i < 9; ++i) {
            if (this.getStackInSlot(i) != null || this.getStackInSlot(i + 9) == null) continue;
            return false;
        }
        return true;
    }

    private boolean isOnStoneBrick() {
        return this.worldObj.getBlockId(this.xCoord, this.yCoord - 1, this.zCoord) == Block.stoneBrick.blockID;
    }

    @Override
    public void onInventoryChanged() {
    }

    public void reorderACT() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            this.setInventorySlotContents(i, null);
            if (stack == null) continue;
            for (int j = i + 1; j < 9; ++j) {
                ItemStack stack2 = this.getStackInSlot(j);
                if (stack2 == null || stack.itemID != stack2.itemID || stack.getHasSubtypes() && stack.getItemDamage() != stack2.getItemDamage()) continue;
                stack.stackSize += stack2.stackSize;
                this.setInventorySlotContents(j, null);
            }
            stacks.add(stack);
        }
        for (ItemStack stack : stacks) {
            this.insertStackIntoInventory(stack);
            if (stack.stackSize <= 0) continue;
            int itemX = this.xCoord;
            int itemY = this.yCoord;
            int itemZ = this.zCoord;
            int orientation = this.getBlockMetadata();
            switch (orientation) {
                case 0: {
                    ++itemZ;
                    break;
                }
                case 1: {
                    --itemX;
                    break;
                }
                case 2: {
                    --itemZ;
                    break;
                }
                case 3: {
                    ++itemX;
                }
            }
            while (stack.stackSize > 0) {
                int batchSize = Math.min(stack.stackSize, stack.getMaxStackSize());
                ItemStack batch = stack.splitStack(batchSize);
                EntityItem drop = new EntityItem(this.worldObj, (double)itemX + 0.5, (double)itemY + 0.5, (double)itemZ + 0.5, batch);
                drop.motionX = 0.0;
                drop.motionY = 0.0;
                drop.motionZ = 0.0;
                this.worldObj.spawnEntityInWorld(drop);
            }
        }
        this.onInventoryChanged();
    }

    @Override
    public boolean insertStackIntoInventory(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        boolean[] matching = new boolean[9];
        for (int i = 0; i < 9; ++i) {
            if (this.getStackInSlot(i + 9) == null) continue;
            ItemStack storageStack = this.getStackInSlot(i);
            matching[i] = stack.isItemEqual(this.getStackInSlot(i + 9)) && (storageStack == null || storageStack.stackSize <= storageStack.getMaxStackSize());
        }
        boolean end = false;
        while (!end) {
            boolean storedSomething = false;
            for (int i = 0; i < 9; ++i) {
                if (!matching[i]) continue;
                ItemStack storageStack = this.getStackInSlot(i);
                boolean bl = matching[i] = storageStack == null || storageStack.stackSize < storageStack.getMaxStackSize();
                if (matching[i]) {
                    if (storageStack == null) {
                        this.setInventorySlotContents(i, stack.splitStack(1));
                    } else {
                        ++storageStack.stackSize;
                        --stack.stackSize;
                    }
                    storedSomething = true;
                }
                if (stack.stackSize <= 0) {
                    end = true;
                }
                if (end) break;
            }
            if (!end && storedSomething) continue;
        }
        return stack.stackSize <= 0;
    }

    @Override
    public void onStackInserted() {
        this.orderAndCraft();
    }

    public void orderAndCraft() {
        this.reorderACT();
        if (!this.isOnStoneBrick()) {
            this.doCrafting();
        }
        this.reorderACT();
    }

    public void doCrafting() {
        ItemStack currentStack = null;
        boolean forceEject = false;
        while (this.areProductsMatching()) {
            if (currentStack == null) {
                currentStack = this.getStorageProduct();
                this.decrementStorage();
            } else if (currentStack.stackSize + this.getStorageProduct().stackSize >= currentStack.getMaxStackSize()) {
                forceEject = true;
            } else {
                currentStack.stackSize += this.getStorageProduct().stackSize;
                this.decrementStorage();
            }
            if (currentStack == null || (!forceEject || currentStack.stackSize <= 0) && currentStack.stackSize < currentStack.getMaxStackSize() && !this.isOnStoneBrick()) continue;
            this.dispenseItem(currentStack);
            currentStack = null;
            if (!this.isOnStoneBrick()) continue;
            return;
        }
        if (currentStack != null) {
            this.dispenseItem(currentStack);
        }
    }

    public void decrementStorage() {
        for (int i = 0; i < 9; ++i) {
            if (this.actContents[i] == null) continue;
            if (this.actContents[i].getItem().hasContainerItem()) {
                this.setInventorySlotContents(i, new ItemStack(this.actContents[i].getItem().getContainerItem()));
                continue;
            }
            --this.actContents[i].stackSize;
            if (this.actContents[i].stackSize > 0) continue;
            this.actContents[i] = null;
        }
    }

    public void decrementRecipe() {
        for (int i = 9; i < 18; ++i) {
            if (this.actContents[i] == null) continue;
            if (this.actContents[i].getItem().hasContainerItem()) {
                this.setInventorySlotContents(i, new ItemStack(this.actContents[i].getItem().getContainerItem()));
                continue;
            }
            --this.actContents[i].stackSize;
            if (this.actContents[i].stackSize > 0) continue;
            this.actContents[i] = null;
        }
    }

    private boolean dispenseItem(ItemStack stack2drop) {
        if (stack2drop == null || stack2drop.stackSize <= 0) {
            return false;
        }
        int meta = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
        int i1 = 0;
        int j1 = 0;
        switch (meta) {
            case 0: {
                j1 = 1;
                break;
            }
            case 1: {
                i1 = -1;
                break;
            }
            case 2: {
                j1 = -1;
                break;
            }
            case 3: {
                i1 = 1;
            }
        }
        double d = (double)this.xCoord + (double)i1 * 0.6 + 0.5;
        double d1 = (double)this.yCoord + 0.5;
        double d2 = (double)this.zCoord + (double)j1 * 0.6 + 0.5;
        double d3 = this.worldObj.rand.nextDouble() * 0.02000000000000001 + 0.05000000000000001;
        EntityItem entityitem = new EntityItem(this.worldObj, d, d1 - 0.3, d2, stack2drop.copy());
        entityitem.motionX = (double)i1 * d3;
        entityitem.motionY = 0.05000000298023221;
        entityitem.motionZ = (double)j1 * d3;
        this.worldObj.spawnEntityInWorld(entityitem);
        if (mod_PCcore.soundsEnabled) {
            this.worldObj.playAuxSFX(1000, this.xCoord, this.yCoord, this.zCoord, 0);
        }
        return true;
    }

    @Override
    public int getSizeInventory() {
        return 18;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.actContents[i];
    }

    @Override
    public void openChest() {
    }

    @Override
    public void closeChest() {
        this.reorderACT();
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.actContents[i] != null) {
            if (this.actContents[i].stackSize <= j) {
                ItemStack itemstack = this.actContents[i];
                this.actContents[i] = null;
                this.onInventoryChanged();
                return itemstack;
            }
            ItemStack itemstack1 = this.actContents[i].splitStack(j);
            if (this.actContents[i].stackSize == 0) {
                this.actContents[i] = null;
            }
            this.onInventoryChanged();
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.actContents[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
        this.onInventoryChanged();
    }

    @Override
    public String getInvName() {
        return "Automatic Workbench";
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
        this.actContents = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i);
            int j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j < 0 || j >= this.actContents.length) continue;
            this.actContents[j] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.actContents.length; ++i) {
            if (this.actContents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            this.actContents[i].writeToNBT(nbttagcompound1);
            nbttaglist.appendTag(nbttagcompound1);
        }
        nbttagcompound.setTag("Items", nbttaglist);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return entityplayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int par1) {
        if (this.actContents[par1] != null) {
            ItemStack itemstack = this.actContents[par1];
            this.actContents[par1] = null;
            return itemstack;
        }
        return null;
    }
}

