/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockRail;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Facing;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemMinecart;
import net.minecraft.src.ItemMonsterPlacer;
import net.minecraft.src.ItemReed;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.PC_BlockUtils;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_FakePlayer;
import net.minecraft.src.TileEntity;
import net.minecraft.src.mod_PCcore;

public class PCma_TileEntityBlockBuilder
extends TileEntity
implements IInventory {
    private ItemStack[] stacks = new ItemStack[9];
    private Random rand = new Random();
    private PC_FakePlayer fakeplayer;

    public boolean canUpdate() {
        return false;
    }

    @Override
    public int getSizeInventory() {
        return 9;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.stacks[i];
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.stacks[i] != null) {
            if (this.stacks[i].stackSize <= j) {
                ItemStack itemstack = this.stacks[i];
                this.stacks[i] = null;
                this.onInventoryChanged();
                return itemstack;
            }
            ItemStack itemstack1 = this.stacks[i].splitStack(j);
            if (this.stacks[i].stackSize == 0) {
                this.stacks[i] = null;
            }
            this.onInventoryChanged();
            return itemstack1;
        }
        return null;
    }

    public void useItem() {
        if (this.fakeplayer == null) {
            this.fakeplayer = new PC_FakePlayer(this.worldObj);
        }
        int maxdist = 150;
        if (this.worldObj.getBlockId(this.xCoord, this.yCoord - 1, this.zCoord) == Block.stoneBrick.blockID) {
            maxdist = 1;
        }
        int i = -1;
        int j = 1;
        for (int k = 0; k < this.stacks.length; ++k) {
            if (this.stacks[k] == null || this.rand.nextInt(j++) != 0) continue;
            i = k;
        }
        if (i >= 0) {
            for (int dist = 0; dist < maxdist; ++dist) {
                int state = this.try2useItem(this.getStackInSlot(i).copy(), dist);
                if (state == -1) {
                    return;
                }
                if (state == 0) continue;
                if (state != 0 && mod_PCcore.soundsEnabled) {
                    this.worldObj.playAuxSFX(1000, this.xCoord, this.yCoord, this.zCoord, 0);
                }
                if (state == 1) {
                    this.decrStackSize(i, 1);
                }
                if (state == 2) {
                    this.getStackInSlot(i).damageItem(1, this.fakeplayer);
                    if (this.getStackInSlot(i) != null && this.getStackInSlot((int)i).stackSize <= 0) {
                        this.setInventorySlotContents(i, null);
                    }
                }
                return;
            }
        } else {
            if (mod_PCcore.soundsEnabled) {
                this.worldObj.playAuxSFX(1001, this.xCoord, this.yCoord, this.zCoord, 0);
            }
            return;
        }
    }

    private int try2useItem(ItemStack itemstack, int dist) {
        int x = this.xCoord;
        int y = this.yCoord;
        int z = this.zCoord;
        int l = this.worldObj.getBlockMetadata(x, y, z) & 7;
        int incX = Facing.offsetsXForSide[l];
        int incZ = Facing.offsetsZForSide[l];
        PC_CoordI front = new PC_CoordI((x += dist * incX) + incX, y, (z += dist * incZ) + incZ);
        PC_CoordI below = new PC_CoordI(x + incX, y - 1, z + incZ);
        PC_CoordI above = new PC_CoordI(x + incX, y + 1, z + incZ);
        int idFront = front.getId(this.worldObj);
        int metaFront = front.getMeta(this.worldObj);
        int idBelow = below.getId(this.worldObj);
        int metaBelow = below.getMeta(this.worldObj);
        int idAbove = above.getId(this.worldObj);
        int metaAbove = above.getMeta(this.worldObj);
        int id = idFront;
        if (itemstack.getItem() instanceof ItemMinecart && (PC_BlockUtils.hasFlag(this.worldObj, front, "BELT") || Block.blocksList[id] instanceof BlockRail)) {
            if (!this.worldObj.isRemote) {
                this.worldObj.spawnEntityInWorld(new EntityMinecart(this.worldObj, (float)x + (float)incX + 0.5f, (float)y + 0.5f, (float)z + (float)incZ + 0.5f, ((ItemMinecart)itemstack.getItem()).minecartType));
            }
            return 1;
        }
        if (id == 49 || id == 7 || id == 98 || PC_BlockUtils.hasFlag(this.worldObj, front, "HARVEST_STOP") && (!PC_BlockUtils.hasFlag(this.worldObj, front, "BELT") || PC_BlockUtils.hasFlag(this.worldObj, front, "TRANSLUCENT"))) {
            return -1;
        }
        if (itemstack.getItem() instanceof ItemBlock) {
            ItemBlock item = (ItemBlock)itemstack.getItem();
            if (PC_BlockUtils.hasFlag(itemstack, "NO_BUILD")) {
                return 0;
            }
            if (Block.blocksList[item.shiftedIndex].canPlaceBlockAt(this.worldObj, x + incX, y, z + incZ)) {
                this.worldObj.setBlockAndMetadataWithNotify(x + incX, y, z + incZ, item.shiftedIndex, item.getMetadata(itemstack.getItemDamage()));
                return 1;
            }
            if (this.isEmptyBlock(idFront) && Block.blocksList[item.shiftedIndex].canPlaceBlockAt(this.worldObj, x + incX * 2, y, z + incZ * 2)) {
                this.worldObj.setBlockAndMetadataWithNotify(x + incX * 2, y, z + incZ * 2, item.shiftedIndex, item.getMetadata(itemstack.getItemDamage()));
                return 1;
            }
            return 0;
        }
        if (!this.isEmptyBlock(idFront) && !(itemstack.getItem() instanceof ItemReed)) {
            int dmgOrig = itemstack.getItemDamage();
            int sizeOrig = itemstack.stackSize;
            if (itemstack.getItem().onItemUse(itemstack, this.fakeplayer, this.worldObj, x + incX, y, z + incZ, 1)) {
                if (itemstack.getItem() instanceof ItemMonsterPlacer) {
                    return 1;
                }
                int idFrontNew = this.worldObj.getBlockId(x + incX, y, z + incZ);
                int metaFrontNew = this.worldObj.getBlockMetadata(x + incX, y, z + incZ);
                int idAboveNew = this.worldObj.getBlockId(x + incX, y + 1, z + incZ);
                int metaAboveNew = this.worldObj.getBlockMetadata(x + incX, y + 1, z + incZ);
                int dmgNew = itemstack.getItemDamage();
                int sizeNew = itemstack.stackSize;
                if (itemstack.getItem().shiftedIndex != Item.dyePowder.shiftedIndex || itemstack.getItemDamage() != 15 || idFront != idFrontNew || metaFront != metaFrontNew || idAbove != idAboveNew || metaAbove != metaAboveNew) {
                    if (dmgOrig != dmgNew) {
                        return 2;
                    }
                    if (sizeOrig != sizeNew) {
                        return 1;
                    }
                }
            }
        }
        if (this.isEmptyBlock(idFront) && !this.isEmptyBlock(idBelow)) {
            int dmg1 = itemstack.getItemDamage();
            int size1 = itemstack.stackSize;
            if (itemstack.getItem().onItemUse(itemstack, this.fakeplayer, this.worldObj, x + incX, y - 1, z + incZ, 1)) {
                if (itemstack.getItem() instanceof ItemMonsterPlacer) {
                    return 1;
                }
                int idBelowNew = this.worldObj.getBlockId(x + incX, y - 1, z + incZ);
                int metaBelowNew = this.worldObj.getBlockMetadata(x + incX, y - 1, z + incZ);
                int idFrontNew = this.worldObj.getBlockId(x + incX, y, z + incZ);
                int metaFrontNew = this.worldObj.getBlockMetadata(x + incX, y, z + incZ);
                int dmg2 = itemstack.getItemDamage();
                int size2 = itemstack.stackSize;
                if (itemstack.getItem().shiftedIndex != Item.dyePowder.shiftedIndex || itemstack.getItemDamage() != 15 || idBelow != idBelowNew || metaBelow != metaBelowNew || idFront != idFrontNew || metaFront != metaFrontNew) {
                    if (dmg1 != dmg2) {
                        return 2;
                    }
                    if (size1 != size2) {
                        return 1;
                    }
                }
            }
        }
        return 0;
    }

    private boolean isEmptyBlock(int id) {
        return id == 0 || id == 8 || id == 9 || id == 10 || id == 11 || id == Block.snow.blockID;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.stacks[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
        this.onInventoryChanged();
    }

    @Override
    public String getInvName() {
        return "Block Dispenser";
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
        this.stacks = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i);
            int j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j < 0 || j >= this.stacks.length) continue;
            this.stacks[j] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            this.stacks[i].writeToNBT(nbttagcompound1);
            nbttaglist.appendTag(nbttagcompound1);
        }
        nbttagcompound.setTag("Items", nbttaglist);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return entityplayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    @Override
    public void openChest() {
    }

    @Override
    public void closeChest() {
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int par1) {
        if (this.stacks[par1] != null) {
            ItemStack itemstack = this.stacks[par1];
            this.stacks[par1] = null;
            return itemstack;
        }
        return null;
    }
}

