/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.PC_Color;
import net.minecraft.src.PCma_ModelMirror;
import net.minecraft.src.PCma_ModelPrism;
import net.minecraft.src.PCma_TileEntityOptical;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntitySpecialRenderer;
import net.minecraft.src.World;
import net.minecraft.src.mod_PCmachines;
import org.lwjgl.opengl.GL11;

public class PCma_TileEntityOpticalRenderer
extends TileEntitySpecialRenderer {
    private PCma_ModelMirror modelMirror = new PCma_ModelMirror();
    private PCma_ModelPrism modelPrism = new PCma_ModelPrism();

    private void renderTileEntityOpticalAt(PCma_TileEntityOptical tileentity, double x, double y, double z, float f0) {
        if (tileentity.isMirror()) {
            World world = tileentity.worldObj;
            this.modelMirror.bottomSticks.showModel = false;
            this.modelMirror.ceilingSticks.showModel = false;
            this.modelMirror.stickXplus.showModel = false;
            this.modelMirror.stickXminus.showModel = false;
            this.modelMirror.stickZplus.showModel = false;
            this.modelMirror.stickZminus.showModel = false;
            this.modelMirror.stickZminus.showModel = false;
            this.modelMirror.signBoard.showModel = true;
            int i = tileentity.xCoord;
            int j = tileentity.yCoord;
            int k = tileentity.zCoord;
            if (world.getBlockMaterial(i, j - 1, k).isSolid()) {
                this.modelMirror.bottomSticks.showModel = true;
            } else if (world.getBlockMaterial(i, j + 1, k).isSolid()) {
                this.modelMirror.ceilingSticks.showModel = true;
            } else if (world.getBlockMaterial(i + 1, j, k).isSolid()) {
                this.modelMirror.stickXplus.showModel = true;
            } else if (world.getBlockMaterial(i - 1, j, k).isSolid()) {
                this.modelMirror.stickXminus.showModel = true;
            } else if (world.getBlockMaterial(i, j, k + 1).isSolid()) {
                this.modelMirror.stickZplus.showModel = true;
            } else if (world.getBlockMaterial(i, j, k - 1).isSolid()) {
                this.modelMirror.stickZminus.showModel = true;
            }
            GL11.glPushMatrix();
            float f = 0.6666667f;
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            float f1 = (float)(tileentity.getBlockMetadata() * 360) / 16.0f;
            this.bindTextureByName(mod_PCmachines.getImgDir() + "mirror.png");
            GL11.glPushMatrix();
            GL11.glRotatef((float)(-f1), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)f, (float)(-f), (float)(-f));
            int color = tileentity.getMirrorColor();
            if (color != -1) {
                double red = PC_Color.red(PC_Color.crystal_colors[color]);
                double green = PC_Color.green(PC_Color.crystal_colors[color]);
                double blue = PC_Color.blue(PC_Color.crystal_colors[color]);
                GL11.glColor4d((double)red, (double)green, (double)blue, (double)0.5);
            }
            this.modelMirror.renderMirrorNoSideSticks();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f, (float)(-f), (float)(-f));
            this.modelMirror.renderMirrorSideSticks();
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        } else {
            this.modelPrism.mainCrystal.showModel = true;
            for (int a = 0; a <= 9; ++a) {
                this.modelPrism.sides[a].showModel = tileentity.getPrismSide(a);
            }
            GL11.glPushMatrix();
            float f = 1.0f;
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            this.bindTextureByName(mod_PCmachines.getImgDir() + "prism.png");
            GL11.glPushMatrix();
            GL11.glScalef((float)f, (float)(-f), (float)(-f));
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)2977);
            GL11.glBlendFunc((int)770, (int)771);
            this.modelPrism.renderPrism();
            GL11.glDisable((int)2977);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void renderTileEntityAt(TileEntity tileEntity, double x, double y, double z, float f) {
        this.renderTileEntityOpticalAt((PCma_TileEntityOptical)tileEntity, x, y, z, f);
    }
}

