/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.PC_Color;
import net.minecraft.src.PC_CoordD;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_EntityLaserParticleFX;
import net.minecraft.src.PC_ISelectiveInventory;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.TileEntity;

public class PCma_TileEntityReplacer
extends TileEntity
implements IInventory,
PC_ISelectiveInventory {
    public ItemStack buildBlock;
    public static final int MAXSTACK = 1;
    public static final int SIZE = 1;
    public PC_CoordI coordOffset = new PC_CoordI(0, 1, 0);
    public boolean aidEnabled = false;
    private PC_Color aidcolor;
    public boolean state = false;
    private Random rand;
    private boolean init = false;

    @Override
    public void updateEntity() {
        if (!this.init) {
            double f;
            this.init = true;
            Random rnd = new Random(145896555 + this.xCoord ^ this.yCoord ^ (this.zCoord ^ 0x84));
            double used = 2.0;
            double r = rnd.nextDouble() * 1.0;
            used -= r;
            double g = rnd.nextDouble() * 1.0;
            double b = used -= g;
            if (rnd.nextBoolean()) {
                f = r;
                r = g;
                g = f;
            }
            if (rnd.nextBoolean()) {
                f = g;
                g = b;
                b = f;
            }
            if (rnd.nextBoolean()) {
                f = b;
                b = r;
                r = f;
            }
            this.aidcolor = new PC_Color(r, g, b);
            this.rand = new Random();
        }
        if (this.aidEnabled) {
            double d = (float)this.xCoord + this.rand.nextFloat();
            double d1 = (double)this.yCoord + 1.1;
            double d2 = (float)this.zCoord + this.rand.nextFloat();
            int a = this.rand.nextInt(3);
            int b = this.rand.nextInt(3);
            ModLoader.getMinecraftInstance().effectRenderer.addEffect(new PC_EntityLaserParticleFX(this.worldObj, new PC_CoordD(d, d1, d2), this.aidcolor, new PC_CoordI(), 0));
            for (int q = 0; q < 8; ++q) {
                d = (float)(this.xCoord + this.coordOffset.x) + this.rand.nextFloat();
                d1 = (float)(this.yCoord + this.coordOffset.y) + this.rand.nextFloat();
                d2 = (float)(this.zCoord + this.coordOffset.z) + this.rand.nextFloat();
                a = this.rand.nextInt(3);
                b = this.rand.nextInt(3);
                while (a == b) {
                    b = this.rand.nextInt(3);
                }
                boolean aa = this.rand.nextBoolean();
                boolean bb = this.rand.nextBoolean();
                switch (a) {
                    case 0: {
                        d = aa ? Math.floor(d) : Math.ceil(d);
                        break;
                    }
                    case 1: {
                        d1 = aa ? Math.floor(d1) : Math.ceil(d1);
                        break;
                    }
                    case 2: {
                        d2 = aa ? Math.floor(d2) : Math.ceil(d2);
                    }
                }
                switch (b) {
                    case 0: {
                        d = bb ? Math.floor(d) : Math.ceil(d);
                        break;
                    }
                    case 1: {
                        d1 = bb ? Math.floor(d1) : Math.ceil(d1);
                        break;
                    }
                    case 2: {
                        d2 = bb ? Math.floor(d2) : Math.ceil(d2);
                    }
                }
                ModLoader.getMinecraftInstance().effectRenderer.addEffect(new PC_EntityLaserParticleFX(this.worldObj, new PC_CoordD(d, d1, d2), this.aidcolor, new PC_CoordI(), 0));
            }
        }
        super.updateEntity();
    }

    @Override
    public boolean canInsertStackTo(int slot, ItemStack stack) {
        return stack.getItem() instanceof ItemBlock;
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.buildBlock;
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (j > 0) {
            ItemStack itemStack = this.buildBlock;
            this.buildBlock = null;
            return itemStack;
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int i) {
        if (this.buildBlock != null) {
            ItemStack itemstack = this.buildBlock;
            this.buildBlock = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.buildBlock = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
        this.onInventoryChanged();
    }

    @Override
    public String getInvName() {
        return "Block Replacer";
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
        if (nbttaglist.tagCount() > 0) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(0);
            this.buildBlock = ItemStack.loadItemStackFromNBT(nbttagcompound1);
        }
        PC_Utils.readWrappedFromNBT(nbttagcompound, "targetPos", this.coordOffset);
        this.state = nbttagcompound.getBoolean("state");
        this.aidEnabled = nbttagcompound.getBoolean("aid");
        if (this.coordOffset.equals(new PC_CoordI(0, 0, 0))) {
            this.coordOffset.setTo(0, 1, 0);
        }
        this.init = false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        if (this.buildBlock != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            this.buildBlock.writeToNBT(nbttagcompound1);
            nbttaglist.appendTag(nbttagcompound1);
        }
        nbttagcompound.setTag("Items", nbttaglist);
        nbttagcompound.setBoolean("state", this.state);
        nbttagcompound.setBoolean("aid", this.aidEnabled);
        PC_Utils.writeWrappedToNBT(nbttagcompound, "targetPos", this.coordOffset);
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return false;
    }

    @Override
    public void openChest() {
    }

    @Override
    public void closeChest() {
    }
}

