/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.BiomeGenHell;
import net.minecraft.src.Block;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.FurnaceRecipes;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemFood;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.PC_ISelectiveInventory;
import net.minecraft.src.PC_InvUtils;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCma_BlockRoaster;
import net.minecraft.src.TileEntity;
import net.minecraft.src.WorldChunkManager;
import net.minecraft.src.mod_PCmachines;

public class PCma_TileEntityRoaster
extends TileEntity
implements IInventory,
PC_ISelectiveInventory {
    private ItemStack[] roasterContents = new ItemStack[9];
    private Random random = new Random();
    public static final int MAXSTACK = 16;
    public static final int SIZE = 9;
    public int burnTime = 0;
    public int netherTime = 0;
    public int netherActionTime = 100;
    private boolean noNetherrack = false;

    @Override
    public boolean canInsertStackTo(int slot, ItemStack stack) {
        return stack != null && (PC_Utils.isFuel(stack) || stack.itemID == Block.netherrack.blockID);
    }

    @Override
    public int getSizeInventory() {
        return 9;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.roasterContents[i];
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.roasterContents[i] != null) {
            if (this.roasterContents[i].stackSize <= j) {
                ItemStack itemstack = this.roasterContents[i];
                this.roasterContents[i] = null;
                this.onInventoryChanged();
                return itemstack;
            }
            ItemStack itemstack1 = this.roasterContents[i].splitStack(j);
            if (this.roasterContents[i].stackSize == 0) {
                this.roasterContents[i] = null;
            }
            this.onInventoryChanged();
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.roasterContents[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
        this.onInventoryChanged();
    }

    @Override
    public String getInvName() {
        return PC_Lang.tr("tile.PCmaRoaster.name") + " - " + PC_Lang.tr("pc.roaster.insertFuel");
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
        this.roasterContents = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i);
            int j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j < 0 || j >= this.roasterContents.length) continue;
            this.roasterContents[j] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
        }
        this.burnTime = nbttagcompound.getInteger("burning");
        this.netherTime = nbttagcompound.getInteger("netherTime");
        this.netherActionTime = nbttagcompound.getInteger("netherActionTime");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.roasterContents.length; ++i) {
            if (this.roasterContents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            this.roasterContents[i].writeToNBT(nbttagcompound1);
            nbttaglist.appendTag(nbttagcompound1);
        }
        nbttagcompound.setTag("Items", nbttaglist);
        nbttagcompound.setInteger("burning", this.burnTime);
        nbttagcompound.setInteger("netherTime", this.netherTime);
        nbttagcompound.setInteger("netherActionTime", this.netherActionTime);
    }

    @Override
    public int getInventoryStackLimit() {
        return 16;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return entityplayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    @Override
    public void openChest() {
    }

    @Override
    public void closeChest() {
        this.noNetherrack = false;
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        boolean laser;
        if (!PCma_BlockRoaster.isIndirectlyPowered(this.worldObj, this.xCoord, this.yCoord, this.zCoord)) {
            return;
        }
        boolean bl = laser = this.worldObj.getBlockId(this.xCoord, this.yCoord + 1, this.zCoord) == mod_PCmachines.laser.blockID;
        if (this.burnTime > 0) {
            this.burnTime -= laser ? 4 : 2;
        }
        if (this.burnTime <= 0) {
            this.addFuelForTime(40);
        }
        if (!laser) {
            this.smeltItems();
        }
        if (!laser && this.burnTime > 0) {
            this.burnCreatures();
        }
        if (this.netherTime > 0) {
            --this.netherTime;
        }
        if (this.netherTime <= 0 && !this.noNetherrack) {
            this.addNetherrack();
        }
        if (this.netherActionTime > 0 && this.netherTime > 0) {
            --this.netherActionTime;
        }
        if (this.netherActionTime <= 0) {
            BiomeGenBase biomegenbase;
            WorldChunkManager worldchunkmanager;
            int success = 0;
            for (int i = 0; i < 10; ++i) {
                if (this.netherAction()) {
                    ++success;
                }
                if (success == 4) break;
            }
            this.netherActionTime = (worldchunkmanager = this.worldObj.getWorldChunkManager()) != null ? ((biomegenbase = worldchunkmanager.getBiomeGenAt(this.xCoord, this.zCoord)) instanceof BiomeGenHell ? 50 + this.random.nextInt(150) : 100 + this.random.nextInt(200)) : 100 + this.random.nextInt(200);
        }
    }

    public void smeltItems() {
        List itemsList = this.worldObj.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBoxFromPool(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 1, this.yCoord + 2, this.zCoord + 1));
        for (EntityItem entityitem : itemsList) {
            ItemStack result2;
            if (entityitem.isDead || mod_PCmachines.roasterIgnoreBlockIDs.contains(entityitem.item.itemID) || (result2 = this.getResult(entityitem.item)) == null || this.burnTime <= this.getItemSmeltTime(entityitem.item) && !this.addFuelForItem(entityitem.item) || this.burnTime < this.getItemSmeltTime(entityitem.item)) continue;
            this.burnTime -= this.getItemSmeltTime(entityitem.item);
            EntityItem eitem = new EntityItem(this.worldObj, entityitem.posX - (double)0.1f + (double)(this.random.nextFloat() * 0.2f), entityitem.posY, entityitem.posZ - (double)0.1f + (double)(this.random.nextFloat() * 0.2f), result2.copy());
            eitem.motionX = entityitem.motionX;
            eitem.motionY = entityitem.motionY;
            eitem.motionZ = entityitem.motionZ;
            this.worldObj.spawnEntityInWorld(eitem);
            if (--entityitem.item.stackSize > 0) continue;
            entityitem.setDead();
        }
    }

    public void burnCreatures() {
        if (this.burnTime <= 0) {
            return;
        }
        List entities = this.worldObj.getEntitiesWithinAABB(EntityLiving.class, AxisAlignedBB.getBoundingBoxFromPool(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 1, this.yCoord + 2, this.zCoord + 1));
        for (EntityLiving eliving : entities) {
            if (eliving.isDead) continue;
            eliving.dealFireDamage(3);
            if (eliving.isWet()) continue;
            eliving.setFire(15);
        }
    }

    public boolean netherAction() {
        int x = -6 + this.random.nextInt(13);
        int z = -6 + this.random.nextInt(13);
        for (int y = -2; y <= 2; ++y) {
            int id = this.worldObj.getBlockId(this.xCoord + x, this.yCoord + y, this.zCoord + z);
            int meta = this.worldObj.getBlockMetadata(this.xCoord + x, this.yCoord + y, this.zCoord + z);
            if (id == Block.netherStalk.blockID && meta < 3) {
                this.worldObj.setBlockMetadataWithNotify(this.xCoord + x, this.yCoord + y, this.zCoord + z, ++meta);
                return true;
            }
            if (id != Block.gravel.blockID) continue;
            this.worldObj.setBlockWithNotify(this.xCoord + x, this.yCoord + y, this.zCoord + z, Block.slowSand.blockID);
            return true;
        }
        return false;
    }

    private boolean addFuelForItem(ItemStack itemstack) {
        for (int s = 0; s < this.getSizeInventory(); ++s) {
            int bt = PC_InvUtils.getFuelValue(this.getStackInSlot(s), 1.0);
            if (bt <= 0) continue;
            this.burnTime += bt;
            this.decrStackSize(s, 1);
            if (this.burnTime < this.getItemSmeltTime(itemstack)) continue;
            return true;
        }
        return this.burnTime >= this.getItemSmeltTime(itemstack);
    }

    private boolean addFuelForTime(int time) {
        for (int s = 0; s < this.getSizeInventory(); ++s) {
            int bt = PC_InvUtils.getFuelValue(this.getStackInSlot(s), 1.0);
            if (bt <= 0) continue;
            this.burnTime += bt;
            this.decrStackSize(s, 1);
            if (this.burnTime < time) continue;
            return true;
        }
        return this.burnTime >= time;
    }

    private void addNetherrack() {
        for (int s = 0; s < this.getSizeInventory(); ++s) {
            if (this.getStackInSlot(s) == null || this.getStackInSlot((int)s).itemID != Block.netherrack.blockID) continue;
            this.netherTime += 600;
            this.decrStackSize(s, 1);
            this.noNetherrack = false;
            return;
        }
        this.noNetherrack = true;
    }

    private ItemStack getResult(ItemStack item) {
        return FurnaceRecipes.smelting().getSmeltingResult(item.getItem().shiftedIndex);
    }

    private int getItemSmeltTime(ItemStack stack) {
        if (stack.getItem() instanceof ItemFood) {
            return 180;
        }
        if (stack.itemID == Block.wood.blockID) {
            return 300;
        }
        return 350;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int par1) {
        if (this.roasterContents[par1] != null) {
            ItemStack itemstack = this.roasterContents[par1];
            this.roasterContents[par1] = null;
            return itemstack;
        }
        return null;
    }
}

