/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityXPOrb;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public class PCma_TileEntityXPBank
extends TileEntity {
    private Random rand = new Random();
    public int xp = 0;

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.xp = nbttagcompound.getInteger("xp");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("xp", this.xp);
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        List hitList = this.worldObj.getEntitiesWithinAABB(EntityXPOrb.class, AxisAlignedBB.getBoundingBoxFromPool(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 1, this.yCoord + 1, this.zCoord + 1).expand(0.5, 0.5, 0.5));
        if (hitList.size() > 0) {
            for (EntityXPOrb orb : hitList) {
                if (orb.isDead) continue;
                int oldxp = this.xp;
                this.worldObj.playSoundAtEntity(orb, "random.orb", 0.1f, 0.5f * ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.8f));
                this.xp += orb.getXpValue();
                orb.setDead();
                if (oldxp == 0 && this.xp > 0) {
                    this.notifyChange();
                    continue;
                }
                this.notifyResize();
            }
        }
    }

    public void printXP(EntityPlayer player) {
        if (this.xp == 0) {
            ModLoader.getMinecraftInstance().ingameGUI.clearChatMessages();
            ModLoader.getMinecraftInstance().thePlayer.addChatMessage("This storage is empty.");
            return;
        }
        ModLoader.getMinecraftInstance().ingameGUI.clearChatMessages();
        ModLoader.getMinecraftInstance().thePlayer.addChatMessage("This storage contains " + this.xp + " experience point" + (this.xp > 1 ? "s." : "."));
    }

    public void withdrawXP(EntityPlayer player) {
        if (this.xp == 0) {
            ModLoader.getMinecraftInstance().ingameGUI.clearChatMessages();
            ModLoader.getMinecraftInstance().thePlayer.addChatMessage("This storage is empty.");
            return;
        }
        this.worldObj.playSoundAtEntity(player, "random.orb", 0.3f, 0.5f * ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.8f));
        int xpsum = 0;
        for (int i = 0; i < 5 && this.xp > 0; ++i) {
            int addedXP = Math.min(this.xp, player.xpBarCap());
            player.addExperience(addedXP);
            this.xp -= addedXP;
            xpsum += addedXP;
        }
        if (this.xp < 0) {
            this.xp = 0;
        }
        this.notifyChange();
        ModLoader.getMinecraftInstance().ingameGUI.clearChatMessages();
        ModLoader.getMinecraftInstance().thePlayer.addChatMessage("Gained " + xpsum + " experience point" + (xpsum > 1 ? "s." : "."));
    }

    public void depositXP(EntityPlayer player) {
        if (player.experienceLevel <= 0 && player.experience <= 0.0f) {
            ModLoader.getMinecraftInstance().ingameGUI.clearChatMessages();
            ModLoader.getMinecraftInstance().thePlayer.addChatMessage("You have no experience to deposit.");
            return;
        }
        this.worldObj.playSoundAtEntity(player, "random.orb", 0.3f, 0.5f * ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.4f));
        int totalDeposit = 0;
        int remainder = (int)(player.experience * (float)this.getLevelSize(player.experienceLevel));
        player.experience = 0.0f;
        totalDeposit += remainder;
        for (int j = 5; player.experienceLevel > 0 && j >= 0; --j) {
            int level = --player.experienceLevel;
            int size = this.getLevelSize(level);
            totalDeposit += size;
        }
        this.xp += totalDeposit;
        player.experienceTotal -= totalDeposit;
        player.score -= totalDeposit;
        this.notifyChange();
        ModLoader.getMinecraftInstance().ingameGUI.clearChatMessages();
        ModLoader.getMinecraftInstance().thePlayer.addChatMessage("Deposited " + totalDeposit + " experience point" + (totalDeposit > 1 ? "s." : "."));
    }

    private void notifyChange() {
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType().blockID);
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType().blockID);
        this.notifyResize();
    }

    private void notifyResize() {
        this.worldObj.markBlocksDirty(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
        this.worldObj.markBlockNeedsUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    private int getLevelSize(int level) {
        return 7 + (level * 7 >> 1);
    }
}

