/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.BlockSand;
import net.minecraft.src.BlockTorch;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityFX;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityXPOrb;
import net.minecraft.src.GuiChest;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.PC_BlockUtils;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_CropHarvestingManager;
import net.minecraft.src.PC_FakePlayer;
import net.minecraft.src.PC_ICropBlock;
import net.minecraft.src.PC_InvUtils;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCmo_Command;
import net.minecraft.src.PCmo_CommandException;
import net.minecraft.src.PCmo_GuiMinerConsole;
import net.minecraft.src.PCmo_MinerControlHandler;
import net.minecraft.src.World;
import net.minecraft.src.mod_PCcore;

public class PCmo_EntityMiner
extends Entity
implements IInventory {
    private static final double FUEL_STRENGTH = 0.9;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private Random rand = new Random();
    private EntityPlayer fakePlayer;
    public String commandList = "";
    public int currentCommand = -1;
    private int realCommand = -1;
    private int stepCounter = 0;
    public String commandListSaved = "";
    public boolean paused = false;
    public boolean keyboardControlled = false;
    public boolean programmingGuiOpen = false;
    private boolean upStepLaid = false;
    private boolean bridgeDone = false;
    private PC_CoordI target = new PC_CoordI();
    private int rotationRemaining = 0;
    public int level = 1;
    private static final double[] MOTION_SPEED = new double[]{0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.11, 0.12};
    public boolean minerBeingCreated = false;
    public String program = "";
    public byte DESTROY = 0;
    public static final byte COBBLE = 1;
    public static final byte DIRT = 2;
    public static final byte GRAVEL = 4;
    public boolean keepAllFuel = false;
    public boolean torchesOnlyOnFloor = false;
    public boolean compressBlocks = false;
    public boolean miningEnabled = true;
    public boolean bridgeEnabled = false;
    public boolean lavaFillingEnabled = true;
    public boolean waterFillingEnabled = false;
    private int fuelBuffer = 0;
    private int fuelAllocated = 0;
    private int waitingForFuel = 0;
    private int[] mineCounter = new int[]{-1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0};
    private int miningTickCounter = 0;
    boolean openedGui = false;
    private ItemStack[] inventory = new ItemStack[54];

    public boolean tryToSpawnMinerAt(ItemStack itemstack, EntityPlayer entityplayer, World world, PC_CoordI position) {
        int steel = Block.blockSteel.blockID;
        int chest = Block.chest.blockID;
        String eMinerStructure = PC_Lang.tr("pc.miner.build.errInvalidStructure");
        String eMinerCrystals = PC_Lang.tr("pc.miner.build.errMissingCrystals");
        block0: for (int yy = position.y; yy >= position.y - 1; --yy) {
            for (int xx = position.x - 1; xx <= position.x + 1; ++xx) {
                for (int zz = position.z - 1; zz <= position.z + 1; ++zz) {
                    PC_CoordI pos = new PC_CoordI(xx, yy, zz);
                    if (pos.getId(world) != steel || pos.offset(1, 0, 0).getId(world) != steel || pos.offset(0, 0, 1).getId(world) != steel || pos.offset(1, 0, 1).getId(world) != steel) continue;
                    if (pos.offset(0, 1, 0).getId(world) == steel && pos.offset(1, 1, 0).getId(world) == chest && pos.offset(0, 1, 1).getId(world) == steel && pos.offset(1, 1, 1).getId(world) == chest) {
                        if (this.spawnMinerAt(world, pos, 0)) {
                            itemstack.damageItem(1, entityplayer);
                        } else {
                            PC_Utils.chatMsg(eMinerCrystals, false);
                        }
                        return true;
                    }
                    if (pos.offset(0, 1, 0).getId(world) == chest && pos.offset(1, 1, 0).getId(world) == chest && pos.offset(0, 1, 1).getId(world) == steel && pos.offset(1, 1, 1).getId(world) == steel) {
                        if (this.spawnMinerAt(world, pos, 3)) {
                            itemstack.damageItem(1, entityplayer);
                        } else {
                            PC_Utils.chatMsg(eMinerCrystals, false);
                        }
                        return true;
                    }
                    if (pos.offset(0, 1, 0).getId(world) == chest && pos.offset(1, 1, 0).getId(world) == steel && pos.offset(0, 1, 1).getId(world) == chest && pos.offset(1, 1, 1).getId(world) == steel) {
                        if (this.spawnMinerAt(world, pos, 2)) {
                            itemstack.damageItem(1, entityplayer);
                        } else {
                            PC_Utils.chatMsg(eMinerCrystals, false);
                        }
                        return true;
                    }
                    if (pos.offset(0, 1, 0).getId(world) == steel && pos.offset(1, 1, 0).getId(world) == steel && pos.offset(0, 1, 1).getId(world) == chest && pos.offset(1, 1, 1).getId(world) == chest) {
                        if (this.spawnMinerAt(world, pos, 1)) {
                            itemstack.damageItem(1, entityplayer);
                        } else {
                            PC_Utils.chatMsg(eMinerCrystals, false);
                        }
                        return true;
                    }
                    PC_Utils.chatMsg(eMinerStructure, false);
                    break block0;
                }
            }
        }
        return false;
    }

    private void removeSpawnStructure(World world, PC_CoordI pos) {
        for (int x = 0; x <= 1; ++x) {
            for (int z = 0; z <= 1; ++z) {
                for (int y = 0; y <= 1; ++y) {
                    pos.offset(x, y, z).setBlock(world, 0, 0);
                }
            }
        }
    }

    private boolean spawnMinerAt(World world, PC_CoordI pos, int rot) {
        this.minerBeingCreated = true;
        IInventory inv = null;
        block0: for (int x = pos.x - 1; x <= pos.x + 1; ++x) {
            for (int z = pos.z - 1; z <= pos.z + 1; ++z) {
                inv = PC_InvUtils.getCompositeInventoryAt(world, x, pos.y + 1, z);
                if (inv != null) break block0;
            }
        }
        if (inv == null) {
            return false;
        }
        int cnt = PC_InvUtils.countPowerCrystals(inv);
        if (cnt == 0) {
            return false;
        }
        PC_InvUtils.moveStacks(inv, this);
        this.removeSpawnStructure(world, pos);
        this.minerBeingCreated = false;
        this.closeChest();
        this.setLocationAndAngles((double)pos.x + 1.0, pos.y, (double)pos.z + 1.0, (float)rot * 90.0f, 0.0f);
        this.target = new PC_CoordI(pos.x + 1, pos.y, pos.z + 1);
        world.spawnEntityInWorld(this);
        return true;
    }

    private void updateLevel() {
        if (!this.minerBeingCreated) {
            int cnt = PC_InvUtils.countPowerCrystals(this);
            if (cnt == 0) {
                this.turnIntoBlocks();
                return;
            }
            this.level = Math.min(cnt, 8);
            this.bridgeEnabled &= this.level >= 3;
            this.waterFillingEnabled &= this.level >= 6;
            this.lavaFillingEnabled &= this.level >= 4;
        }
    }

    private void turnIntoBlocks() {
        this.minerBeingCreated = true;
        int xh = (int)Math.round(this.posX);
        int y = (int)Math.floor(this.posY + (double)1.0E-4f);
        int zh = (int)Math.round(this.posZ);
        int yaw = this.rotationYaw < 45.0f || this.rotationYaw > 315.0f ? 0 : (this.rotationYaw < 135.0f ? 1 : (this.rotationYaw < 215.0f ? 2 : (this.rotationYaw < 315.0f ? 3 : 0)));
        int xl = xh - 1;
        int zl = zh - 1;
        for (int x = xl; x <= xh; ++x) {
            for (int z = zl; z <= zh; ++z) {
                this.worldObj.setBlockWithNotify(x, y, z, Block.blockSteel.blockID);
                if (yaw == 0 && x == xh || yaw == 1 && z == zh || yaw == 2 && x == xl || yaw == 3 && z == zl) {
                    this.worldObj.setBlockWithNotify(x, y + 1, z, Block.chest.blockID);
                    continue;
                }
                this.worldObj.setBlockWithNotify(x, y + 1, z, Block.blockSteel.blockID);
            }
        }
        IInventory inv = null;
        block2: for (int x = xl; x <= xh; ++x) {
            for (int k = zl; k <= zh; ++k) {
                inv = PC_InvUtils.getCompositeInventoryAt(this.worldObj, x, y + 1, k);
                if (inv != null) break block2;
            }
        }
        if (inv != null) {
            PC_InvUtils.moveStacks(this, inv);
        } else {
            PC_Logger.warning("Despawning miner - the chest blocks weren't found.");
        }
        this.setDead();
        if (this.openedGui) {
            ModLoader.getMinecraftInstance().thePlayer.closeScreen();
            ModLoader.openGUI(ModLoader.getMinecraftInstance().thePlayer, new GuiChest(ModLoader.getMinecraftInstance().thePlayer.inventory, inv));
        }
    }

    public PCmo_EntityMiner(World world) {
        super(world);
        this.preventEntitySpawning = true;
        this.setSize(1.3f, 1.4f);
        this.yOffset = 0.0f;
        this.fakePlayer = new PC_FakePlayer(world);
        this.entityCollisionReduction = 1.0f;
        this.stepHeight = 0.6f;
        this.isImmuneToFire = true;
    }

    public PCmo_EntityMiner(World world, double dx, double dy, double dz) {
        this(world);
        this.setPosition(dx, dy + (double)this.yOffset, dz);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = dx;
        this.prevPosY = dy;
        this.prevPosZ = dz;
        this.target.x = (int)dx;
        this.target.y = (int)dy;
        this.target.z = (int)dz;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
        this.dataWatcher.addObject(17, new Integer(0));
        this.dataWatcher.addObject(18, new Integer(1));
        this.dataWatcher.addObject(19, new Integer(0));
    }

    @Override
    public AxisAlignedBB getCollisionBox(Entity entity) {
        return entity.boundingBox;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public boolean canBePushed() {
        return true;
    }

    @Override
    public double getMountedYOffset() {
        return 1.0;
    }

    @Override
    public boolean handleWaterMovement() {
        return this.worldObj.isMaterialInBB(this.boundingBox.expand(-0.1f, -0.4f, -0.1f), Material.water);
    }

    @Override
    public boolean attackEntityFrom(DamageSource damagesource, int i) {
        if (damagesource != DamageSource.outOfWorld && (this.worldObj.isRemote || this.isDead || damagesource.getSourceOfDamage() == null && damagesource != DamageSource.explosion)) {
            return true;
        }
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() + i * 7);
        this.setBeenAttacked();
        if (this.getDamageTaken() > 40) {
            if (this.riddenByEntity != null) {
                this.riddenByEntity.mountEntity(this);
            }
            this.turnIntoBlocks();
        }
        return true;
    }

    @Override
    public void performHurtAnimation() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11);
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public void setPositionAndRotation2(double d, double d1, double d2, float f, float f1, int i) {
        this.motionX = this.velocityX;
        this.motionY = this.velocityY;
        this.motionZ = this.velocityZ;
    }

    @Override
    public void setVelocity(double d, double d1, double d2) {
        this.motionX = d;
        this.motionY = d1;
        this.motionZ = d2;
    }

    @Override
    public float getShadowSize() {
        return 1.0f;
    }

    private boolean shouldDestroyStack(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (stack.itemID == Block.cobblestone.blockID) {
            return (this.DESTROY & 1) != 0;
        }
        if (stack.itemID == Block.dirt.blockID) {
            return (this.DESTROY & 2) != 0;
        }
        if (stack.itemID == Block.gravel.blockID) {
            return (this.DESTROY & 4) != 0;
        }
        return false;
    }

    public void setDestroyFlags(byte flags) {
        this.DESTROY = flags;
    }

    public byte getDestroyFlags() {
        return this.DESTROY;
    }

    public void resetEverything() {
        this.motionZ = 0.0;
        this.motionX = 0.0;
        this.commandList = "";
        this.commandListSaved = "";
        this.currentCommand = -1;
        this.alignToBlocks();
        this.paused = false;
        this.resetStatus();
    }

    public void pauseProgram() {
        if (this.paused) {
            return;
        }
        this.commandListSaved = new String(this.commandList);
        String instruction = Character.toString(PCmo_Command.getCharFromInt(this.currentCommand).charValue());
        if (this.stepCounter > 0 && PCmo_Command.isCommandMove(this.currentCommand)) {
            instruction = (this.currentCommand == 0 ? "" : "-") + Integer.toString(this.stepCounter);
        } else if (instruction.equals("?")) {
            instruction = "";
        }
        this.commandListSaved = instruction + " " + this.commandListSaved;
        this.commandList = "";
        this.resetStatus();
        this.paused = true;
    }

    public void resumeProgram() {
        if (!this.paused) {
            return;
        }
        this.resetStatus();
        this.commandList = new String(this.commandListSaved.trim());
        this.commandListSaved = "";
        this.paused = false;
    }

    public void runNewProgram() throws PCmo_CommandException {
        String parsed = PCmo_Command.parseCode(this.program);
        this.keyboardControlled = false;
        this.paused = false;
        PCmo_MinerControlHandler.disconnectMinerFromKeyboardControl(this, true);
        this.alignToBlocks();
        this.resetStatus();
        this.commandList = parsed;
        this.commandListSaved = "";
    }

    private void resetStatus() {
        this.currentCommand = -1;
        this.roundRotation();
        this.target.x = (int)this.posX;
        this.target.z = (int)this.posZ;
        this.resetMineCounter();
        this.stepCounter = 0;
        this.waitingForFuel = 0;
        this.fuelAllocated = 0;
        this.bridgeDone = false;
        this.upStepLaid = false;
    }

    public void setKeyboardControl(boolean yes) {
        this.keyboardControlled = yes;
        if (yes) {
            this.pauseProgram();
            PCmo_MinerControlHandler.setMinerForKeyboardControl(this, false);
        } else {
            PCmo_MinerControlHandler.disconnectMinerFromKeyboardControl(this, false);
            this.resumeProgram();
        }
    }

    public boolean canReceiveKeyboardCommand() {
        if (this.openedGui) {
            return false;
        }
        this.commandList = this.commandList.trim();
        return true;
    }

    public void receiveKeyboardCommand(int i) {
        if (i == -3) {
            this.resetEverything();
            this.setKeyboardControl(false);
            try {
                this.runNewProgram();
            }
            catch (PCmo_CommandException e) {
                // empty catch block
            }
        }
        if (i == -2) {
            this.resetEverything();
        } else {
            Character chr = PCmo_Command.getCharFromInt(i);
            if (chr.equals(Character.valueOf('?'))) {
                return;
            }
            this.commandList = this.commandList + chr.toString();
        }
    }

    public void appendCode(String code) throws PCmo_CommandException {
        this.commandList = this.commandList + " " + PCmo_Command.parseCode(code);
    }

    public void setCode(String code) throws PCmo_CommandException {
        this.commandList = PCmo_Command.parseCode(code);
    }

    private int getNextCommand() {
        if (this.commandList.length() > 0) {
            Character first = Character.valueOf(this.commandList.charAt(0));
            int cmd = PCmo_Command.getIntFromChar(first);
            if (cmd != -1) {
                this.commandList = this.commandList.substring(1);
                if (cmd == 0 || cmd == 3 || cmd == 9) {
                    this.stepCounter = 1;
                }
                return cmd;
            }
            if (Character.isDigit(first.charValue()) || first.equals(Character.valueOf('-'))) {
                String numbuff = Character.toString(first.charValue());
                this.commandList = this.commandList.substring(1);
                while (this.commandList.length() > 0 && Character.isDigit((first = Character.valueOf(this.commandList.charAt(0))).charValue())) {
                    numbuff = numbuff + first.toString();
                    this.commandList = this.commandList.substring(1);
                }
                try {
                    this.stepCounter = Integer.valueOf(numbuff);
                    cmd = this.stepCounter > 0 ? 0 : 3;
                    this.stepCounter = Math.abs(this.stepCounter);
                    if (this.stepCounter == 0) {
                        return -1;
                    }
                    return cmd;
                }
                catch (NumberFormatException nfe) {
                    return -1;
                }
            }
            this.commandList = this.commandList.substring(1);
            return this.getNextCommand();
        }
        return -1;
    }

    private boolean isMinerAtTargetPos() {
        if (this.currentCommand == 0 || this.currentCommand == 9) {
            if (this.rotationYaw == 0.0f) {
                return this.posX <= (double)this.target.x;
            }
            if (this.rotationYaw == 90.0f) {
                return this.posZ <= (double)this.target.z;
            }
            if (this.rotationYaw == 180.0f) {
                return this.posX >= (double)this.target.x;
            }
            if (this.rotationYaw == 270.0f) {
                return this.posZ >= (double)this.target.z;
            }
        } else if (this.currentCommand == 3) {
            if (this.rotationYaw == 0.0f) {
                return this.posX >= (double)this.target.x;
            }
            if (this.rotationYaw == 90.0f) {
                return this.posZ >= (double)this.target.z;
            }
            if (this.rotationYaw == 180.0f) {
                return this.posX <= (double)this.target.x;
            }
            if (this.rotationYaw == 270.0f) {
                return this.posZ <= (double)this.target.z;
            }
        }
        return true;
    }

    private double getTargetDistanceX() {
        return Math.abs(this.posX - (double)this.target.x);
    }

    private double getTargetDistanceZ() {
        return Math.abs(this.posZ - (double)this.target.z);
    }

    private void roundRotation() {
        if (this.rotationYaw < 0.0f) {
            this.rotationYaw = this.prevRotationYaw = 360.0f - this.rotationYaw;
        }
        if (this.rotationYaw > 360.0f) {
            this.rotationYaw = this.prevRotationYaw = this.rotationYaw - 360.0f;
        }
        if (this.rotationYaw >= 315.0f || this.rotationYaw < 45.0f) {
            this.rotationYaw = 0.0f;
            this.prevRotationYaw = 0.0f;
        }
        if (this.rotationYaw >= 45.0f && this.rotationYaw < 135.0f) {
            this.rotationYaw = 90.0f;
            this.prevRotationYaw = 90.0f;
        }
        if (this.rotationYaw >= 135.0f && this.rotationYaw < 215.0f) {
            this.rotationYaw = 180.0f;
            this.prevRotationYaw = 180.0f;
        }
        if (this.rotationYaw >= 215.0f && this.rotationYaw < 315.0f) {
            this.rotationYaw = 270.0f;
            this.prevRotationYaw = 270.0f;
        }
        this.rotationRemaining = 0;
    }

    private void alignToBlocks() {
        this.setPosition(Math.round(this.posX), this.posY, Math.round(this.posZ));
    }

    private void prepareForCommandExecution() {
        if (this.currentCommand > -1) {
            this.realCommand = this.currentCommand;
            this.prevPosX = this.posX = (double)((int)Math.round(this.posX));
            this.prevPosX = this.posZ = (double)((int)Math.round(this.posZ));
            int x = (int)Math.round(this.posX);
            int z = (int)Math.round(this.posZ);
            int y = (int)Math.floor(this.posY + (double)1.0E-4f);
            this.roundRotation();
            if (this.currentCommand == 10) {
                this.depositToNearbyChest();
                this.currentCommand = -1;
            } else {
                if (this.currentCommand == 11) {
                    this.turnIntoBlocks();
                    return;
                }
                if (this.currentCommand == 14) {
                    this.bridgeEnabled = true;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 15) {
                    this.bridgeEnabled = false;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 12) {
                    this.miningEnabled = true;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 13) {
                    this.miningEnabled = false;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 16) {
                    this.lavaFillingEnabled = true;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 17) {
                    this.lavaFillingEnabled = false;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 18) {
                    this.waterFillingEnabled = true;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 19) {
                    this.waterFillingEnabled = false;
                    this.currentCommand = -1;
                } else if (this.currentCommand == 8) {
                    if (!this.miningEnabled) {
                        this.currentCommand = -1;
                    } else {
                        this.resetMineCounter();
                        this.mineCounter[4] = -1;
                        this.mineCounter[5] = -1;
                    }
                } else if (this.currentCommand == 9) {
                    if (!this.miningEnabled) {
                        this.currentCommand = -1;
                    } else if (this.addFuelForCost(this.getStepCost())) {
                        this.resetMineCounter();
                        if (this.rotationYaw == 0.0f) {
                            this.target = new PC_CoordI(x - 1, y, z);
                        }
                        if (this.rotationYaw == 90.0f) {
                            this.target = new PC_CoordI(x, y, z - 1);
                        }
                        if (this.rotationYaw == 180.0f) {
                            this.target = new PC_CoordI(x + 1, y, z);
                        }
                        if (this.rotationYaw == 270.0f) {
                            this.target = new PC_CoordI(x, y, z + 1);
                        }
                        if (!this.isOnHalfStep()) {
                            this.mineCounter[6] = -1;
                            this.mineCounter[7] = -1;
                            this.mineCounter[8] = -1;
                            this.mineCounter[9] = -1;
                            this.mineCounter[10] = -1;
                            this.mineCounter[11] = -1;
                            this.upStepLaid = false;
                        } else {
                            this.currentCommand = 0;
                            switch ((int)Math.floor(this.rotationYaw)) {
                                case 0: {
                                    this.layHalfStep(x - 2, y, z - 1, false);
                                    this.layHalfStep(x - 2, y, z, false);
                                    break;
                                }
                                case 90: {
                                    this.layHalfStep(x - 1, y, z - 2, false);
                                    this.layHalfStep(x, y, z - 2, false);
                                    break;
                                }
                                case 180: {
                                    this.layHalfStep(x + 1, y, z - 1, false);
                                    this.layHalfStep(x + 1, y, z, false);
                                    break;
                                }
                                case 270: {
                                    this.layHalfStep(x - 1, y, z + 1, false);
                                    this.layHalfStep(x, y, z + 1, false);
                                }
                            }
                        }
                    }
                } else if (this.currentCommand == 0) {
                    if (this.addFuelForCost(this.getStepCost())) {
                        this.resetMineCounter();
                        this.bridgeDone = false;
                        if (this.rotationYaw == 0.0f) {
                            this.target.x = x - 1;
                            this.target.z = z;
                        }
                        if (this.rotationYaw == 90.0f) {
                            this.target.z = z - 1;
                            this.target.x = x;
                        }
                        if (this.rotationYaw == 180.0f) {
                            this.target.x = x + 1;
                            this.target.z = z;
                        }
                        if (this.rotationYaw == 270.0f) {
                            this.target.z = z + 1;
                            this.target.x = x;
                        }
                    }
                } else if (this.currentCommand == 3) {
                    if (this.addFuelForCost(this.getStepCost())) {
                        this.bridgeDone = false;
                        if (this.rotationYaw == 0.0f) {
                            this.target.x = x + 1;
                            this.target.z = z;
                        }
                        if (this.rotationYaw == 90.0f) {
                            this.target.z = z + 1;
                            this.target.x = x;
                        }
                        if (this.rotationYaw == 180.0f) {
                            this.target.x = x - 1;
                            this.target.z = z;
                        }
                        if (this.rotationYaw == 270.0f) {
                            this.target.z = z - 1;
                            this.target.x = x;
                        }
                    }
                } else if (this.currentCommand == 1) {
                    this.rotationRemaining = -90;
                } else if (this.currentCommand == 2) {
                    this.rotationRemaining = 90;
                } else if (this.currentCommand == 5) {
                    if (this.rotationYaw == 0.0f) {
                        this.currentCommand = 2;
                        this.rotationRemaining = 90;
                    }
                    if (this.rotationYaw == 180.0f) {
                        this.currentCommand = 1;
                        this.rotationRemaining = -90;
                    }
                    if (this.rotationYaw == 90.0f) {
                        this.currentCommand = -1;
                    }
                    if (this.rotationYaw == 270.0f) {
                        this.currentCommand = 1;
                        this.rotationRemaining = this.rand.nextBoolean() ? 180 : -180;
                    }
                } else if (this.currentCommand == 4) {
                    if (this.rotationYaw == 0.0f) {
                        this.currentCommand = 1;
                        this.rotationRemaining = -90;
                    }
                    if (this.rotationYaw == 180.0f) {
                        this.currentCommand = 2;
                        this.rotationRemaining = 90;
                    }
                    if (this.rotationYaw == 90.0f) {
                        this.currentCommand = 1;
                        int n = this.rotationRemaining = this.rand.nextBoolean() ? 180 : -180;
                    }
                    if (this.rotationYaw == 270.0f) {
                        this.currentCommand = -1;
                    }
                } else if (this.currentCommand == 6) {
                    if (this.rotationYaw == 0.0f) {
                        this.currentCommand = 1;
                        int n = this.rotationRemaining = this.rand.nextBoolean() ? 180 : -180;
                    }
                    if (this.rotationYaw == 180.0f) {
                        this.currentCommand = -1;
                    }
                    if (this.rotationYaw == 90.0f) {
                        this.currentCommand = 2;
                        this.rotationRemaining = 90;
                    }
                    if (this.rotationYaw == 270.0f) {
                        this.currentCommand = 1;
                        this.rotationRemaining = -90;
                    }
                } else if (this.currentCommand == 7) {
                    if (this.rotationYaw == 0.0f) {
                        this.currentCommand = -1;
                    }
                    if (this.rotationYaw == 180.0f) {
                        this.currentCommand = 1;
                        int n = this.rotationRemaining = this.rand.nextBoolean() ? 180 : -180;
                    }
                    if (this.rotationYaw == 90.0f) {
                        this.currentCommand = 1;
                        this.rotationRemaining = -90;
                    }
                    if (this.rotationYaw == 270.0f) {
                        this.currentCommand = 2;
                        this.rotationRemaining = 90;
                    }
                } else {
                    this.currentCommand = -1;
                }
            }
        }
    }

    private int getStepCost() {
        return MathHelper.clamp_int(this.level / 2, 1, 4);
    }

    private boolean shouldMakeEffects() {
        return this.worldObj.getClosestPlayerToEntity(this, 17.0) != null && mod_PCcore.soundsEnabled;
    }

    private void playMotionEffect() {
        if (!this.shouldMakeEffects()) {
            return;
        }
        this.worldObj.playSoundAtEntity(this, "random.click", 0.02f, 0.8f);
    }

    private void playMiningEffect(PC_CoordI pos, int block_index) {
        ++this.miningTickCounter;
        if (!this.shouldMakeEffects()) {
            return;
        }
        int id = pos.getId(this.worldObj);
        Block block = Block.blocksList[id];
        if (this.miningTickCounter % 8 == 0 && block != null) {
            ModLoader.getMinecraftInstance().sndManager.playSound(block.stepSound.getBreakSound(), (float)pos.x + 0.5f, (float)pos.y + 0.5f, (float)pos.z + 0.5f, (block.stepSound.getVolume() + 1.0f) / 8.0f, block.stepSound.getPitch() * 0.5f);
        }
        if (block != null) {
            ModLoader.getMinecraftInstance().effectRenderer.addBlockHitEffects(pos.x, pos.y, pos.z, block_index < 4 ? this.getSideFromYaw() : (block_index < 6 ? 1 : 0));
        }
    }

    private int getSideFromYaw() {
        if (this.rotationYaw == 0.0f) {
            return 5;
        }
        if (this.rotationYaw == 90.0f) {
            return 3;
        }
        if (this.rotationYaw == 180.0f) {
            return 4;
        }
        if (this.rotationYaw == 270.0f) {
            return 2;
        }
        return 1;
    }

    private void harvestBlock_do(PC_CoordI pos) {
        int id = pos.getId(this.worldObj);
        int meta = pos.getMeta(this.worldObj);
        if (!this.shouldIgnoreBlockForHarvesting(pos, id)) {
            if (Block.blocksList[id] instanceof PC_ICropBlock) {
                if (!((PC_ICropBlock)((Object)Block.blocksList[id])).isMature(this.worldObj, pos)) {
                    return;
                }
                if (this.shouldMakeEffects()) {
                    this.worldObj.playAuxSFX(2001, pos.x, pos.y, pos.z, id + (meta << 12));
                }
                for (ItemStack stack : ((PC_ICropBlock)((Object)Block.blocksList[id])).machineHarvest(this.worldObj, pos)) {
                    Block.blocksList[id].dropBlockAsItem_do(this.worldObj, pos.x, pos.y, pos.z, stack);
                }
            } else if (PC_CropHarvestingManager.isBlockRegisteredCrop(id)) {
                if (PC_CropHarvestingManager.canHarvestBlock(id, meta)) {
                    ItemStack[] harvested;
                    for (ItemStack stack : harvested = PC_CropHarvestingManager.getHarvestedStacks(id, meta)) {
                        if (this.shouldMakeEffects()) {
                            this.worldObj.playAuxSFX(2001, pos.x, pos.y, pos.z, id + (meta << 12));
                        }
                        Block.blocksList[id].dropBlockAsItem_do(this.worldObj, pos.x, pos.y, pos.z, stack);
                    }
                    int newMeta = PC_CropHarvestingManager.getReplantMeta(id);
                    if (newMeta == -1) {
                        this.worldObj.setBlockWithNotify(pos.x, pos.y, pos.z, 0);
                    } else {
                        this.worldObj.setBlockMetadataWithNotify(pos.x, pos.y, pos.z, newMeta);
                    }
                    return;
                }
            } else {
                Block.blocksList[id].harvestBlock(this.worldObj, this.fakePlayer, pos.x, pos.y, pos.z, meta);
                pos.setBlock(this.worldObj, 0, 0);
                if (this.shouldMakeEffects()) {
                    this.worldObj.playAuxSFX(2001, pos.x, pos.y, pos.z, id + (meta << 12));
                }
            }
        }
    }

    private void performMiningUpdate(PC_CoordI pos, int loc) {
        int id = pos.getId(this.worldObj);
        if (loc == 4 || loc == 5) {
            this.bridgeBuilding_do(pos.offset(0, -1, 0));
        }
        if (this.mineCounter[loc] <= 0) {
            if (this.shouldIgnoreBlockForHarvesting(pos, id)) {
                if (this.mineCounter[loc] < 0) {
                    this.mineCounter[loc] = 0;
                }
                return;
            }
            if (Block.blocksList[id] != null) {
                int cost = this.getBlockMiningCost(pos, id);
                if (id == 7 && this.level == 8 && pos.y == 0) {
                    cost = -1;
                }
                if (cost > 0 && this.addFuelForCost(cost)) {
                    this.mineCounter[loc] = cost;
                }
            }
        }
        if (this.waitingForFuel == 0 && this.mineCounter[loc] > 0) {
            int step = this.level;
            if (this.mineCounter[loc] < step) {
                step = this.mineCounter[loc];
                this.mineCounter[loc] = 0;
            } else {
                int n = loc;
                this.mineCounter[n] = this.mineCounter[n] - step;
            }
            this.consumeAllocatedFuel(step);
            if (this.mineCounter[loc] == 0) {
                this.harvestBlock_do(pos);
            }
        }
        if (this.mineCounter[loc] != 0 && Block.blocksList[id] != null) {
            this.playMiningEffect(pos, loc);
        }
    }

    private boolean isMiningInProgress() {
        for (int counter : this.mineCounter) {
            if (counter == 0) continue;
            return true;
        }
        return false;
    }

    private boolean isMiningDone() {
        return !this.isMiningInProgress();
    }

    private void resetMineCounter() {
        int i;
        for (int element : this.mineCounter) {
            this.fuelAllocated -= element;
            if (this.fuelAllocated > 0) continue;
            this.fuelAllocated = 0;
            break;
        }
        for (i = 0; i < 4; ++i) {
            this.mineCounter[i] = -1;
        }
        for (i = 4; i < this.mineCounter.length; ++i) {
            this.mineCounter[i] = 0;
        }
    }

    private boolean shouldIgnoreBlockForHarvesting(PC_CoordI pos, int id) {
        if (id == 0 || Block.blocksList[id] == null || Block.blocksList[id] instanceof BlockTorch || id == Block.fire.blockID || id == Block.portal.blockID || id == Block.endPortal.blockID || Block.blocksList[id] instanceof BlockFluid || id == 55 || id == 70 || id == 72 || PC_BlockUtils.hasFlag(this.worldObj, pos, "LIFT") || PC_BlockUtils.hasFlag(this.worldObj, pos, "BELT")) {
            return true;
        }
        boolean flag = false;
        if (Block.blocksList[id] instanceof PC_ICropBlock) {
            boolean bl = flag = !((PC_ICropBlock)((Object)Block.blocksList[id])).isMature(this.worldObj, pos);
        }
        if (PC_CropHarvestingManager.isBlockRegisteredCrop(id)) {
            boolean bl = flag = !PC_CropHarvestingManager.canHarvestBlock(id, pos.getMeta(this.worldObj));
        }
        return flag && Block.blocksList[id].getCollisionBoundingBoxFromPool(this.worldObj, pos.x, pos.y, pos.z) == null;
    }

    private boolean isBlockUnbreakable(int id) {
        return id == 7;
    }

    private boolean canHarvestBlockWithCurrentLevel(PC_CoordI pos, int id) {
        if (id == 7 && this.level == 8) {
            return true;
        }
        if (this.isBlockUnbreakable(id) || PC_BlockUtils.hasFlag(this.worldObj, pos, "HARVEST_STOP")) {
            return false;
        }
        switch (this.level) {
            case 1: {
                return Block.blocksList[id].blockMaterial != Material.rock && Block.blocksList[id].blockMaterial != Material.iron && id != mod_PCcore.powerCrystal.blockID;
            }
            case 2: {
                return id != 49 && id != 14 && id != 21 && id != 22 && id != 41 && id != 56 && id != 57 && id != 73 && id != 74 && id != mod_PCcore.powerCrystal.blockID;
            }
            case 3: {
                return id != 49 && id != 56 && id != 57 && id != mod_PCcore.powerCrystal.blockID;
            }
            case 4: {
                return id != 49;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private int getBlockMiningCost(PC_CoordI pos, int id) {
        if (!this.canHarvestBlockWithCurrentLevel(pos, id)) {
            return -1;
        }
        if (this.shouldIgnoreBlockForHarvesting(pos, id)) {
            return 0;
        }
        if (Block.blocksList[id].blockMaterial != Material.rock && Block.blocksList[id].blockMaterial != Material.iron) {
            return 10;
        }
        if (id == 73 || id == 74 || id == 21 || id == 14) {
            return 100;
        }
        if (id == 16 || id == 15 || id == 42 || id == 98) {
            return 30;
        }
        if (id == 56 || id == 57 || id == 14) {
            return 150;
        }
        if (id == 49) {
            return 600;
        }
        if (id == 7) {
            return 2000;
        }
        if (id == mod_PCcore.powerCrystal.blockID) {
            return 100;
        }
        return 20;
    }

    private boolean isLocationEmpty(PC_CoordI pos) {
        boolean notempty = false;
        notempty |= !this.checkIfAir(pos.offset(0, 0, 0), true);
        notempty |= !this.checkIfAir(pos.offset(-1, 0, 0), true);
        notempty |= !this.checkIfAir(pos.offset(0, 0, -1), true);
        notempty |= !this.checkIfAir(pos.offset(-1, 0, -1), true);
        notempty |= !this.checkIfAir(pos.offset(0, 1, 0), false);
        notempty |= !this.checkIfAir(pos.offset(-1, 1, 0), false);
        notempty |= !this.checkIfAir(pos.offset(0, 1, -1), false);
        return !(notempty |= !this.checkIfAir(pos.offset(-1, 1, -1), false));
    }

    private boolean checkIfAir(PC_CoordI pos, boolean lower) {
        int id = pos.getId(this.worldObj);
        if (lower && id == Block.stairSingle.blockID) {
            return true;
        }
        Block block = Block.blocksList[id];
        return block == null || block.getCollisionBoundingBoxFromPool(this.worldObj, pos.x, pos.y, pos.z) == null;
    }

    private boolean isOnHalfStep() {
        return this.posY - Math.floor(this.posY + 1.0E-4) >= 0.4;
    }

    private boolean performBridgeBuilding() {
        if (!this.bridgeEnabled) {
            return true;
        }
        int y = (int)Math.floor(this.posY - (double)0.9999f);
        if (this.isOnHalfStep()) {
            return true;
        }
        if (!this.bridgeBuilding_do(this.target.offset(0, -1, 0))) {
            return false;
        }
        if (!this.bridgeBuilding_do(this.target.offset(-1, -1, 0))) {
            return false;
        }
        if (!this.bridgeBuilding_do(this.target.offset(0, -1, -1))) {
            return false;
        }
        return this.bridgeBuilding_do(this.target.offset(-1, -1, -1));
    }

    private boolean bridgeBuilding_do(PC_CoordI pos) {
        if (this.checkIfAir(pos, false)) {
            if (this.level < 3) {
                this.currentCommand = -1;
                return false;
            }
            ItemStack fill = this.getBlockForBuilding();
            if (fill == null) {
                return false;
            }
            int id = fill.itemID;
            int meta = fill.getItemDamage();
            pos.setBlock(this.worldObj, id, meta);
            if (this.shouldMakeEffects()) {
                this.worldObj.playSoundEffect((float)pos.x + 0.5f, (float)pos.y + 0.5f, (float)pos.z + 0.5f, Block.blocksList[id].stepSound.getStepSound(), (Block.blocksList[id].stepSound.getVolume() + 1.0f) / 2.0f, Block.blocksList[id].stepSound.getPitch() * 0.8f);
            }
        }
        return true;
    }

    private void layHalfStep(int x, int y, int z, boolean step) {
        int id;
        int dmg;
        if (step && this.worldObj.getBlockId(x, y, z) == 0 && (dmg = this.getDamageForHalfStep()) != -1) {
            this.worldObj.setBlockAndMetadataWithNotify(x, y, z, Block.stairSingle.blockID, dmg);
        }
        if ((id = this.worldObj.getBlockId(x, y + (step ? -1 : 0), z)) == 0 || id == 8 || id == 9 || id == 10 || id == 11 || Block.blocksList[id].getCollisionBoundingBoxFromPool(this.worldObj, x, y, z) == null) {
            ItemStack fill = this.getBlockForBuilding();
            if (fill == null) {
                return;
            }
            id = fill.itemID;
            int meta = fill.getItemDamage();
            this.worldObj.setBlockAndMetadataWithNotify(x, y + (step ? -1 : 0), z, id, meta);
            if (this.shouldMakeEffects()) {
                this.worldObj.playSoundEffect((float)x + 0.5f, (float)y + (float)(step ? -1 : 0) + 0.5f, (float)z + 0.5f, Block.blocksList[id].stepSound.getStepSound(), (Block.blocksList[id].stepSound.getVolume() + 1.0f) / 2.0f, Block.blocksList[id].stepSound.getPitch() * 0.8f);
            }
        }
    }

    private int getDamageForHalfStep() {
        for (int pass = 0; pass < 3; ++pass) {
            for (int i = 0; i < this.getSizeInventory(); ++i) {
                if (!this.isItemGoodForHalfStep(this.getStackInSlot(i), pass)) continue;
                ItemStack returned = this.decrStackSize(i, 1);
                if (returned.itemID == Block.stairSingle.blockID) {
                    return returned.getItemDamage();
                }
                return this.getDamageFromMaterialForHalfStep(returned.itemID);
            }
        }
        return -1;
    }

    private int getDamageFromMaterialForHalfStep(int id) {
        switch (id) {
            case 1: {
                return 0;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 2;
            }
            case 24: {
                return 1;
            }
            case 45: {
                return 4;
            }
            case 98: {
                return 5;
            }
        }
        return 3;
    }

    private boolean isItemGoodForHalfStep(ItemStack is, int pass) {
        if (is == null) {
            return false;
        }
        int id = is.itemID;
        if (pass == 0) {
            return id == Block.cobblestone.blockID || id == Block.stairSingle.blockID;
        }
        if (pass == 1) {
            return id == Block.planks.blockID || id == Block.stone.blockID;
        }
        if (pass == 2) {
            return id == Block.sandStone.blockID || id == Block.stoneBrick.blockID || id == Block.brick.blockID;
        }
        return false;
    }

    private ItemStack getBlockForBuilding() {
        for (int pass = 0; pass < 3; ++pass) {
            for (int i = 0; i < this.getSizeInventory(); ++i) {
                if (!this.isBlockGoodForBuilding(this.getStackInSlot(i), pass)) continue;
                return this.decrStackSize(i, 1);
            }
        }
        return null;
    }

    private boolean isBlockGoodForBuilding(ItemStack is, int pass) {
        if (is == null) {
            return false;
        }
        if (!(is.getItem() instanceof ItemBlock)) {
            return false;
        }
        int id = is.itemID;
        if (PC_BlockUtils.hasFlag(is, "NO_BUILD")) {
            return false;
        }
        if (id == Block.sand.blockID || id == Block.gravel.blockID) {
            return false;
        }
        if (pass == 0) {
            return id == 2 || id == 3 || id == 4;
        }
        if (pass == 1) {
            return id == 5 || id == 1 || id == 24 || id == 87;
        }
        if (id == 15 || id == 14 || id == 56) {
            return false;
        }
        return id != mod_PCcore.powerCrystal.blockID && Block.blocksList[is.itemID] != null && Block.blocksList[is.itemID].blockMaterial.isSolid();
    }

    private void compressInv() {
        if (this.level < 5) {
            return;
        }
        if (!this.compressBlocks) {
            return;
        }
        int sand = 0;
        int diamond = 0;
        int lapis = 0;
        int glowstone = 0;
        int snowball = 0;
        for (int pass = 0; pass < 3; ++pass) {
            for (int i = 0; i < this.getSizeInventory(); ++i) {
                if (this.getStackInSlot(i) == null) continue;
                if (this.getStackInSlot((int)i).itemID == Block.sand.blockID) {
                    sand += this.getStackInSlot((int)i).stackSize;
                    this.setInventorySlotContents(i, null);
                    continue;
                }
                if (this.getStackInSlot((int)i).itemID == Item.diamond.shiftedIndex) {
                    diamond += this.getStackInSlot((int)i).stackSize;
                    this.setInventorySlotContents(i, null);
                    continue;
                }
                if (this.getStackInSlot((int)i).itemID == Item.snowball.shiftedIndex) {
                    snowball += this.getStackInSlot((int)i).stackSize;
                    this.setInventorySlotContents(i, null);
                    continue;
                }
                if (this.getStackInSlot((int)i).itemID == Item.lightStoneDust.shiftedIndex) {
                    glowstone += this.getStackInSlot((int)i).stackSize;
                    this.setInventorySlotContents(i, null);
                    continue;
                }
                if (this.getStackInSlot((int)i).itemID != Item.dyePowder.shiftedIndex || this.getStackInSlot(i).getItemDamage() != 4) continue;
                lapis += this.getStackInSlot((int)i).stackSize;
                this.setInventorySlotContents(i, null);
            }
        }
        if (sand > 0) {
            ItemStack remaining;
            while (sand >= 4 && PC_InvUtils.addItemStackToInventory(this, new ItemStack(Block.sandStone.blockID, 1, 0))) {
                sand -= 4;
            }
            if (sand > 0 && !PC_InvUtils.addItemStackToInventory(this, remaining = new ItemStack(Block.sand.blockID, sand, 0))) {
                this.entityDropItem(remaining, 1.0f);
            }
        }
        if (snowball > 0) {
            ItemStack remaining;
            while (snowball >= 4 && PC_InvUtils.addItemStackToInventory(this, new ItemStack(Block.blockSnow.blockID, 1, 0))) {
                snowball -= 4;
            }
            if (snowball > 0 && !PC_InvUtils.addItemStackToInventory(this, remaining = new ItemStack(Item.snowball.shiftedIndex, snowball, 0))) {
                this.entityDropItem(remaining, 1.0f);
            }
        }
        if (glowstone > 0) {
            ItemStack remaining;
            while (glowstone >= 4 && PC_InvUtils.addItemStackToInventory(this, new ItemStack(Block.glowStone.blockID, 1, 0))) {
                glowstone -= 4;
            }
            if (glowstone > 0 && !PC_InvUtils.addItemStackToInventory(this, remaining = new ItemStack(Item.lightStoneDust.shiftedIndex, glowstone, 0))) {
                this.entityDropItem(remaining, 1.0f);
            }
        }
        if (diamond > 0) {
            ItemStack remaining;
            while (diamond >= 9 && PC_InvUtils.addItemStackToInventory(this, new ItemStack(Block.blockDiamond.blockID, 1, 0))) {
                diamond -= 9;
            }
            if (diamond > 0 && !PC_InvUtils.addItemStackToInventory(this, remaining = new ItemStack(Item.diamond.shiftedIndex, diamond, 0))) {
                this.entityDropItem(remaining, 1.0f);
            }
        }
        if (lapis > 0) {
            ItemStack remaining;
            while (lapis >= 9 && PC_InvUtils.addItemStackToInventory(this, new ItemStack(Block.blockLapis.blockID, 1, 0))) {
                lapis -= 9;
            }
            if (lapis > 0 && !PC_InvUtils.addItemStackToInventory(this, remaining = new ItemStack(Item.dyePowder.shiftedIndex, lapis, 4))) {
                this.entityDropItem(remaining, 1.0f);
            }
        }
    }

    private void fillLavaNearby() {
        if (this.level < 4 || !this.lavaFillingEnabled) {
            return;
        }
        int y1 = (int)Math.floor(this.posY + (double)1.0E-4f);
        int x1 = (int)Math.round(this.posX);
        int z1 = (int)Math.round(this.posZ);
        boolean replace = true;
        for (int x = x1 - 2; x <= x1 + 1; ++x) {
            for (int y = y1 - 1; y <= y1 + 2; ++y) {
                for (int z = z1 - 2; z <= z1 + 1; ++z) {
                    ItemStack fill;
                    boolean bl = replace = y != y1 && y != y1 + 1 || x != x1 && x != x1 - 1 || z != z1 && z != z1 - 1;
                    if (x == x1 - 2 && y == y1 - 1 || x == x1 - 2 && y == y1 + 2 || x == x1 + 1 && y == y1 - 1 || x == x1 + 1 && y == y1 + 2 || z == z1 - 2 && y == y1 - 1 || z == z1 - 2 && y == y1 + 2 || z == z1 + 1 && y == y1 - 1 || z == z1 + 1 && y == y1 + 2 || x == x1 - 2 && z == z1 - 2 || x == x1 - 2 && z == z1 + 1 || x == x1 + 1 && z == z1 - 2 || x == x1 + 1 && z == z1 + 1) continue;
                    switch ((int)Math.floor(this.rotationYaw)) {
                        case 180: {
                            if (x != x1 - 2) break;
                            replace = false;
                            break;
                        }
                        case 270: {
                            if (z != z1 - 2) break;
                            replace = false;
                            break;
                        }
                        case 0: {
                            if (x != x1 + 1) break;
                            replace = false;
                            break;
                        }
                        case 90: {
                            if (z != z1 + 1) break;
                            replace = false;
                        }
                    }
                    int id = this.worldObj.getBlockId(x, y, z);
                    if (id != 10 && id != 11) continue;
                    this.lavaFillBucket();
                    int fillId = 0;
                    int fillMeta = 0;
                    if (replace && (fill = this.getBlockForBuilding()) != null) {
                        fillId = fill.itemID;
                        fillMeta = fill.getItemDamage();
                    }
                    this.worldObj.setBlockAndMetadataWithNotify(x, y, z, fillId, fillMeta);
                    if (Block.blocksList[fillId] == null || !this.shouldMakeEffects()) continue;
                    this.worldObj.playSoundEffect((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, Block.blocksList[fillId].stepSound.getStepSound(), (Block.blocksList[fillId].stepSound.getVolume() + 1.0f) / 2.0f, Block.blocksList[fillId].stepSound.getPitch() * 0.8f);
                }
            }
        }
    }

    private void fillWaterNearby() {
        if (this.level < 6 || !this.waterFillingEnabled) {
            return;
        }
        int y1 = (int)Math.floor(this.posY + 0.0);
        int x1 = (int)Math.round(this.posX);
        int z1 = (int)Math.round(this.posZ);
        boolean replace = true;
        for (int x = x1 - 2; x <= x1 + 1; ++x) {
            for (int y = y1 - 1; y <= y1 + 2; ++y) {
                for (int z = z1 - 2; z <= z1 + 1; ++z) {
                    ItemStack fill;
                    boolean bl = replace = y != y1 && y != y1 + 1 || x != x1 && x != x1 - 1 || z != z1 && z != z1 - 1;
                    if (x == x1 - 2 && y == y1 - 1 || x == x1 - 2 && y == y1 + 2 || x == x1 + 1 && y == y1 - 1 || x == x1 + 1 && y == y1 + 2 || z == z1 - 2 && y == y1 - 1 || z == z1 - 2 && y == y1 + 2 || z == z1 + 1 && y == y1 - 1 || z == z1 + 1 && y == y1 + 2 || x == x1 - 2 && z == z1 - 2 || x == x1 - 2 && z == z1 + 1 || x == x1 + 1 && z == z1 - 2 || x == x1 + 1 && z == z1 + 1) continue;
                    switch ((int)Math.floor(this.rotationYaw)) {
                        case 180: {
                            if (x != x1 - 2) break;
                            replace = false;
                            break;
                        }
                        case 270: {
                            if (z != z1 - 2) break;
                            replace = false;
                            break;
                        }
                        case 0: {
                            if (x != x1 + 1) break;
                            replace = false;
                            break;
                        }
                        case 90: {
                            if (z != z1 + 1) break;
                            replace = false;
                        }
                    }
                    int id = this.worldObj.getBlockId(x, y, z);
                    if (id != 8 && id != 9) continue;
                    int fillId = 0;
                    int fillMeta = 0;
                    if (replace && (fill = this.getBlockForBuilding()) != null) {
                        fillId = fill.itemID;
                        fillMeta = fill.getItemDamage();
                    }
                    this.worldObj.setBlockAndMetadataWithNotify(x, y, z, fillId, fillMeta);
                    if (Block.blocksList[fillId] == null || !this.shouldMakeEffects()) continue;
                    this.worldObj.playSoundEffect((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, Block.blocksList[fillId].stepSound.getStepSound(), (Block.blocksList[fillId].stepSound.getVolume() + 1.0f) / 2.0f, Block.blocksList[fillId].stepSound.getPitch() * 0.8f);
                }
            }
        }
    }

    private void burriedFix(boolean targetPos) {
        int y1 = (int)Math.floor(this.posY + (double)1.0E-4f);
        if (this.isOnHalfStep()) {
            ++y1;
        }
        int x1 = targetPos ? this.target.x : (int)Math.round(this.posX);
        int z1 = targetPos ? this.target.z : (int)Math.round(this.posZ);
        for (int x = x1 - 1; x <= x1; ++x) {
            for (int y = y1; y <= y1 + 1; ++y) {
                for (int z = z1 - 1; z <= z1; ++z) {
                    int id = this.worldObj.getBlockId(x, y, z);
                    if (id == 0 || !(Block.blocksList[id] instanceof BlockSand) && id != Block.cobblestone.blockID && id != Block.dirt.blockID) continue;
                    this.harvestBlock_do(new PC_CoordI(x, y, z));
                }
            }
        }
    }

    private void depositToNearbyChest() {
        int y1 = (int)Math.floor(this.posY + (double)1.0E-4f);
        int x1 = (int)Math.round(this.posX);
        int z1 = (int)Math.round(this.posZ);
        for (int x = x1 - 2; x <= x1 + 1; ++x) {
            for (int y = y1; y <= y1 + 1; ++y) {
                for (int z = z1 - 2; z <= z1 + 1; ++z) {
                    IInventory chest = PC_InvUtils.getCompositeInventoryAt(this.worldObj, x, y, z);
                    if (chest == null) continue;
                    for (int i = 0; i < this.getSizeInventory(); ++i) {
                        boolean stored = false;
                        boolean crystal = false;
                        ItemStack stack = this.getStackInSlot(i);
                        if (!(stack == null || stack.itemID == mod_PCcore.powerDust.shiftedIndex || stack.itemID == Block.torchWood.blockID || stack.itemID == Item.bucketEmpty.shiftedIndex || stack.itemID == Item.bucketLava.shiftedIndex || this.keepAllFuel && PC_InvUtils.getFuelValue(stack, 0.9) != 0)) {
                            if (stack.itemID == mod_PCcore.powerCrystal.blockID) {
                                if (stack.stackSize <= 1) continue;
                                crystal = true;
                                stack = this.getStackInSlot(i).copy();
                                --stack.stackSize;
                                this.decrStackSize(i, stack.stackSize);
                            }
                            stored = PC_InvUtils.addWholeItemStackToInventory(chest, stack);
                        }
                        if (!stored || crystal) continue;
                        this.setInventorySlotContents(i, null);
                    }
                    if (this.shouldMakeEffects()) {
                        this.worldObj.playSoundAtEntity(this, "random.pop", 0.2f, 0.5f + this.rand.nextFloat() * 0.3f);
                    }
                    return;
                }
            }
        }
    }

    private void performTorchPlacing() {
        if (this.level < 3) {
            return;
        }
        int y = (int)Math.floor(this.posY + (double)1.0E-4f);
        int x = (int)Math.round(this.posX);
        int z = (int)Math.round(this.posZ);
        if (this.getBrightness(1.0f) > 0.2f) {
            return;
        }
        if (this.handleWaterMovement()) {
            return;
        }
        if (!this.hasTorch()) {
            return;
        }
        int leftX = x;
        int leftZ = z;
        int rightX = x;
        int rightZ = z;
        if (this.rotationYaw == 0.0f) {
            rightZ = z - 1;
            leftZ = z;
        }
        if (this.rotationYaw == 90.0f) {
            rightX = x;
            leftX = x - 1;
        }
        if (this.rotationYaw == 180.0f) {
            leftZ = z - 1;
            rightZ = z;
            rightX = leftX = x - 1;
        }
        if (this.rotationYaw == 270.0f) {
            rightX = x - 1;
            leftX = x;
            leftZ = rightZ = z - 1;
        }
        Block torch = Block.torchWood;
        if (!this.torchesOnlyOnFloor) {
            if (this.worldObj.getBlockId(rightX, y + 1, rightZ) == 0 && torch.canPlaceBlockAt(this.worldObj, rightX, y + 1, rightZ)) {
                this.worldObj.setBlockWithNotify(rightX, y + 1, rightZ, torch.blockID);
                this.getTorch();
                return;
            }
            if (this.worldObj.getBlockId(leftX, y + 1, leftZ) == 0 && torch.canPlaceBlockAt(this.worldObj, leftX, y + 1, leftZ)) {
                this.worldObj.setBlockWithNotify(leftX, y + 1, leftZ, torch.blockID);
                this.getTorch();
                return;
            }
        }
        if (this.worldObj.getBlockId(rightX, y, rightZ) == 0 && torch.canPlaceBlockAt(this.worldObj, rightX, y, rightZ)) {
            this.worldObj.setBlockWithNotify(rightX, y, rightZ, torch.blockID);
            if (this.realCommand != 9) {
                Block.torchWood.onBlockPlaced(this.worldObj, rightX, y, rightZ, 1);
            }
            this.getTorch();
            return;
        }
        if (this.worldObj.getBlockId(leftX, y, leftZ) == 0 && torch.canPlaceBlockAt(this.worldObj, leftX, y, leftZ)) {
            this.worldObj.setBlockWithNotify(leftX, y, leftZ, torch.blockID);
            if (this.realCommand != 9) {
                Block.torchWood.onBlockPlaced(this.worldObj, leftX, y, leftZ, 1);
            }
            this.getTorch();
            return;
        }
    }

    private boolean getTorch() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.getStackInSlot(i) == null || this.getStackInSlot((int)i).itemID != Block.torchWood.blockID) continue;
            this.decrStackSize(i, 1);
            return true;
        }
        return false;
    }

    private boolean hasTorch() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.getStackInSlot(i) == null || this.getStackInSlot((int)i).itemID != Block.torchWood.blockID) continue;
            return true;
        }
        return false;
    }

    private boolean lavaFillBucket() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            int id;
            if (this.getStackInSlot(i) == null || (id = this.getStackInSlot((int)i).itemID) != Item.bucketEmpty.shiftedIndex) continue;
            this.setInventorySlotContents(i, new ItemStack(Item.bucketLava, 1, 0));
            return true;
        }
        return false;
    }

    @Override
    public void onUpdate() {
        int j1;
        List list;
        double d7;
        super.onUpdate();
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0) {
            this.setDamageTaken(this.getDamageTaken() - 1);
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        boolean stop = this.programmingGuiOpen;
        if (!stop) {
            if (this.waitingForFuel > 0 && this.addFuelForCost(this.waitingForFuel)) {
                this.waitingForFuel = 0;
                this.prepareForCommandExecution();
            }
            this.releaseAllocatedFuelIfNoLongerNeeded();
            if (this.waitingForFuel < 0) {
                this.waitingForFuel = 0;
            }
            if (this.currentCommand == -1 && this.waitingForFuel != 0) {
                this.waitingForFuel = 0;
            }
            if (this.waitingForFuel == 0) {
                if (PCmo_Command.isCommandTurn(this.currentCommand)) {
                    this.motionZ = 0.0;
                    this.motionX = 0.0;
                    this.posX = this.target.x;
                    this.posZ = this.target.z;
                    if (Math.abs(this.rotationRemaining) < 3) {
                        this.currentCommand = -1;
                        this.posX = this.target.x;
                        this.posZ = this.target.z;
                        this.rotationRemaining = 0;
                        this.roundRotation();
                    } else {
                        this.playMotionEffect();
                        int step = MathHelper.clamp_int(this.level, 3, 7);
                        step = MathHelper.clamp_int(step, 0, Math.abs(this.rotationRemaining));
                        int incr = this.rotationRemaining > 0 ? step : -step;
                        this.rotationYaw += (float)incr;
                        if (this.rotationYaw < 0.0f) {
                            this.rotationYaw = this.prevRotationYaw = 360.0f + this.rotationYaw;
                        }
                        if (this.rotationYaw > 360.0f) {
                            this.rotationYaw = this.prevRotationYaw = this.rotationYaw - 360.0f;
                        }
                        this.rotationRemaining -= incr;
                    }
                }
                if (this.currentCommand != -1) {
                    this.burriedFix(false);
                }
                if (PCmo_Command.isCommandMove(this.currentCommand) || this.currentCommand == 9 && this.isMiningDone()) {
                    this.roundRotation();
                    this.performTorchPlacing();
                    if (this.isMinerAtTargetPos()) {
                        this.consumeAllocatedFuel(this.getStepCost());
                        this.fillLavaNearby();
                        this.fillWaterNearby();
                        if (this.getTargetDistanceX() > 0.03125) {
                            this.posX = this.prevPosX = (double)this.target.x;
                        }
                        if (this.getTargetDistanceZ() > 0.03125) {
                            this.posZ = this.prevPosZ = (double)this.target.z;
                        }
                        --this.stepCounter;
                        if (this.stepCounter <= 0) {
                            this.currentCommand = -1;
                            if (this.commandList.length() == 0) {
                                this.motionX = 0.0;
                                this.motionZ = 0.0;
                            }
                            this.stepCounter = 0;
                        } else {
                            this.prepareForCommandExecution();
                        }
                    }
                }
                if (PCmo_Command.isCommandMove(this.currentCommand) || this.currentCommand == 8 || this.currentCommand == 9) {
                    boolean canMove;
                    this.roundRotation();
                    boolean fw = this.currentCommand == 0;
                    boolean dwn = this.currentCommand == 8;
                    boolean up = this.currentCommand == 9;
                    boolean back = this.currentCommand == 3;
                    int x = (int)Math.round(this.posX);
                    int y = (int)Math.floor(this.posY + (double)1.0E-4f);
                    if (this.isOnHalfStep()) {
                        ++y;
                    }
                    int z = (int)Math.round(this.posZ);
                    boolean bridgeOk = true;
                    if (!this.bridgeDone && (bridgeOk = this.performBridgeBuilding())) {
                        this.bridgeDone = true;
                    }
                    if (this.isMiningInProgress() || !bridgeOk) {
                        this.motionZ = 0.0;
                        this.motionX = 0.0;
                    }
                    boolean miningDone = this.isMiningDone();
                    boolean bl = canMove = bridgeOk && !dwn && (!up || miningDone);
                    if (up && !miningDone) {
                        this.performMiningUpdate(new PC_CoordI(x, y + 2, z), 8);
                        this.performMiningUpdate(new PC_CoordI(x - 1, y + 2, z), 9);
                        this.performMiningUpdate(new PC_CoordI(x, y + 2, z - 1), 10);
                        this.performMiningUpdate(new PC_CoordI(x - 1, y + 2, z - 1), 11);
                    }
                    double motionAdd = MOTION_SPEED[this.level - 1] * (double)(fw || up ? 1 : -1) * 0.5;
                    if (this.rotationYaw == 180.0f) {
                        if (!miningDone && !back && this.miningEnabled) {
                            this.performMiningUpdate(new PC_CoordI(x + 1, y, z - 1), 0);
                            this.performMiningUpdate(new PC_CoordI(x + 1, y, z), 1);
                            this.performMiningUpdate(new PC_CoordI(x + 1, y + 1, z), 2);
                            this.performMiningUpdate(new PC_CoordI(x + 1, y + 1, z - 1), 3);
                            if (dwn) {
                                this.performMiningUpdate(new PC_CoordI(x + 1, y - 1, z - 1), 4);
                                this.performMiningUpdate(new PC_CoordI(x + 1, y - 1, z), 5);
                            }
                            if (up) {
                                this.performMiningUpdate(new PC_CoordI(x + 1, y + 2, z - 1), 6);
                                this.performMiningUpdate(new PC_CoordI(x + 1, y + 2, z), 7);
                            }
                        }
                        if (this.isLocationEmpty(this.target.setY(y)) && canMove) {
                            this.motionX += motionAdd;
                        }
                        this.motionZ = 0.0;
                    }
                    if (this.rotationYaw == 270.0f) {
                        if (!miningDone && !back && this.miningEnabled) {
                            this.performMiningUpdate(new PC_CoordI(x - 1, y, z + 1), 0);
                            this.performMiningUpdate(new PC_CoordI(x, y, z + 1), 1);
                            this.performMiningUpdate(new PC_CoordI(x - 1, y + 1, z + 1), 2);
                            this.performMiningUpdate(new PC_CoordI(x, y + 1, z + 1), 3);
                            if (dwn) {
                                this.performMiningUpdate(new PC_CoordI(x - 1, y - 1, z + 1), 4);
                                this.performMiningUpdate(new PC_CoordI(x, y - 1, z + 1), 5);
                            }
                            if (up) {
                                this.performMiningUpdate(new PC_CoordI(x - 1, y + 2, z + 1), 6);
                                this.performMiningUpdate(new PC_CoordI(x, y + 2, z + 1), 7);
                            }
                        }
                        if (this.isLocationEmpty(this.target.setY(y)) && canMove) {
                            this.motionZ += motionAdd;
                        }
                        this.motionX = 0.0;
                    }
                    if (this.rotationYaw == 0.0f) {
                        if (!miningDone && !back && this.miningEnabled) {
                            this.performMiningUpdate(new PC_CoordI(x - 2, y, z - 1), 0);
                            this.performMiningUpdate(new PC_CoordI(x - 2, y, z), 1);
                            this.performMiningUpdate(new PC_CoordI(x - 2, y + 1, z), 2);
                            this.performMiningUpdate(new PC_CoordI(x - 2, y + 1, z - 1), 3);
                            if (dwn) {
                                this.performMiningUpdate(new PC_CoordI(x - 2, y - 1, z - 1), 4);
                                this.performMiningUpdate(new PC_CoordI(x - 2, y - 1, z), 5);
                            }
                            if (up) {
                                this.performMiningUpdate(new PC_CoordI(x - 2, y + 2, z - 1), 6);
                                this.performMiningUpdate(new PC_CoordI(x - 2, y + 2, z), 7);
                            }
                        }
                        if (this.isLocationEmpty(this.target.setY(y)) && canMove) {
                            this.motionX -= motionAdd;
                        }
                        this.motionZ = 0.0;
                    }
                    if (this.rotationYaw == 90.0f) {
                        if (!miningDone && !back && this.miningEnabled) {
                            this.performMiningUpdate(new PC_CoordI(x - 1, y, z - 2), 0);
                            this.performMiningUpdate(new PC_CoordI(x, y, z - 2), 1);
                            this.performMiningUpdate(new PC_CoordI(x - 1, y + 1, z - 2), 2);
                            this.performMiningUpdate(new PC_CoordI(x, y + 1, z - 2), 3);
                            if (dwn) {
                                this.performMiningUpdate(new PC_CoordI(x - 1, y - 1, z - 2), 4);
                                this.performMiningUpdate(new PC_CoordI(x, y - 1, z - 2), 5);
                            }
                            if (up) {
                                this.performMiningUpdate(new PC_CoordI(x - 1, y + 2, z - 2), 6);
                                this.performMiningUpdate(new PC_CoordI(x, y + 2, z - 2), 7);
                            }
                        }
                        if (this.isLocationEmpty(this.target.setY(y)) && canMove) {
                            this.motionZ -= motionAdd;
                        }
                        this.motionX = 0.0;
                    }
                    if (dwn && !this.isMiningInProgress()) {
                        this.currentCommand = -1;
                    }
                    if (up && this.isMiningDone() && !this.upStepLaid) {
                        switch ((int)Math.floor(this.rotationYaw)) {
                            case 0: {
                                this.layHalfStep(x - 2, y, z - 1, true);
                                this.layHalfStep(x - 2, y, z, true);
                                break;
                            }
                            case 90: {
                                this.layHalfStep(x - 1, y, z - 2, true);
                                this.layHalfStep(x, y, z - 2, true);
                                break;
                            }
                            case 180: {
                                this.layHalfStep(x + 1, y, z - 1, true);
                                this.layHalfStep(x + 1, y, z, true);
                                break;
                            }
                            case 270: {
                                this.layHalfStep(x - 1, y, z + 1, true);
                                this.layHalfStep(x, y, z + 1, true);
                            }
                        }
                        this.upStepLaid = true;
                    }
                    if (!(this.miningEnabled && this.isMiningInProgress() && this.currentCommand != 3 || this.isLocationEmpty(this.target.setY(y)))) {
                        this.burriedFix(fw && this.miningEnabled);
                        if (!this.isLocationEmpty(this.target.setY(y))) {
                            if (!this.miningEnabled || this.currentCommand == 3) {
                                this.currentCommand = -1;
                                this.resetMineCounter();
                                this.consumeAllocatedFuel(this.getStepCost());
                                this.target.x = (int)Math.round(this.posX);
                                this.target.z = (int)Math.round(this.posZ);
                                this.target.y = (int)Math.round(this.posY + (double)0.001f);
                                this.stepCounter = 0;
                            }
                            this.motionZ = 0.0;
                            this.motionX = 0.0;
                        }
                    }
                }
            }
        }
        if (!this.onGround) {
            this.motionY -= 0.04;
        }
        if (this.motionX < -(d7 = MOTION_SPEED[this.level - 1])) {
            this.motionX = -d7;
        }
        if (this.motionX > d7) {
            this.motionX = d7;
        }
        if (this.motionZ < -d7) {
            this.motionZ = -d7;
        }
        if (this.motionZ > d7) {
            this.motionZ = d7;
        }
        if (!stop && this.onGround && this.currentCommand == -1 && this.commandList.length() > 0) {
            int oldCmd = this.currentCommand;
            this.currentCommand = this.getNextCommand();
            if (this.currentCommand != -1 && this.currentCommand != oldCmd) {
                this.alignToBlocks();
            }
            if (this.currentCommand == -1 && !this.keyboardControlled) {
                this.alignToBlocks();
            }
            this.prepareForCommandExecution();
            if (this.currentCommand != -1) {
                this.setSprinting(true);
            }
        }
        if (this.currentCommand == -1 && this.commandList.length() == 0) {
            this.motionX = 0.0;
            this.motionZ = 0.0;
            this.setSprinting(false);
        }
        if (Math.abs(this.motionX) > 1.0E-4 || Math.abs(this.motionZ) > 1.0E-4) {
            this.playMotionEffect();
        }
        if ((list = this.worldObj.getEntitiesWithinAABB(EntityItem.class, this.boundingBox.expand(1.5, 0.5, 1.5))) != null && list.size() > 0) {
            for (j1 = 0; j1 < list.size(); ++j1) {
                boolean compress;
                EntityItem entity = (EntityItem)list.get(j1);
                if (entity.delayBeforeCanPickup >= 7) continue;
                int id = entity.item.itemID;
                int dmg = entity.item.getItemDamage();
                boolean xtal = id == mod_PCcore.powerCrystal.blockID;
                boolean bl = compress = id == Block.sand.blockID || id == Item.snowball.shiftedIndex || id == Item.diamond.shiftedIndex || id == Item.dyePowder.shiftedIndex && dmg == 4 || id == Item.lightStoneDust.shiftedIndex;
                if (this.shouldDestroyStack(entity.item)) {
                    entity.setDead();
                    continue;
                }
                if (PC_InvUtils.addItemStackToInventory(this, entity.item)) {
                    entity.setDead();
                }
                if (xtal) {
                    this.updateLevel();
                }
                if (!compress || !this.compressBlocks) continue;
                this.compressInv();
            }
        }
        if ((list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2, 0.01, 0.2))) != null && list.size() > 0) {
            for (j1 = 0; j1 < list.size(); ++j1) {
                Entity entity = (Entity)list.get(j1);
                if (entity instanceof EntityFX || entity instanceof EntityXPOrb || entity.isDead) continue;
                if (entity instanceof EntityArrow) {
                    PC_InvUtils.addItemStackToInventory(this, new ItemStack(Item.arrow, 1, 0));
                    entity.setDead();
                    return;
                }
                double motionX_prev = this.motionX;
                double motionY_prev = this.motionY;
                double motionZ_prev = this.motionZ;
                entity.applyEntityCollision(this);
                this.motionX = motionX_prev;
                this.motionY = motionY_prev;
                this.motionZ = motionZ_prev;
            }
        }
        this.moveEntity(Math.min(this.motionX, this.getTargetDistanceX()), this.motionY, Math.min(this.motionZ, this.getTargetDistanceZ()));
        this.motionX *= 0.7;
        this.motionZ *= 0.7;
    }

    @Override
    public void applyEntityCollision(Entity entity) {
        if (entity.riddenByEntity == this || entity.ridingEntity == this) {
            return;
        }
        double d = entity.posX - this.posX;
        double d1 = entity.posZ - this.posZ;
        double d2 = MathHelper.abs_max(d, d1);
        if (d2 >= (double)0.01f) {
            d2 = MathHelper.sqrt_double(d2);
            d /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d *= d3;
            d1 *= d3;
            d *= (double)0.05f;
            d1 *= (double)0.05f;
            this.isAirBorne = true;
            entity.addVelocity(d *= (double)(1.0f - this.entityCollisionReduction), 0.0, d1 *= (double)(1.0f - this.entityCollisionReduction));
        }
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound tag) {
        NBTTagCompound code = new NBTTagCompound();
        code.setString("CommandList", this.commandList);
        code.setShort("CurrentCommand", (short)this.currentCommand);
        code.setShort("RealCommand", (short)this.realCommand);
        code.setShort("StepCounter", (short)this.stepCounter);
        code.setString("CommandListSaved", this.commandListSaved);
        code.setString("Program", this.program);
        code.setBoolean("Paused", this.paused);
        code.setBoolean("Keyboard", this.keyboardControlled);
        tag.setTag("MinerCode", code);
        NBTTagCompound status = new NBTTagCompound();
        status.setByte("Level", (byte)this.level);
        status.setShort("RotationRemaining", (short)this.rotationRemaining);
        PC_Utils.writeWrappedToNBT(status, "target", this.target);
        status.setInteger("fuelBuffer", this.fuelBuffer);
        status.setInteger("fuelAllocated", this.fuelAllocated);
        status.setInteger("waitingForFuel", this.waitingForFuel);
        status.setBoolean("miningEnabled", this.miningEnabled);
        status.setBoolean("bridgeEnabled", this.bridgeEnabled);
        status.setBoolean("lavaFillingEnabled", this.lavaFillingEnabled);
        status.setBoolean("waterEnabled", this.waterFillingEnabled);
        status.setBoolean("keepAllFuel", this.keepAllFuel);
        status.setBoolean("torchesOnlyOnFloor", this.torchesOnlyOnFloor);
        status.setBoolean("craftCompress", this.compressBlocks);
        status.setByte("Destroy", this.DESTROY);
        status.setInteger("waitingForFuel", this.waitingForFuel);
        status.setInteger("mineTime0", this.mineCounter[0]);
        status.setInteger("mineTime1", this.mineCounter[1]);
        status.setInteger("mineTime2", this.mineCounter[2]);
        status.setInteger("mineTime3", this.mineCounter[3]);
        status.setInteger("mineTime4", this.mineCounter[4]);
        status.setInteger("mineTime5", this.mineCounter[5]);
        tag.setTag("MinerStatus", status);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            this.inventory[i].writeToNBT(nbttagcompound1);
            nbttaglist.appendTag(nbttagcompound1);
        }
        tag.setTag("Items", nbttaglist);
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound tag) {
        NBTTagCompound code = tag.getCompoundTag("MinerCode");
        this.commandList = code.getString("CommandList");
        this.currentCommand = code.getShort("CurrentCommand");
        this.realCommand = code.getShort("RealCommand");
        this.stepCounter = code.getShort("StepCounter");
        this.commandListSaved = code.getString("CommandListSaved");
        this.program = code.getString("Program");
        this.paused = code.getBoolean("Paused");
        this.keyboardControlled = code.getBoolean("Keyboard");
        NBTTagCompound status = tag.getCompoundTag("MinerStatus");
        this.level = MathHelper.clamp_int(status.getByte("Level"), 1, 8);
        this.rotationRemaining = status.getShort("RotationRemaining");
        PC_Utils.readWrappedFromNBT(status, "target", this.target);
        this.fuelBuffer = status.getInteger("fuelBuffer");
        this.fuelAllocated = status.getInteger("fuelAllocated");
        this.waitingForFuel = status.getInteger("waitingForFuel");
        this.miningEnabled = status.getBoolean("miningEnabled");
        this.bridgeEnabled = status.getBoolean("bridgeEnabled");
        this.lavaFillingEnabled = status.getBoolean("lavaFillingEnabled");
        this.waterFillingEnabled = status.getBoolean("waterEnabled");
        this.keepAllFuel = status.getBoolean("keepAllFuel");
        this.torchesOnlyOnFloor = status.getBoolean("torchesOnlyOnFloor");
        this.compressBlocks = status.getBoolean("craftCompress");
        this.DESTROY = status.getByte("Destroy");
        this.waitingForFuel = status.getInteger("waitingForFuel");
        this.mineCounter[0] = status.getInteger("mineTime0");
        this.mineCounter[1] = status.getInteger("mineTime1");
        this.mineCounter[2] = status.getInteger("mineTime2");
        this.mineCounter[3] = status.getInteger("mineTime3");
        this.mineCounter[4] = status.getInteger("mineTime4");
        this.mineCounter[5] = status.getInteger("mineTime5");
        NBTTagList nbttaglist = tag.getTagList("Items");
        this.inventory = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i);
            int j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
        }
        if (this.keyboardControlled) {
            PCmo_MinerControlHandler.setMinerForKeyboardControl(this, true);
        }
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityPlayer && this.riddenByEntity != entityplayer) {
            return true;
        }
        if (!this.worldObj.isRemote) {
            if (entityplayer.isSneaking()) {
                this.programmingGuiOpen = true;
                this.openedGui = true;
                PC_Utils.openGres(entityplayer, new PCmo_GuiMinerConsole(this));
                return true;
            }
            if (entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == mod_PCcore.activator.shiftedIndex) {
                this.setKeyboardControl(!this.keyboardControlled);
            } else if (entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.stick.shiftedIndex) {
                PC_Utils.chatMsg(this.rotationYaw + "\u00b0", true);
                PC_Utils.chatMsg("PROGRAM: " + this.program, false);
                PC_Utils.chatMsg("Buffer: " + this.commandList.length() + " commands.", false);
                PC_Utils.chatMsg("Inctruction = " + Character.toString(PCmo_Command.getCharFromInt(this.currentCommand).charValue()) + ", Step counter = " + this.stepCounter, false);
                PC_Utils.chatMsg("FUEL: burning = " + this.fuelBuffer + ", allocated = " + this.fuelAllocated + ", deficit = " + this.waitingForFuel, false);
                PC_Utils.chatMsg("bridge = " + this.bridgeEnabled + ", mining = " + this.miningEnabled + ", destroy_flags = " + this.DESTROY, false);
            } else {
                this.openedGui = true;
                ModLoader.openGUI(entityplayer, new GuiChest(entityplayer.inventory, this));
            }
        }
        return true;
    }

    public void setDamageTaken(int i) {
        this.dataWatcher.updateObject(19, i);
    }

    public int getDamageTaken() {
        return this.dataWatcher.getWatchableObjectInt(19);
    }

    public void setTimeSinceHit(int i) {
        this.dataWatcher.updateObject(17, i);
    }

    public int getTimeSinceHit() {
        return this.dataWatcher.getWatchableObjectInt(17);
    }

    public void setForwardDirection(int i) {
        this.dataWatcher.updateObject(18, i);
    }

    public int getForwardDirection() {
        return this.dataWatcher.getWatchableObjectInt(18);
    }

    @Override
    public int getSizeInventory() {
        return 54;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.inventory[i];
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].stackSize <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                this.onInventoryChanged();
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].splitStack(j);
            if (this.inventory[i].stackSize == 0) {
                this.inventory[i] = null;
            }
            this.onInventoryChanged();
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
        this.onInventoryChanged();
    }

    @Override
    public String getInvName() {
        return PC_Lang.tr("pc.miner.chestName");
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return entityplayer.getDistanceSq(this.posX, this.posY, this.posZ) <= 64.0;
    }

    @Override
    public void openChest() {
    }

    @Override
    public void closeChest() {
        this.openedGui = false;
        this.updateLevel();
    }

    @Override
    public void onInventoryChanged() {
    }

    private void consumeAllocatedFuel(int count) {
        this.fuelAllocated -= count;
        this.fuelBuffer -= count;
        if (this.fuelBuffer < 0) {
            this.fuelBuffer = 0;
        }
        if (this.fuelAllocated < 0) {
            this.fuelAllocated = 0;
        }
    }

    private void releaseAllocatedFuelIfNoLongerNeeded() {
        if (!this.isMiningInProgress() && this.currentCommand == -1) {
            this.fuelAllocated = 0;
        }
    }

    private boolean addFuelForCost(int cost) {
        if (this.fuelBuffer - this.fuelAllocated >= cost) {
            this.fuelAllocated += cost;
            return true;
        }
        for (int s = 0; s < this.getSizeInventory(); ++s) {
            ItemStack stack = this.getStackInSlot(s);
            int bt = PC_InvUtils.getFuelValue(stack, 0.9);
            if (bt <= 0) continue;
            this.fuelBuffer += bt;
            if (stack.getItem().hasContainerItem()) {
                this.setInventorySlotContents(s, new ItemStack(stack.getItem().getContainerItem(), 1, 0));
            } else {
                this.decrStackSize(s, 1);
            }
            if (this.fuelBuffer - this.fuelAllocated < cost) continue;
            this.fuelAllocated += cost;
            return true;
        }
        if (this.fuelBuffer - this.fuelAllocated >= cost) {
            this.fuelAllocated += cost;
            return true;
        }
        this.waitingForFuel += cost - (this.fuelBuffer + this.fuelAllocated);
        return false;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int par1) {
        if (this.inventory[par1] != null) {
            ItemStack itemstack = this.inventory[par1];
            this.inventory[par1] = null;
            return itemstack;
        }
        return null;
    }
}

