/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityFX;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityXPOrb;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_IRotatedBox;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCtr_BlockConveyor;
import net.minecraft.src.PCtr_GuiConveyorSeparator;
import net.minecraft.src.PCtr_MaterialConveyor;
import net.minecraft.src.PCtr_TileEntitySeparationBelt;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCcore;
import net.minecraft.src.mod_PCtransport;

public class PCtr_BlockConveyorSeparator
extends BlockContainer
implements PC_IBlockType,
PC_ISwapTerrain,
PC_IRotatedBox,
ITextureProvider {
    public static final double MAX_HORIZONTAL_SPEED = 0.4;
    public static final double HORIZONTAL_BOOST = 0.12;
    public static final double BORDERS = 0.3;
    public static final double BORDER_BOOST = 0.06;
    public static final float HEIGHT_BOUNDS = 0.0625f;
    public static final float HEIGHT_COLLISION = 0.05f;
    public static final float HEIGHT_SELECTED = 0.0625f;
    public static final float HEIGHT_MIN = 0.0f;
    public static boolean group_wood_sort;

    @Override
    public boolean renderItemOnSide() {
        return true;
    }

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 0) {
            return 1;
        }
        if (i == 1) {
            return 7;
        }
        return 2;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return l != 1;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return PC_Renderer.rotatedBoxRenderer;
    }

    @Override
    public String getTerrainFile() {
        return mod_PCtransport.getTerrainFile();
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        ItemStack ihold = entityplayer.getCurrentEquippedItem();
        if (ihold != null && ihold.getItem() instanceof ItemBlock && Block.blocksList[ihold.itemID] instanceof PC_IBlockType && ihold.itemID != this.blockID) {
            return false;
        }
        PCtr_TileEntitySeparationBelt te = (PCtr_TileEntitySeparationBelt)world.getBlockTileEntity(i, j, k);
        ModLoader.openGUI(entityplayer, new PCtr_GuiConveyorSeparator(entityplayer.inventory, te));
        return true;
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PCtr_TileEntitySeparationBelt();
    }

    protected PCtr_BlockConveyorSeparator(int i) {
        super(i, new PCtr_MaterialConveyor());
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
        this.setStepSound(Block.soundPowderFootstep);
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        PCtr_TileEntitySeparationBelt te = (PCtr_TileEntitySeparationBelt)world.getBlockTileEntity(i, j, k);
        for (int l = 0; l < te.getSizeInventory(); ++l) {
            ItemStack itemstack = te.getStackInSlot(l);
            if (itemstack == null) continue;
            float f = world.rand.nextFloat() * 0.8f + 0.1f;
            float f1 = world.rand.nextFloat() * 0.8f + 0.1f;
            float f2 = world.rand.nextFloat() * 0.8f + 0.1f;
            while (itemstack.stackSize > 0) {
                int i1 = world.rand.nextInt(21) + 10;
                if (i1 > itemstack.stackSize) {
                    i1 = itemstack.stackSize;
                }
                itemstack.stackSize -= i1;
                EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, new ItemStack(itemstack.itemID, i1, itemstack.getItemDamage()));
                float f3 = 0.05f;
                entityitem.motionX = (float)world.rand.nextGaussian() * f3;
                entityitem.motionY = (float)world.rand.nextGaussian() * f3 + 0.2f;
                entityitem.motionZ = (float)world.rand.nextGaussian() * f3;
                world.spawnEntityInWorld(entityitem);
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }

    public boolean getIsBlockSolid(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return true;
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
        int l = MathHelper.floor_double((double)(entityliving.rotationYaw * 4.0f / 360.0f) + 2.5) & 3;
        if (PC_Utils.isPlacingReversed()) {
            l = PC_Utils.reverseSide(l);
        }
        if (l == 2) {
            l = 8;
        }
        if (l == 3) {
            l = 9;
        }
        world.setBlockMetadataWithNotify(i, j, k, l);
    }

    @Override
    public int getRotation(int meta) {
        switch (meta) {
            case 0: 
            case 6: {
                return 0;
            }
            case 1: 
            case 7: {
                return 1;
            }
            case 8: 
            case 14: {
                return 2;
            }
            case 9: 
            case 15: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        int redir = 0;
        if (entity instanceof EntityFX) {
            return;
        }
        if (!entity.isEntityAlive()) {
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).isSneaking()) {
            return;
        }
        PCtr_TileEntitySeparationBelt filter = (PCtr_TileEntitySeparationBelt)world.getBlockTileEntity(i, j, k);
        redir = filter.newDirection(entity);
        if (world.rand.nextInt(25) == 0 && mod_PCcore.soundsEnabled) {
            world.playSoundEffect(i, j, k, "random.wood click", (world.rand.nextFloat() + 0.2f) / 6.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.4f);
        }
        int meta = this.getRotation(world.getBlockMetadata(i, j, k));
        if (entity instanceof EntityItem && entity.motionY > 0.3) {
            entity.motionY *= 0.5;
        }
        if (meta == 0 && redir == 0 || meta == 1 && redir == 1 || meta == 3 && redir == -1) {
            if (!PCtr_BlockConveyor.isBlocked(world, i, j, k - 1)) {
                this.longlife(entity, world, i, j, k - 1);
                if (entity.motionZ >= -0.4) {
                    entity.motionZ -= 0.12;
                }
            }
            if (entity.posX > (double)i + 0.7) {
                entity.motionX -= 0.06;
            }
            if (entity.posX < (double)i + 0.3) {
                entity.motionX += 0.06;
            }
            if (entity instanceof EntityItem && PCtr_BlockConveyor.storeEntityItemAt(world, i, j, k - 1, (EntityItem)entity)) {
                return;
            }
            return;
        }
        if (meta == 1 && redir == 0 || meta == 0 && redir == -1 || meta == 2 && redir == 1) {
            if (!PCtr_BlockConveyor.isBlocked(world, i + 1, j, k)) {
                this.longlife(entity, world, i + 1, j, k);
                if (entity.motionX <= 0.4) {
                    entity.motionX += 0.12;
                }
            }
            if (entity.posZ > (double)k + 0.3) {
                entity.motionZ -= 0.06;
            }
            if (entity.posZ < (double)k + 0.7) {
                entity.motionZ += 0.06;
            }
            if (entity instanceof EntityItem && PCtr_BlockConveyor.storeEntityItemAt(world, i + 1, j, k, (EntityItem)entity)) {
                return;
            }
            return;
        }
        if (meta == 2 && redir == 0 || meta == 1 && redir == -1 || meta == 3 && redir == 1) {
            if (!PCtr_BlockConveyor.isBlocked(world, i, j, k + 1)) {
                this.longlife(entity, world, i, j, k + 1);
                if (entity.motionZ <= 0.4) {
                    entity.motionZ += 0.12;
                }
            }
            if (entity.posX > (double)i + 0.7) {
                entity.motionX -= 0.06;
            }
            if (entity.posX < (double)i + 0.3) {
                entity.motionX += 0.06;
            }
            if (entity instanceof EntityItem && PCtr_BlockConveyor.storeEntityItemAt(world, i, j, k + 1, (EntityItem)entity)) {
                return;
            }
            return;
        }
        if (meta == 3 && redir == 0 || meta == 0 && redir == 1 || meta == 2 && redir == -1) {
            if (!PCtr_BlockConveyor.isBlocked(world, i - 1, j, k)) {
                this.longlife(entity, world, i - 1, j, k);
                if (entity.motionX >= -0.4) {
                    entity.motionX -= 0.12;
                }
            }
            if (entity.posX > (double)k + 0.3) {
                entity.motionX -= 0.06;
            }
            if (entity.posX < (double)k + 0.7) {
                entity.motionX += 0.06;
            }
            if (entity instanceof EntityItem && PCtr_BlockConveyor.storeEntityItemAt(world, i - 1, j, k, (EntityItem)entity)) {
                return;
            }
            return;
        }
    }

    public void longlife(Entity entity, World world, int i, int j, int k) {
        if (entity instanceof EntityItem) {
            ((EntityItem)entity).delayBeforeCanPickup = 10;
            if (((EntityItem)entity).age >= 5000 && world.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, j + 1, k + 1)).size() < 50) {
                ((EntityItem)entity).age = 4000;
            }
        }
        if (entity instanceof EntityXPOrb && ((EntityXPOrb)entity).xpOrbAge >= 5000 && world.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, j + 1, k + 1)).size() < 50) {
            ((EntityXPOrb)entity).xpOrbAge = 4000;
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool(i, 0.0f + (float)j, k, i + 1, (float)j + 0.05f + 0.0f, k + 1);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        float f = 0.0f;
        f = 0.0625f;
        return AxisAlignedBB.getBoundingBoxFromPool(i, 0.0f + (float)j, k, i + 1, (float)j + f, (float)k + 1.0f);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.5f, 0.0f, 1.0f, 0.6f, 1.0f);
    }

    @Override
    public int quantityDropped(Random random) {
        return 1;
    }

    @Override
    public int getMobilityFlag() {
        return 2;
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("TRANSLUCENT");
        set.add("BELT");
        set.add("BELT_SEPARATOR");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

