/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.PC_GresButton;
import net.minecraft.src.PC_GresCheckBox;
import net.minecraft.src.PC_GresLabel;
import net.minecraft.src.PC_GresLayoutH;
import net.minecraft.src.PC_GresLayoutV;
import net.minecraft.src.PC_GresRadioButton;
import net.minecraft.src.PC_GresTextEdit;
import net.minecraft.src.PC_GresWidget;
import net.minecraft.src.PC_GresWindow;
import net.minecraft.src.PC_IGresBase;
import net.minecraft.src.PC_IGresGui;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCtr_TeleporterHelper;
import net.minecraft.src.PCtr_TileEntityTeleporter;

public class PCtr_GuiTeleporter
implements PC_IGresBase {
    private PCtr_TileEntityTeleporter teleporter;
    private PC_GresCheckBox checkItems;
    private PC_GresCheckBox checkAnimals;
    private PC_GresCheckBox checkMobs;
    private PC_GresCheckBox checkPlayers;
    private PC_GresCheckBox checkSneak;
    private PC_GresRadioButton checkN;
    private PC_GresRadioButton checkS;
    private PC_GresRadioButton checkE;
    private PC_GresRadioButton checkW;
    private String field = "";
    private int type = 0;
    private static final int SENDER = 1;
    private static final int RECEIVER = 2;
    private String error = "";
    private boolean isnew = false;
    private PC_GresTextEdit edit;
    private PC_GresWidget buttonCancel;
    private PC_GresWidget buttonOK;
    private PC_GresWidget txError;

    public PCtr_GuiTeleporter(PCtr_TileEntityTeleporter te) {
        this(te, false);
    }

    public PCtr_GuiTeleporter(PCtr_TileEntityTeleporter te, boolean newt) {
        this.isnew = newt;
        this.teleporter = te;
        if (this.teleporter.isSender()) {
            this.type = 1;
            this.field = new String(this.teleporter.target);
        } else if (this.teleporter.isReceiver()) {
            this.type = 2;
            this.field = new String(this.teleporter.identifier);
        } else {
            PC_Logger.warning("openned gui for invalid teleporter device.");
        }
    }

    @Override
    public EntityPlayer getPlayer() {
        return PC_Utils.mc().thePlayer;
    }

    @Override
    public void initGui(PC_IGresGui gui) {
        String aa = "";
        if (this.type == 1) {
            aa = PC_Lang.tr("pc.gui.teleporter.titleSender");
        }
        if (this.type == 2) {
            aa = PC_Lang.tr("pc.gui.teleporter.titleTarget");
        }
        PC_GresWindow w = new PC_GresWindow(aa);
        PC_GresWidget vg = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
        vg.add(new PC_GresLabel(this.type == 1 ? PC_Lang.tr("pc.gui.teleporter.linksTo") : PC_Lang.tr("pc.gui.teleporter.deviceId")));
        this.edit = new PC_GresTextEdit(this.field, 20, PC_GresTextEdit.PC_GresInputType.TEXT);
        vg.add(this.edit);
        w.add(vg);
        PC_GresWidget hg = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.txError = new PC_GresLabel("").setColor(0, 0x990000);
        hg.add(this.txError);
        w.add(hg);
        if (this.type == 1) {
            PC_GresWidget vg1 = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            vg1.add(new PC_GresLabel(PC_Lang.tr("pc.gui.teleporter.teleportGroup")));
            hg = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            vg = new PC_GresLayoutV().setMinWidth(100).setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            this.checkItems = new PC_GresCheckBox(PC_Lang.tr("pc.gui.teleporter.items")).check(this.teleporter.items);
            vg.add(this.checkItems);
            this.checkAnimals = new PC_GresCheckBox(PC_Lang.tr("pc.gui.teleporter.animals")).check(this.teleporter.animals);
            vg.add(this.checkAnimals);
            hg.add(vg);
            vg = new PC_GresLayoutV().setMinWidth(100).setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            this.checkMobs = new PC_GresCheckBox(PC_Lang.tr("pc.gui.teleporter.monsters")).check(this.teleporter.monsters);
            vg.add(this.checkMobs);
            this.checkPlayers = new PC_GresCheckBox(PC_Lang.tr("pc.gui.teleporter.players")).check(this.teleporter.players);
            vg.add(this.checkPlayers);
            hg.add(vg);
            vg1.add(hg);
            this.checkSneak = new PC_GresCheckBox(PC_Lang.tr("pc.gui.teleporter.sneak")).check(this.teleporter.sneakTrigger);
            vg1.add(this.checkSneak);
            w.add(vg1);
        } else if (this.type == 2) {
            PC_GresRadioButton.PC_GresRadioGroup group = new PC_GresRadioButton.PC_GresRadioGroup();
            PC_GresWidget vg1 = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            vg1.add(new PC_GresLabel(PC_Lang.tr("pc.gui.teleporter.outputDirection")));
            hg = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            vg = new PC_GresLayoutV().setMinWidth(100).setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            this.checkN = new PC_GresRadioButton(PC_Lang.tr("pc.gui.teleporter.dir.north"), group).check(this.teleporter.direction.equals("N"));
            vg.add(this.checkN);
            this.checkS = new PC_GresRadioButton(PC_Lang.tr("pc.gui.teleporter.dir.south"), group).check(this.teleporter.direction.equals("S"));
            vg.add(this.checkS);
            hg.add(vg);
            vg = new PC_GresLayoutV().setMinWidth(100).setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
            this.checkE = new PC_GresRadioButton(PC_Lang.tr("pc.gui.teleporter.dir.east"), group).check(this.teleporter.direction.equals("E"));
            vg.add(this.checkE);
            this.checkW = new PC_GresRadioButton(PC_Lang.tr("pc.gui.teleporter.dir.west"), group).check(this.teleporter.direction.equals("W"));
            vg.add(this.checkW);
            hg.add(vg);
            vg1.add(hg);
            w.add(vg1);
        }
        hg = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.buttonCancel = new PC_GresButton(PC_Lang.tr("pc.gui.cancel")).setId(1);
        hg.add(this.buttonCancel);
        this.buttonOK = new PC_GresButton(PC_Lang.tr("pc.gui.ok")).setId(0);
        hg.add(this.buttonOK);
        w.add(hg);
        gui.add(w);
        gui.setCanShiftTransfer(false);
        this.actionPerformed(this.edit, gui);
    }

    @Override
    public void onGuiClosed(PC_IGresGui gui) {
    }

    @Override
    public void actionPerformed(PC_GresWidget widget, PC_IGresGui gui) {
        if (widget == this.buttonCancel) {
            gui.close();
        } else if (widget == this.buttonOK) {
            if (!this.edit.getText().equals("")) {
                if (this.type == 1) {
                    this.teleporter.target = new String(this.edit.getText());
                    PC_Logger.finest("setting target to " + this.edit.getText());
                } else {
                    if (this.isnew) {
                        PCtr_TeleporterHelper.registerNewDevice(this.teleporter.xCoord, this.teleporter.yCoord, this.teleporter.zCoord, this.edit.getText());
                    } else {
                        PCtr_TeleporterHelper.renameDevice(this.teleporter.identifier, this.edit.getText());
                    }
                    this.teleporter.identifier = new String(this.edit.getText());
                    PC_Logger.finest("setting id to " + this.edit.getText());
                }
            } else {
                return;
            }
            if (this.type == 1) {
                this.teleporter.items = this.checkItems.isChecked();
                this.teleporter.animals = this.checkAnimals.isChecked();
                this.teleporter.monsters = this.checkMobs.isChecked();
                this.teleporter.players = this.checkPlayers.isChecked();
                this.teleporter.sneakTrigger = this.checkSneak.isChecked();
            } else if (this.type == 2) {
                if (this.checkN.isChecked()) {
                    this.teleporter.direction = "N";
                }
                if (this.checkS.isChecked()) {
                    this.teleporter.direction = "S";
                }
                if (this.checkE.isChecked()) {
                    this.teleporter.direction = "E";
                }
                if (this.checkW.isChecked()) {
                    this.teleporter.direction = "W";
                }
            }
            this.teleporter.onInventoryChanged();
            this.teleporter.worldObj.markBlocksDirty(this.teleporter.xCoord, this.teleporter.yCoord, this.teleporter.zCoord, this.teleporter.xCoord, this.teleporter.yCoord, this.teleporter.zCoord);
            this.teleporter.worldObj.markBlockNeedsUpdate(this.teleporter.xCoord, this.teleporter.yCoord, this.teleporter.zCoord);
            gui.close();
        } else if (widget == this.edit) {
            boolean valid = true;
            if (this.type == 2) {
                if (PCtr_TeleporterHelper.targetExistsExcept(this.edit.getText(), this.teleporter.getCoord())) {
                    this.error = PC_Lang.tr("pc.gui.teleporter.errIdUsed");
                    valid = false;
                } else if (this.edit.getText().equals("")) {
                    this.error = PC_Lang.tr("pc.gui.teleporter.errIdRequired");
                    valid = false;
                } else {
                    this.error = "";
                }
            } else if (this.type == 1) {
                if (!PCtr_TeleporterHelper.targetExistsExcept(this.edit.getText(), this.teleporter.getCoord())) {
                    this.error = PC_Lang.tr("pc.gui.teleporter.errIdNotFound");
                } else if (!PCtr_TeleporterHelper.isTargetInThisDimension(this.edit.getText())) {
                    int dim = PCtr_TeleporterHelper.getTargetDimension(this.edit.getText());
                    switch (dim) {
                        case 1: {
                            this.error = PC_Lang.tr("pc.gui.teleporter.errIdDimEnd");
                            break;
                        }
                        case 0: {
                            this.error = PC_Lang.tr("pc.gui.teleporter.errIdDimWorld");
                            break;
                        }
                        case -1: {
                            this.error = PC_Lang.tr("pc.gui.teleporter.errIdDimnether");
                            break;
                        }
                        default: {
                            this.error = PC_Lang.tr("pc.gui.teleporter.errIdDim");
                        }
                    }
                    valid = false;
                } else if (this.edit.getText().equals("")) {
                    this.error = PC_Lang.tr("pc.gui.teleporter.errTargetRequired");
                    valid = false;
                } else {
                    this.error = "";
                }
            }
            if (this.edit.getText().equals("")) {
                valid = false;
            }
            this.buttonOK.enable(valid);
            this.txError.setText(this.error);
        }
    }

    @Override
    public void onEscapePressed(PC_IGresGui gui) {
        this.actionPerformed(this.buttonCancel, gui);
    }

    @Override
    public void onReturnPressed(PC_IGresGui gui) {
        this.actionPerformed(this.buttonOK, gui);
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory) {
    }
}

