/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityDiggingFX;
import net.minecraft.src.EntityDragon;
import net.minecraft.src.EntityGhast;
import net.minecraft.src.EntityGolem;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySlime;
import net.minecraft.src.EntitySquid;
import net.minecraft.src.EntityXPOrb;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PCtr_TeleporterHelper;
import net.minecraft.src.TileEntity;

public class PCtr_TileEntityTeleporter
extends TileEntity {
    Random rand = new Random();
    private static final int SENDER = 1;
    private static final int RECEIVER = 2;
    private static final int INVALID = 0;
    public int type = 0;
    public String target = "";
    public String identifier = "";
    private boolean lastActiveState = false;
    public boolean items = true;
    public boolean animals = true;
    public boolean monsters = true;
    public boolean players = true;
    public boolean sneakTrigger = false;
    public String direction = "N";

    public PC_CoordI getCoord() {
        return new PC_CoordI(this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean canUpdate() {
        return true;
    }

    public boolean isSender() {
        return this.type == 1;
    }

    public boolean isReceiver() {
        return this.type == 2;
    }

    public void setSender() {
        this.type = 1;
    }

    public void setReceiver() {
        this.type = 2;
    }

    public void setPrimaryOutputDirection(String direction) {
        this.direction = direction;
    }

    public boolean isActive() {
        boolean active = false;
        if (this.type == 1) {
            active = !this.target.equals("") && PCtr_TeleporterHelper.targetExists(this.target);
        } else if (this.type == 2) {
            boolean bl = active = !this.identifier.equals("") && PCtr_TeleporterHelper.targetExists(this.identifier);
        }
        if (active != this.lastActiveState) {
            this.worldObj.markBlocksDirty(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.markBlockNeedsUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.lastActiveState = active;
        }
        return active;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.target = nbttagcompound.getString("tptarget");
        this.identifier = nbttagcompound.getString("tpidentifier");
        this.type = nbttagcompound.getInteger("tptype");
        this.items = nbttagcompound.getBoolean("tpaitems");
        this.monsters = nbttagcompound.getBoolean("tpamonsters");
        this.animals = nbttagcompound.getBoolean("tpaanimals");
        this.players = nbttagcompound.getBoolean("tpaplayers");
        this.direction = nbttagcompound.getString("tpdir");
        this.sneakTrigger = nbttagcompound.getBoolean("tpsneak");
        if (!nbttagcompound.getBoolean("tp_flag_28")) {
            this.items = true;
            this.monsters = true;
            this.animals = true;
            this.players = true;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setString("tpidentifier", this.identifier);
        nbttagcompound.setString("tptarget", this.target);
        nbttagcompound.setInteger("tptype", this.type);
        nbttagcompound.setBoolean("tpaitems", this.items);
        nbttagcompound.setBoolean("tpamonsters", this.monsters);
        nbttagcompound.setBoolean("tpaanimals", this.animals);
        nbttagcompound.setBoolean("tpaplayers", this.players);
        nbttagcompound.setBoolean("tpsneak", this.sneakTrigger);
        nbttagcompound.setString("tpdir", this.direction);
        nbttagcompound.setBoolean("tp_flag_28", true);
    }

    public boolean acceptsEntity(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof EntityDiggingFX) {
            return false;
        }
        if ((entity instanceof EntityAnimal || entity instanceof EntitySquid || entity instanceof EntitySlime) && !this.animals) {
            return false;
        }
        if ((entity instanceof EntityMob || entity instanceof EntityGhast || entity instanceof EntityDragon || entity instanceof EntityGolem) && !this.monsters) {
            return false;
        }
        if ((entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityArrow) && !this.items) {
            return false;
        }
        if (entity instanceof EntityPlayer && !this.players) {
            return false;
        }
        return !(entity instanceof EntityPlayer) || entity.isSneaking() || !this.sneakTrigger;
    }
}

