/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet20NamedEntitySpawn
extends Packet {
    public int entityId;
    public String name;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte rotation;
    public byte pitch;
    public int currentItem;

    public Packet20NamedEntitySpawn() {
    }

    public Packet20NamedEntitySpawn(EntityPlayer par1EntityPlayer) {
        this.entityId = par1EntityPlayer.entityId;
        this.name = par1EntityPlayer.username;
        this.xPosition = MathHelper.floor_double(par1EntityPlayer.posX * 32.0);
        this.yPosition = MathHelper.floor_double(par1EntityPlayer.posY * 32.0);
        this.zPosition = MathHelper.floor_double(par1EntityPlayer.posZ * 32.0);
        this.rotation = (byte)(par1EntityPlayer.rotationYaw * 256.0f / 360.0f);
        this.pitch = (byte)(par1EntityPlayer.rotationPitch * 256.0f / 360.0f);
        ItemStack itemstack = par1EntityPlayer.inventory.getCurrentItem();
        this.currentItem = itemstack != null ? itemstack.itemID : 0;
    }

    @Override
    public void readPacketData(DataInputStream par1DataInputStream) throws IOException {
        this.entityId = par1DataInputStream.readInt();
        this.name = Packet20NamedEntitySpawn.readString(par1DataInputStream, 16);
        this.xPosition = par1DataInputStream.readInt();
        this.yPosition = par1DataInputStream.readInt();
        this.zPosition = par1DataInputStream.readInt();
        this.rotation = par1DataInputStream.readByte();
        this.pitch = par1DataInputStream.readByte();
        this.currentItem = par1DataInputStream.readShort();
    }

    @Override
    public void writePacketData(DataOutputStream par1DataOutputStream) throws IOException {
        par1DataOutputStream.writeInt(this.entityId);
        Packet20NamedEntitySpawn.writeString(this.name, par1DataOutputStream);
        par1DataOutputStream.writeInt(this.xPosition);
        par1DataOutputStream.writeInt(this.yPosition);
        par1DataOutputStream.writeInt(this.zPosition);
        par1DataOutputStream.writeByte(this.rotation);
        par1DataOutputStream.writeByte(this.pitch);
        par1DataOutputStream.writeShort(this.currentItem);
    }

    @Override
    public void processPacket(NetHandler par1NetHandler) {
        par1NetHandler.handleNamedEntitySpawn(this);
    }

    @Override
    public int getPacketSize() {
        return 28;
    }
}

