/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.src.DataWatcher;
import net.minecraft.src.EntityList;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet24MobSpawn
extends Packet {
    public int entityId;
    public int type;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte yaw;
    public byte pitch;
    public byte field_48169_h;
    private DataWatcher metaData;
    private List receivedMetadata;

    public Packet24MobSpawn() {
    }

    public Packet24MobSpawn(EntityLiving par1EntityLiving) {
        this.entityId = par1EntityLiving.entityId;
        this.type = (byte)EntityList.getEntityID(par1EntityLiving);
        this.xPosition = MathHelper.floor_double(par1EntityLiving.posX * 32.0);
        this.yPosition = MathHelper.floor_double(par1EntityLiving.posY * 32.0);
        this.zPosition = MathHelper.floor_double(par1EntityLiving.posZ * 32.0);
        this.yaw = (byte)(par1EntityLiving.rotationYaw * 256.0f / 360.0f);
        this.pitch = (byte)(par1EntityLiving.rotationPitch * 256.0f / 360.0f);
        this.field_48169_h = (byte)(par1EntityLiving.rotationYawHead * 256.0f / 360.0f);
        this.metaData = par1EntityLiving.getDataWatcher();
    }

    @Override
    public void readPacketData(DataInputStream par1DataInputStream) throws IOException {
        this.entityId = par1DataInputStream.readInt();
        this.type = par1DataInputStream.readByte() & 0xFF;
        this.xPosition = par1DataInputStream.readInt();
        this.yPosition = par1DataInputStream.readInt();
        this.zPosition = par1DataInputStream.readInt();
        this.yaw = par1DataInputStream.readByte();
        this.pitch = par1DataInputStream.readByte();
        this.field_48169_h = par1DataInputStream.readByte();
        this.receivedMetadata = DataWatcher.readWatchableObjects(par1DataInputStream);
    }

    @Override
    public void writePacketData(DataOutputStream par1DataOutputStream) throws IOException {
        par1DataOutputStream.writeInt(this.entityId);
        par1DataOutputStream.writeByte(this.type & 0xFF);
        par1DataOutputStream.writeInt(this.xPosition);
        par1DataOutputStream.writeInt(this.yPosition);
        par1DataOutputStream.writeInt(this.zPosition);
        par1DataOutputStream.writeByte(this.yaw);
        par1DataOutputStream.writeByte(this.pitch);
        par1DataOutputStream.writeByte(this.field_48169_h);
        this.metaData.writeWatchableObjects(par1DataOutputStream);
    }

    @Override
    public void processPacket(NetHandler par1NetHandler) {
        par1NetHandler.handleMobSpawn(this);
    }

    @Override
    public int getPacketSize() {
        return 20;
    }

    public List getMetadata() {
        return this.receivedMetadata;
    }
}

