/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet51MapChunk
extends Packet {
    public int xCh;
    public int zCh;
    public int yChMin;
    public int yChMax;
    public byte[] chunkData;
    public boolean includeInitialize;
    private int tempLength;
    private int field_48178_h;
    private static byte[] temp = new byte[0];

    public Packet51MapChunk() {
        this.isChunkDataPacket = true;
    }

    @Override
    public void readPacketData(DataInputStream par1DataInputStream) throws IOException {
        this.xCh = par1DataInputStream.readInt();
        this.zCh = par1DataInputStream.readInt();
        this.includeInitialize = par1DataInputStream.readBoolean();
        this.yChMin = par1DataInputStream.readShort();
        this.yChMax = par1DataInputStream.readShort();
        this.tempLength = par1DataInputStream.readInt();
        this.field_48178_h = par1DataInputStream.readInt();
        if (temp.length < this.tempLength) {
            temp = new byte[this.tempLength];
        }
        par1DataInputStream.readFully(temp, 0, this.tempLength);
        int i = 0;
        for (int j = 0; j < 16; ++j) {
            i += this.yChMin >> j & 1;
        }
        int k = 12288 * i;
        if (this.includeInitialize) {
            k += 256;
        }
        this.chunkData = new byte[k];
        Inflater inflater = new Inflater();
        inflater.setInput(temp, 0, this.tempLength);
        try {
            inflater.inflate(this.chunkData);
        }
        catch (DataFormatException dataformatexception) {
            throw new IOException("Bad compressed data format");
        }
        finally {
            inflater.end();
        }
    }

    @Override
    public void writePacketData(DataOutputStream par1DataOutputStream) throws IOException {
        par1DataOutputStream.writeInt(this.xCh);
        par1DataOutputStream.writeInt(this.zCh);
        par1DataOutputStream.writeBoolean(this.includeInitialize);
        par1DataOutputStream.writeShort((short)(this.yChMin & 0xFFFF));
        par1DataOutputStream.writeShort((short)(this.yChMax & 0xFFFF));
        par1DataOutputStream.writeInt(this.tempLength);
        par1DataOutputStream.writeInt(this.field_48178_h);
        par1DataOutputStream.write(this.chunkData, 0, this.tempLength);
    }

    @Override
    public void processPacket(NetHandler par1NetHandler) {
        par1NetHandler.func_48487_a(this);
    }

    @Override
    public int getPacketSize() {
        return 17 + this.tempLength;
    }
}

