/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;
import net.minecraft.src.WorldType;

public class Packet9Respawn
extends Packet {
    public int respawnDimension;
    public int difficulty;
    public int worldHeight;
    public int creativeMode;
    public WorldType terrainType;

    public Packet9Respawn() {
    }

    public Packet9Respawn(int par1, byte par2, WorldType par3WorldType, int par4, int par5) {
        this.respawnDimension = par1;
        this.difficulty = par2;
        this.worldHeight = par4;
        this.creativeMode = par5;
        this.terrainType = par3WorldType;
    }

    @Override
    public void processPacket(NetHandler par1NetHandler) {
        par1NetHandler.handleRespawn(this);
    }

    @Override
    public void readPacketData(DataInputStream par1DataInputStream) throws IOException {
        this.respawnDimension = par1DataInputStream.readInt();
        this.difficulty = par1DataInputStream.readByte();
        this.creativeMode = par1DataInputStream.readByte();
        this.worldHeight = par1DataInputStream.readShort();
        String s = Packet9Respawn.readString(par1DataInputStream, 16);
        this.terrainType = WorldType.parseWorldType(s);
        if (this.terrainType == null) {
            this.terrainType = WorldType.DEFAULT;
        }
    }

    @Override
    public void writePacketData(DataOutputStream par1DataOutputStream) throws IOException {
        par1DataOutputStream.writeInt(this.respawnDimension);
        par1DataOutputStream.writeByte(this.difficulty);
        par1DataOutputStream.writeByte(this.creativeMode);
        par1DataOutputStream.writeShort(this.worldHeight);
        Packet9Respawn.writeString(this.terrainType.func_48628_a(), par1DataOutputStream);
    }

    @Override
    public int getPacketSize() {
        return 8 + this.terrainType.func_48628_a().length();
    }
}

