/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.PathPoint;
import net.minecraft.src.Vec3D;

public class PathEntity {
    private final PathPoint[] points;
    private int currentPathIndex;
    private int pathLength;

    public PathEntity(PathPoint[] par1ArrayOfPathPoint) {
        this.points = par1ArrayOfPathPoint;
        this.pathLength = par1ArrayOfPathPoint.length;
    }

    public void incrementPathIndex() {
        ++this.currentPathIndex;
    }

    public boolean isFinished() {
        return this.currentPathIndex >= this.pathLength;
    }

    public PathPoint getFinalPathPoint() {
        if (this.pathLength > 0) {
            return this.points[this.pathLength - 1];
        }
        return null;
    }

    public PathPoint getPathPointFromIndex(int par1) {
        return this.points[par1];
    }

    public int getCurrentPathLength() {
        return this.pathLength;
    }

    public void setCurrentPathLength(int par1) {
        this.pathLength = par1;
    }

    public int getCurrentPathIndex() {
        return this.currentPathIndex;
    }

    public void setCurrentPathIndex(int par1) {
        this.currentPathIndex = par1;
    }

    public Vec3D getVectorFromIndex(Entity par1Entity, int par2) {
        double d = (double)this.points[par2].xCoord + (double)((int)(par1Entity.width + 1.0f)) * 0.5;
        double d1 = this.points[par2].yCoord;
        double d2 = (double)this.points[par2].zCoord + (double)((int)(par1Entity.width + 1.0f)) * 0.5;
        return Vec3D.createVector(d, d1, d2);
    }

    public Vec3D getCurrentNodeVec3d(Entity par1Entity) {
        return this.getVectorFromIndex(par1Entity, this.currentPathIndex);
    }

    public boolean func_48647_a(PathEntity par1PathEntity) {
        if (par1PathEntity == null) {
            return false;
        }
        if (par1PathEntity.points.length != this.points.length) {
            return false;
        }
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i].xCoord == par1PathEntity.points[i].xCoord && this.points[i].yCoord == par1PathEntity.points[i].yCoord && this.points[i].zCoord == par1PathEntity.points[i].zCoord) continue;
            return false;
        }
        return true;
    }

    public boolean func_48639_a(Vec3D par1Vec3D) {
        PathPoint pathpoint = this.getFinalPathPoint();
        if (pathpoint == null) {
            return false;
        }
        return pathpoint.xCoord == (int)par1Vec3D.xCoord && pathpoint.zCoord == (int)par1Vec3D.zCoord;
    }
}

