/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.IntHashMap;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Path;
import net.minecraft.src.PathEntity;
import net.minecraft.src.PathPoint;

public class PathFinder {
    private IBlockAccess worldMap;
    private Path path = new Path();
    private IntHashMap pointMap = new IntHashMap();
    private PathPoint[] pathOptions = new PathPoint[32];
    private boolean isWoddenDoorAllowed;
    private boolean isMovementBlockAllowed;
    private boolean isPathingInWater;
    private boolean canEntityDrown;

    public PathFinder(IBlockAccess par1IBlockAccess, boolean par2, boolean par3, boolean par4, boolean par5) {
        this.worldMap = par1IBlockAccess;
        this.isWoddenDoorAllowed = par2;
        this.isMovementBlockAllowed = par3;
        this.isPathingInWater = par4;
        this.canEntityDrown = par5;
    }

    public PathEntity createEntityPathTo(Entity par1Entity, Entity par2Entity, float par3) {
        return this.createEntityPathTo(par1Entity, par2Entity.posX, par2Entity.boundingBox.minY, par2Entity.posZ, par3);
    }

    public PathEntity createEntityPathTo(Entity par1Entity, int par2, int par3, int par4, float par5) {
        return this.createEntityPathTo(par1Entity, (float)par2 + 0.5f, (float)par3 + 0.5f, (float)par4 + 0.5f, par5);
    }

    private PathEntity createEntityPathTo(Entity par1Entity, double par2, double par4, double par6, float par8) {
        this.path.clearPath();
        this.pointMap.clearMap();
        boolean flag = this.isPathingInWater;
        int i = MathHelper.floor_double(par1Entity.boundingBox.minY + 0.5);
        if (this.canEntityDrown && par1Entity.isInWater()) {
            i = (int)par1Entity.boundingBox.minY;
            int j = this.worldMap.getBlockId(MathHelper.floor_double(par1Entity.posX), i, MathHelper.floor_double(par1Entity.posZ));
            while (j == Block.waterMoving.blockID || j == Block.waterStill.blockID) {
                j = this.worldMap.getBlockId(MathHelper.floor_double(par1Entity.posX), ++i, MathHelper.floor_double(par1Entity.posZ));
            }
            flag = this.isPathingInWater;
            this.isPathingInWater = false;
        } else {
            i = MathHelper.floor_double(par1Entity.boundingBox.minY + 0.5);
        }
        PathPoint pathpoint = this.openPoint(MathHelper.floor_double(par1Entity.boundingBox.minX), i, MathHelper.floor_double(par1Entity.boundingBox.minZ));
        PathPoint pathpoint1 = this.openPoint(MathHelper.floor_double(par2 - (double)(par1Entity.width / 2.0f)), MathHelper.floor_double(par4), MathHelper.floor_double(par6 - (double)(par1Entity.width / 2.0f)));
        PathPoint pathpoint2 = new PathPoint(MathHelper.floor_float(par1Entity.width + 1.0f), MathHelper.floor_float(par1Entity.height + 1.0f), MathHelper.floor_float(par1Entity.width + 1.0f));
        PathEntity pathentity = this.addToPath(par1Entity, pathpoint, pathpoint1, pathpoint2, par8);
        this.isPathingInWater = flag;
        return pathentity;
    }

    private PathEntity addToPath(Entity par1Entity, PathPoint par2PathPoint, PathPoint par3PathPoint, PathPoint par4PathPoint, float par5) {
        par2PathPoint.totalPathDistance = 0.0f;
        par2PathPoint.distanceToTarget = par2PathPoint.distanceToNext = par2PathPoint.distanceTo(par3PathPoint);
        this.path.clearPath();
        this.path.addPoint(par2PathPoint);
        PathPoint pathpoint = par2PathPoint;
        while (!this.path.isPathEmpty()) {
            PathPoint pathpoint1 = this.path.dequeue();
            if (pathpoint1.equals(par3PathPoint)) {
                return this.createEntityPath(par2PathPoint, par3PathPoint);
            }
            if (pathpoint1.distanceTo(par3PathPoint) < pathpoint.distanceTo(par3PathPoint)) {
                pathpoint = pathpoint1;
            }
            pathpoint1.isFirst = true;
            int i = this.findPathOptions(par1Entity, pathpoint1, par4PathPoint, par3PathPoint, par5);
            for (int j = 0; j < i; ++j) {
                PathPoint pathpoint2 = this.pathOptions[j];
                float f = pathpoint1.totalPathDistance + pathpoint1.distanceTo(pathpoint2);
                if (pathpoint2.isAssigned() && !(f < pathpoint2.totalPathDistance)) continue;
                pathpoint2.previous = pathpoint1;
                pathpoint2.totalPathDistance = f;
                pathpoint2.distanceToNext = pathpoint2.distanceTo(par3PathPoint);
                if (pathpoint2.isAssigned()) {
                    this.path.changeDistance(pathpoint2, pathpoint2.totalPathDistance + pathpoint2.distanceToNext);
                    continue;
                }
                pathpoint2.distanceToTarget = pathpoint2.totalPathDistance + pathpoint2.distanceToNext;
                this.path.addPoint(pathpoint2);
            }
        }
        if (pathpoint == par2PathPoint) {
            return null;
        }
        return this.createEntityPath(par2PathPoint, pathpoint);
    }

    private int findPathOptions(Entity par1Entity, PathPoint par2PathPoint, PathPoint par3PathPoint, PathPoint par4PathPoint, float par5) {
        int i = 0;
        int j = 0;
        if (this.getVerticalOffset(par1Entity, par2PathPoint.xCoord, par2PathPoint.yCoord + 1, par2PathPoint.zCoord, par3PathPoint) == 1) {
            j = 1;
        }
        PathPoint pathpoint = this.getSafePoint(par1Entity, par2PathPoint.xCoord, par2PathPoint.yCoord, par2PathPoint.zCoord + 1, par3PathPoint, j);
        PathPoint pathpoint1 = this.getSafePoint(par1Entity, par2PathPoint.xCoord - 1, par2PathPoint.yCoord, par2PathPoint.zCoord, par3PathPoint, j);
        PathPoint pathpoint2 = this.getSafePoint(par1Entity, par2PathPoint.xCoord + 1, par2PathPoint.yCoord, par2PathPoint.zCoord, par3PathPoint, j);
        PathPoint pathpoint3 = this.getSafePoint(par1Entity, par2PathPoint.xCoord, par2PathPoint.yCoord, par2PathPoint.zCoord - 1, par3PathPoint, j);
        if (pathpoint != null && !pathpoint.isFirst && pathpoint.distanceTo(par4PathPoint) < par5) {
            this.pathOptions[i++] = pathpoint;
        }
        if (pathpoint1 != null && !pathpoint1.isFirst && pathpoint1.distanceTo(par4PathPoint) < par5) {
            this.pathOptions[i++] = pathpoint1;
        }
        if (pathpoint2 != null && !pathpoint2.isFirst && pathpoint2.distanceTo(par4PathPoint) < par5) {
            this.pathOptions[i++] = pathpoint2;
        }
        if (pathpoint3 != null && !pathpoint3.isFirst && pathpoint3.distanceTo(par4PathPoint) < par5) {
            this.pathOptions[i++] = pathpoint3;
        }
        return i;
    }

    private PathPoint getSafePoint(Entity par1Entity, int par2, int par3, int par4, PathPoint par5PathPoint, int par6) {
        PathPoint pathpoint = null;
        int i = this.getVerticalOffset(par1Entity, par2, par3, par4, par5PathPoint);
        if (i == 2) {
            return this.openPoint(par2, par3, par4);
        }
        if (i == 1) {
            pathpoint = this.openPoint(par2, par3, par4);
        }
        if (pathpoint == null && par6 > 0 && i != -3 && i != -4 && this.getVerticalOffset(par1Entity, par2, par3 + par6, par4, par5PathPoint) == 1) {
            pathpoint = this.openPoint(par2, par3 + par6, par4);
            par3 += par6;
        }
        if (pathpoint != null) {
            int j = 0;
            int k = 0;
            while (par3 > 0) {
                k = this.getVerticalOffset(par1Entity, par2, par3 - 1, par4, par5PathPoint);
                if (this.isPathingInWater && k == -1) {
                    return null;
                }
                if (k != 1) break;
                if (++j >= 4) {
                    return null;
                }
                if (--par3 <= 0) continue;
                pathpoint = this.openPoint(par2, par3, par4);
            }
            if (k == -2) {
                return null;
            }
        }
        return pathpoint;
    }

    private final PathPoint openPoint(int par1, int par2, int par3) {
        int i = PathPoint.makeHash(par1, par2, par3);
        PathPoint pathpoint = (PathPoint)this.pointMap.lookup(i);
        if (pathpoint == null) {
            pathpoint = new PathPoint(par1, par2, par3);
            this.pointMap.addKey(i, pathpoint);
        }
        return pathpoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getVerticalOffset(Entity par1Entity, int par2, int par3, int par4, PathPoint par5PathPoint) {
        boolean flag = false;
        for (int i = par2; i < par2 + par5PathPoint.xCoord; ++i) {
            for (int j = par3; j < par3 + par5PathPoint.yCoord; ++j) {
                for (int k = par4; k < par4 + par5PathPoint.zCoord; ++k) {
                    int l = this.worldMap.getBlockId(i, j, k);
                    if (l <= 0) continue;
                    if (l == Block.trapdoor.blockID) {
                        flag = true;
                    } else if (l == Block.waterMoving.blockID || l == Block.waterStill.blockID) {
                        if (this.isPathingInWater) return -1;
                        flag = true;
                    } else if (!this.isWoddenDoorAllowed && l == Block.doorWood.blockID) {
                        return 0;
                    }
                    Block block = Block.blocksList[l];
                    if (block.getBlocksMovement(this.worldMap, i, j, k) || this.isMovementBlockAllowed && l == Block.doorWood.blockID) continue;
                    if (l == Block.fence.blockID) return -3;
                    if (l == Block.fenceGate.blockID) {
                        return -3;
                    }
                    if (l == Block.trapdoor.blockID) {
                        return -4;
                    }
                    Material material = block.blockMaterial;
                    if (material != Material.lava) return 0;
                    if (par1Entity.handleLavaMovement()) continue;
                    return -2;
                }
            }
        }
        if (!flag) return 1;
        return 2;
    }

    private PathEntity createEntityPath(PathPoint par1PathPoint, PathPoint par2PathPoint) {
        int i = 1;
        PathPoint pathpoint = par2PathPoint;
        while (pathpoint.previous != null) {
            ++i;
            pathpoint = pathpoint.previous;
        }
        PathPoint[] apathpoint = new PathPoint[i];
        PathPoint pathpoint1 = par2PathPoint;
        apathpoint[--i] = pathpoint1;
        while (pathpoint1.previous != null) {
            pathpoint1 = pathpoint1.previous;
            apathpoint[--i] = pathpoint1;
        }
        return new PathEntity(apathpoint);
    }
}

