/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PathEntity;
import net.minecraft.src.PathPoint;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class PathNavigate {
    private EntityLiving theEntity;
    private World worldObj;
    private PathEntity currentPath;
    private float speed;
    private float pathSearchRange;
    private boolean noSunPathfind = false;
    private int totalTicks;
    private int ticksAtLastPos;
    private Vec3D lastPosCheck = Vec3D.createVectorHelper(0.0, 0.0, 0.0);
    private boolean canPassOpenWoodenDoors = true;
    private boolean canPassClosedWoodenDoors = false;
    private boolean avoidsWater = false;
    private boolean canSwim = false;

    public PathNavigate(EntityLiving par1EntityLiving, World par2World, float par3) {
        this.theEntity = par1EntityLiving;
        this.worldObj = par2World;
        this.pathSearchRange = par3;
    }

    public void setAvoidsWater(boolean par1) {
        this.avoidsWater = par1;
    }

    public boolean getAvoidsWater() {
        return this.avoidsWater;
    }

    public void setBreakDoors(boolean par1) {
        this.canPassClosedWoodenDoors = par1;
    }

    public void setEnterDoors(boolean par1) {
        this.canPassOpenWoodenDoors = par1;
    }

    public boolean getCanBreakDoors() {
        return this.canPassClosedWoodenDoors;
    }

    public void setAvoidSun(boolean par1) {
        this.noSunPathfind = par1;
    }

    public void setSpeed(float par1) {
        this.speed = par1;
    }

    public void setCanSwim(boolean par1) {
        this.canSwim = par1;
    }

    public PathEntity getPathToXYZ(double par1, double par3, double par5) {
        if (!this.canNavigate()) {
            return null;
        }
        return this.worldObj.getEntityPathToXYZ(this.theEntity, MathHelper.floor_double(par1), (int)par3, MathHelper.floor_double(par5), this.pathSearchRange, this.canPassOpenWoodenDoors, this.canPassClosedWoodenDoors, this.avoidsWater, this.canSwim);
    }

    public boolean tryMoveToXYZ(double par1, double par3, double par5, float par7) {
        PathEntity pathentity = this.getPathToXYZ(MathHelper.floor_double(par1), (int)par3, MathHelper.floor_double(par5));
        return this.setPath(pathentity, par7);
    }

    public PathEntity func_48679_a(EntityLiving par1EntityLiving) {
        if (!this.canNavigate()) {
            return null;
        }
        return this.worldObj.getPathEntityToEntity(this.theEntity, par1EntityLiving, this.pathSearchRange, this.canPassOpenWoodenDoors, this.canPassClosedWoodenDoors, this.avoidsWater, this.canSwim);
    }

    public boolean func_48667_a(EntityLiving par1EntityLiving, float par2) {
        PathEntity pathentity = this.func_48679_a(par1EntityLiving);
        if (pathentity != null) {
            return this.setPath(pathentity, par2);
        }
        return false;
    }

    public boolean setPath(PathEntity par1PathEntity, float par2) {
        if (par1PathEntity == null) {
            this.currentPath = null;
            return false;
        }
        if (!par1PathEntity.func_48647_a(this.currentPath)) {
            this.currentPath = par1PathEntity;
        }
        if (this.noSunPathfind) {
            this.removeSunnyPath();
        }
        if (this.currentPath.getCurrentPathLength() == 0) {
            return false;
        }
        this.speed = par2;
        Vec3D vec3d = this.getEntityPosition();
        this.ticksAtLastPos = this.totalTicks;
        this.lastPosCheck.xCoord = vec3d.xCoord;
        this.lastPosCheck.yCoord = vec3d.yCoord;
        this.lastPosCheck.zCoord = vec3d.zCoord;
        return true;
    }

    public PathEntity getPath() {
        return this.currentPath;
    }

    public void onUpdateNavigation() {
        ++this.totalTicks;
        if (this.noPath()) {
            return;
        }
        if (this.canNavigate()) {
            this.pathFollow();
        }
        if (this.noPath()) {
            return;
        }
        Vec3D vec3d = this.currentPath.getCurrentNodeVec3d(this.theEntity);
        if (vec3d == null) {
            return;
        }
        this.theEntity.getMoveHelper().setMoveTo(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord, this.speed);
    }

    private void pathFollow() {
        Vec3D vec3d = this.getEntityPosition();
        int i = this.currentPath.getCurrentPathLength();
        for (int i2 = this.currentPath.getCurrentPathIndex(); i2 < this.currentPath.getCurrentPathLength(); ++i2) {
            if (this.currentPath.getPathPointFromIndex((int)i2).yCoord == (int)vec3d.yCoord) continue;
            i = i2;
            break;
        }
        float f = this.theEntity.width * this.theEntity.width;
        for (int j = this.currentPath.getCurrentPathIndex(); j < i; ++j) {
            if (!(vec3d.squareDistanceTo(this.currentPath.getVectorFromIndex(this.theEntity, j)) < (double)f)) continue;
            this.currentPath.setCurrentPathIndex(j + 1);
        }
        int k = (int)Math.ceil(this.theEntity.width);
        int l = (int)this.theEntity.height + 1;
        int i1 = k;
        for (int j1 = i - 1; j1 >= this.currentPath.getCurrentPathIndex(); --j1) {
            if (!this.isDirectPathBetweenPoints(vec3d, this.currentPath.getVectorFromIndex(this.theEntity, j1), k, l, i1)) continue;
            this.currentPath.setCurrentPathIndex(j1);
            break;
        }
        if (this.totalTicks - this.ticksAtLastPos > 100) {
            if (vec3d.squareDistanceTo(this.lastPosCheck) < 2.25) {
                this.clearPathEntity();
            }
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck.xCoord = vec3d.xCoord;
            this.lastPosCheck.yCoord = vec3d.yCoord;
            this.lastPosCheck.zCoord = vec3d.zCoord;
        }
    }

    public boolean noPath() {
        return this.currentPath == null || this.currentPath.isFinished();
    }

    public void clearPathEntity() {
        this.currentPath = null;
    }

    private Vec3D getEntityPosition() {
        return Vec3D.createVector(this.theEntity.posX, this.getPathableYPos(), this.theEntity.posZ);
    }

    private int getPathableYPos() {
        if (!this.theEntity.isInWater() || !this.canSwim) {
            return (int)(this.theEntity.boundingBox.minY + 0.5);
        }
        int i = (int)this.theEntity.boundingBox.minY;
        int j = this.worldObj.getBlockId(MathHelper.floor_double(this.theEntity.posX), i, MathHelper.floor_double(this.theEntity.posZ));
        int k = 0;
        while (j == Block.waterMoving.blockID || j == Block.waterStill.blockID) {
            j = this.worldObj.getBlockId(MathHelper.floor_double(this.theEntity.posX), ++i, MathHelper.floor_double(this.theEntity.posZ));
            if (++k <= 16) continue;
            return (int)this.theEntity.boundingBox.minY;
        }
        return i;
    }

    private boolean canNavigate() {
        return this.theEntity.onGround || this.canSwim && this.isInFluid();
    }

    private boolean isInFluid() {
        return this.theEntity.isInWater() || this.theEntity.handleLavaMovement();
    }

    private void removeSunnyPath() {
        if (this.worldObj.canBlockSeeTheSky(MathHelper.floor_double(this.theEntity.posX), (int)(this.theEntity.boundingBox.minY + 0.5), MathHelper.floor_double(this.theEntity.posZ))) {
            return;
        }
        for (int i = 0; i < this.currentPath.getCurrentPathLength(); ++i) {
            PathPoint pathpoint = this.currentPath.getPathPointFromIndex(i);
            if (!this.worldObj.canBlockSeeTheSky(pathpoint.xCoord, pathpoint.yCoord, pathpoint.zCoord)) continue;
            this.currentPath.setCurrentPathLength(i - 1);
            return;
        }
    }

    private boolean isDirectPathBetweenPoints(Vec3D par1Vec3D, Vec3D par2Vec3D, int par3, int par4, int par5) {
        int i = MathHelper.floor_double(par1Vec3D.xCoord);
        int j = MathHelper.floor_double(par1Vec3D.zCoord);
        double d = par2Vec3D.xCoord - par1Vec3D.xCoord;
        double d1 = par2Vec3D.zCoord - par1Vec3D.zCoord;
        double d2 = d * d + d1 * d1;
        if (d2 < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(d2);
        if (!this.isSafeToStandAt(i, (int)par1Vec3D.yCoord, j, par3 += 2, par4, par5 += 2, par1Vec3D, d *= d3, d1 *= d3)) {
            return false;
        }
        par3 -= 2;
        par5 -= 2;
        double d4 = 1.0 / Math.abs(d);
        double d5 = 1.0 / Math.abs(d1);
        double d6 = (double)(i * 1) - par1Vec3D.xCoord;
        double d7 = (double)(j * 1) - par1Vec3D.zCoord;
        if (d >= 0.0) {
            d6 += 1.0;
        }
        if (d1 >= 0.0) {
            d7 += 1.0;
        }
        d6 /= d;
        d7 /= d1;
        byte byte0 = (byte)(d >= 0.0 ? 1 : -1);
        byte byte1 = (byte)(d1 >= 0.0 ? 1 : -1);
        int k = MathHelper.floor_double(par2Vec3D.xCoord);
        int l = MathHelper.floor_double(par2Vec3D.zCoord);
        int i1 = k - i;
        int j1 = l - j;
        while (i1 * byte0 > 0 || j1 * byte1 > 0) {
            if (d6 < d7) {
                d6 += d4;
                i1 = k - (i += byte0);
            } else {
                d7 += d5;
                j1 = l - (j += byte1);
            }
            if (this.isSafeToStandAt(i, (int)par1Vec3D.yCoord, j, par3, par4, par5, par1Vec3D, d, d1)) continue;
            return false;
        }
        return true;
    }

    private boolean isSafeToStandAt(int par1, int par2, int par3, int par4, int par5, int par6, Vec3D par7Vec3D, double par8, double par10) {
        int i = par1 - par4 / 2;
        int j = par3 - par6 / 2;
        if (!this.isPositionClear(i, par2, j, par4, par5, par6, par7Vec3D, par8, par10)) {
            return false;
        }
        for (int k = i; k < i + par4; ++k) {
            for (int l = j; l < j + par6; ++l) {
                double d = (double)k + 0.5 - par7Vec3D.xCoord;
                double d1 = (double)l + 0.5 - par7Vec3D.zCoord;
                if (d * par8 + d1 * par10 < 0.0) continue;
                int i1 = this.worldObj.getBlockId(k, par2 - 1, l);
                if (i1 <= 0) {
                    return false;
                }
                Material material = Block.blocksList[i1].blockMaterial;
                if (material == Material.water && !this.theEntity.isInWater()) {
                    return false;
                }
                if (material != Material.lava) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPositionClear(int par1, int par2, int par3, int par4, int par5, int par6, Vec3D par7Vec3D, double par8, double par10) {
        for (int i = par1; i < par1 + par4; ++i) {
            for (int j = par2; j < par2 + par5; ++j) {
                for (int k = par3; k < par3 + par6; ++k) {
                    int l;
                    double d = (double)i + 0.5 - par7Vec3D.xCoord;
                    double d1 = (double)k + 0.5 - par7Vec3D.zCoord;
                    if (d * par8 + d1 * par10 < 0.0 || (l = this.worldObj.getBlockId(i, j, k)) <= 0 || Block.blocksList[l].getBlocksMovement(this.worldObj, i, j, k)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

