/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityClientPlayerMP;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.Packet102WindowClick;
import net.minecraft.src.Packet107CreativeSetSlot;
import net.minecraft.src.Packet108EnchantItem;
import net.minecraft.src.Packet14BlockDig;
import net.minecraft.src.Packet15Place;
import net.minecraft.src.Packet16BlockItemSwitch;
import net.minecraft.src.Packet7UseEntity;
import net.minecraft.src.PlayerController;
import net.minecraft.src.PlayerControllerCreative;
import net.minecraft.src.World;

public class PlayerControllerMP
extends PlayerController {
    private int currentBlockX = -1;
    private int currentBlockY = -1;
    private int currentblockZ = -1;
    private float curBlockDamageMP = 0.0f;
    private float prevBlockDamageMP = 0.0f;
    private float stepSoundTickCounter = 0.0f;
    private int blockHitDelay = 0;
    private boolean isHittingBlock = false;
    private boolean creativeMode;
    private NetClientHandler netClientHandler;
    private int currentPlayerItem = 0;

    public PlayerControllerMP(Minecraft par1Minecraft, NetClientHandler par2NetClientHandler) {
        super(par1Minecraft);
        this.netClientHandler = par2NetClientHandler;
    }

    public void setCreative(boolean par1) {
        this.creativeMode = par1;
        if (this.creativeMode) {
            PlayerControllerCreative.enableAbilities(this.mc.thePlayer);
        } else {
            PlayerControllerCreative.disableAbilities(this.mc.thePlayer);
        }
    }

    @Override
    public void flipPlayer(EntityPlayer par1EntityPlayer) {
        par1EntityPlayer.rotationYaw = -180.0f;
    }

    @Override
    public boolean shouldDrawHUD() {
        return !this.creativeMode;
    }

    @Override
    public boolean onPlayerDestroyBlock(int par1, int par2, int par3, int par4) {
        if (this.creativeMode) {
            return super.onPlayerDestroyBlock(par1, par2, par3, par4);
        }
        int i = this.mc.theWorld.getBlockId(par1, par2, par3);
        boolean flag = super.onPlayerDestroyBlock(par1, par2, par3, par4);
        ItemStack itemstack = this.mc.thePlayer.getCurrentEquippedItem();
        if (itemstack != null) {
            itemstack.onDestroyBlock(i, par1, par2, par3, this.mc.thePlayer);
            if (itemstack.stackSize == 0) {
                itemstack.onItemDestroyedByUse(this.mc.thePlayer);
                this.mc.thePlayer.destroyCurrentEquippedItem();
            }
        }
        return flag;
    }

    @Override
    public void clickBlock(int par1, int par2, int par3, int par4) {
        if (this.creativeMode) {
            this.netClientHandler.addToSendQueue(new Packet14BlockDig(0, par1, par2, par3, par4));
            PlayerControllerCreative.clickBlockCreative(this.mc, this, par1, par2, par3, par4);
            this.blockHitDelay = 5;
        } else if (!this.isHittingBlock || par1 != this.currentBlockX || par2 != this.currentBlockY || par3 != this.currentblockZ) {
            this.netClientHandler.addToSendQueue(new Packet14BlockDig(0, par1, par2, par3, par4));
            int i = this.mc.theWorld.getBlockId(par1, par2, par3);
            if (i > 0 && this.curBlockDamageMP == 0.0f) {
                Block.blocksList[i].onBlockClicked(this.mc.theWorld, par1, par2, par3, this.mc.thePlayer);
            }
            if (i > 0 && Block.blocksList[i].blockStrength(this.mc.thePlayer) >= 1.0f) {
                this.onPlayerDestroyBlock(par1, par2, par3, par4);
            } else {
                this.isHittingBlock = true;
                this.currentBlockX = par1;
                this.currentBlockY = par2;
                this.currentblockZ = par3;
                this.curBlockDamageMP = 0.0f;
                this.prevBlockDamageMP = 0.0f;
                this.stepSoundTickCounter = 0.0f;
            }
        }
    }

    @Override
    public void resetBlockRemoving() {
        this.curBlockDamageMP = 0.0f;
        this.isHittingBlock = false;
    }

    @Override
    public void onPlayerDamageBlock(int par1, int par2, int par3, int par4) {
        this.syncCurrentPlayItem();
        if (this.blockHitDelay > 0) {
            --this.blockHitDelay;
            return;
        }
        if (this.creativeMode) {
            this.blockHitDelay = 5;
            this.netClientHandler.addToSendQueue(new Packet14BlockDig(0, par1, par2, par3, par4));
            PlayerControllerCreative.clickBlockCreative(this.mc, this, par1, par2, par3, par4);
            return;
        }
        if (par1 == this.currentBlockX && par2 == this.currentBlockY && par3 == this.currentblockZ) {
            int i = this.mc.theWorld.getBlockId(par1, par2, par3);
            if (i == 0) {
                this.isHittingBlock = false;
                return;
            }
            Block block = Block.blocksList[i];
            this.curBlockDamageMP += block.blockStrength(this.mc.thePlayer);
            if (this.stepSoundTickCounter % 4.0f == 0.0f && block != null) {
                this.mc.sndManager.playSound(block.stepSound.getStepSound(), (float)par1 + 0.5f, (float)par2 + 0.5f, (float)par3 + 0.5f, (block.stepSound.getVolume() + 1.0f) / 8.0f, block.stepSound.getPitch() * 0.5f);
            }
            this.stepSoundTickCounter += 1.0f;
            if (this.curBlockDamageMP >= 1.0f) {
                this.isHittingBlock = false;
                this.netClientHandler.addToSendQueue(new Packet14BlockDig(2, par1, par2, par3, par4));
                this.onPlayerDestroyBlock(par1, par2, par3, par4);
                this.curBlockDamageMP = 0.0f;
                this.prevBlockDamageMP = 0.0f;
                this.stepSoundTickCounter = 0.0f;
                this.blockHitDelay = 5;
            }
        } else {
            this.clickBlock(par1, par2, par3, par4);
        }
    }

    @Override
    public void setPartialTime(float par1) {
        if (this.curBlockDamageMP <= 0.0f) {
            this.mc.ingameGUI.damageGuiPartialTime = 0.0f;
            this.mc.renderGlobal.damagePartialTime = 0.0f;
        } else {
            float f;
            this.mc.ingameGUI.damageGuiPartialTime = f = this.prevBlockDamageMP + (this.curBlockDamageMP - this.prevBlockDamageMP) * par1;
            this.mc.renderGlobal.damagePartialTime = f;
        }
    }

    @Override
    public float getBlockReachDistance() {
        return !this.creativeMode ? 4.5f : 5.0f;
    }

    @Override
    public void onWorldChange(World par1World) {
        super.onWorldChange(par1World);
    }

    @Override
    public void updateController() {
        this.syncCurrentPlayItem();
        this.prevBlockDamageMP = this.curBlockDamageMP;
        this.mc.sndManager.playRandomMusicIfReady();
    }

    private void syncCurrentPlayItem() {
        int i = this.mc.thePlayer.inventory.currentItem;
        if (i != this.currentPlayerItem) {
            this.currentPlayerItem = i;
            this.netClientHandler.addToSendQueue(new Packet16BlockItemSwitch(this.currentPlayerItem));
        }
    }

    @Override
    public boolean onPlayerRightClick(EntityPlayer par1EntityPlayer, World par2World, ItemStack par3ItemStack, int par4, int par5, int par6, int par7) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet15Place(par4, par5, par6, par7, par1EntityPlayer.inventory.getCurrentItem()));
        int i = par2World.getBlockId(par4, par5, par6);
        if (i > 0 && Block.blocksList[i].blockActivated(par2World, par4, par5, par6, par1EntityPlayer)) {
            return true;
        }
        if (par3ItemStack == null) {
            return false;
        }
        if (this.creativeMode) {
            int j = par3ItemStack.getItemDamage();
            int k = par3ItemStack.stackSize;
            boolean flag = par3ItemStack.useItem(par1EntityPlayer, par2World, par4, par5, par6, par7);
            par3ItemStack.setItemDamage(j);
            par3ItemStack.stackSize = k;
            return flag;
        }
        return par3ItemStack.useItem(par1EntityPlayer, par2World, par4, par5, par6, par7);
    }

    @Override
    public boolean sendUseItem(EntityPlayer par1EntityPlayer, World par2World, ItemStack par3ItemStack) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet15Place(-1, -1, -1, 255, par1EntityPlayer.inventory.getCurrentItem()));
        boolean flag = super.sendUseItem(par1EntityPlayer, par2World, par3ItemStack);
        return flag;
    }

    @Override
    public EntityPlayer createPlayer(World par1World) {
        return new EntityClientPlayerMP(this.mc, par1World, this.mc.session, this.netClientHandler);
    }

    @Override
    public void attackEntity(EntityPlayer par1EntityPlayer, Entity par2Entity) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet7UseEntity(par1EntityPlayer.entityId, par2Entity.entityId, 1));
        par1EntityPlayer.attackTargetEntityWithCurrentItem(par2Entity);
    }

    @Override
    public void interactWithEntity(EntityPlayer par1EntityPlayer, Entity par2Entity) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet7UseEntity(par1EntityPlayer.entityId, par2Entity.entityId, 0));
        par1EntityPlayer.useCurrentItemOnEntity(par2Entity);
    }

    @Override
    public ItemStack windowClick(int par1, int par2, int par3, boolean par4, EntityPlayer par5EntityPlayer) {
        short word0 = par5EntityPlayer.craftingInventory.getNextTransactionID(par5EntityPlayer.inventory);
        ItemStack itemstack = super.windowClick(par1, par2, par3, par4, par5EntityPlayer);
        this.netClientHandler.addToSendQueue(new Packet102WindowClick(par1, par2, par3, par4, itemstack, word0));
        return itemstack;
    }

    @Override
    public void func_40593_a(int par1, int par2) {
        this.netClientHandler.addToSendQueue(new Packet108EnchantItem(par1, par2));
    }

    @Override
    public void sendSlotPacket(ItemStack par1ItemStack, int par2) {
        if (this.creativeMode) {
            this.netClientHandler.addToSendQueue(new Packet107CreativeSetSlot(par2, par1ItemStack));
        }
    }

    @Override
    public void func_35639_a(ItemStack par1ItemStack) {
        if (this.creativeMode && par1ItemStack != null) {
            this.netClientHandler.addToSendQueue(new Packet107CreativeSetSlot(-1, par1ItemStack));
        }
    }

    @Override
    public void func_20086_a(int par1, EntityPlayer par2EntityPlayer) {
        if (par1 == -9999) {
            return;
        }
    }

    @Override
    public void onStoppedUsingItem(EntityPlayer par1EntityPlayer) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet14BlockDig(5, 0, 0, 0, 255));
        super.onStoppedUsingItem(par1EntityPlayer);
    }

    @Override
    public boolean func_35642_f() {
        return true;
    }

    @Override
    public boolean isNotCreative() {
        return !this.creativeMode;
    }

    @Override
    public boolean isInCreativeMode() {
        return this.creativeMode;
    }

    @Override
    public boolean extendedReach() {
        return this.creativeMode;
    }
}

