/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.PlayerController;
import net.minecraft.src.World;

public class PlayerControllerSP
extends PlayerController {
    private int curBlockX = -1;
    private int curBlockY = -1;
    private int curBlockZ = -1;
    private float curBlockDamage = 0.0f;
    private float prevBlockDamage = 0.0f;
    private float blockDestroySoundCounter = 0.0f;
    private int blockHitWait = 0;

    public PlayerControllerSP(Minecraft par1Minecraft) {
        super(par1Minecraft);
    }

    @Override
    public void flipPlayer(EntityPlayer par1EntityPlayer) {
        par1EntityPlayer.rotationYaw = -180.0f;
    }

    @Override
    public boolean shouldDrawHUD() {
        return true;
    }

    @Override
    public boolean onPlayerDestroyBlock(int par1, int par2, int par3, int par4) {
        int i = this.mc.theWorld.getBlockId(par1, par2, par3);
        int j = this.mc.theWorld.getBlockMetadata(par1, par2, par3);
        boolean flag = super.onPlayerDestroyBlock(par1, par2, par3, par4);
        ItemStack itemstack = this.mc.thePlayer.getCurrentEquippedItem();
        boolean flag1 = this.mc.thePlayer.canHarvestBlock(Block.blocksList[i]);
        if (itemstack != null) {
            itemstack.onDestroyBlock(i, par1, par2, par3, this.mc.thePlayer);
            if (itemstack.stackSize == 0) {
                itemstack.onItemDestroyedByUse(this.mc.thePlayer);
                this.mc.thePlayer.destroyCurrentEquippedItem();
            }
        }
        if (flag && flag1) {
            Block.blocksList[i].harvestBlock(this.mc.theWorld, this.mc.thePlayer, par1, par2, par3, j);
        }
        return flag;
    }

    @Override
    public void clickBlock(int par1, int par2, int par3, int par4) {
        if (!this.mc.thePlayer.canPlayerEdit(par1, par2, par3)) {
            return;
        }
        this.mc.theWorld.func_48457_a(this.mc.thePlayer, par1, par2, par3, par4);
        int i = this.mc.theWorld.getBlockId(par1, par2, par3);
        if (i > 0 && this.curBlockDamage == 0.0f) {
            Block.blocksList[i].onBlockClicked(this.mc.theWorld, par1, par2, par3, this.mc.thePlayer);
        }
        if (i > 0 && Block.blocksList[i].blockStrength(this.mc.thePlayer) >= 1.0f) {
            this.onPlayerDestroyBlock(par1, par2, par3, par4);
        }
    }

    @Override
    public void resetBlockRemoving() {
        this.curBlockDamage = 0.0f;
        this.blockHitWait = 0;
    }

    @Override
    public void onPlayerDamageBlock(int par1, int par2, int par3, int par4) {
        if (this.blockHitWait > 0) {
            --this.blockHitWait;
            return;
        }
        if (par1 == this.curBlockX && par2 == this.curBlockY && par3 == this.curBlockZ) {
            int i = this.mc.theWorld.getBlockId(par1, par2, par3);
            if (!this.mc.thePlayer.canPlayerEdit(par1, par2, par3)) {
                return;
            }
            if (i == 0) {
                return;
            }
            Block block = Block.blocksList[i];
            this.curBlockDamage += block.blockStrength(this.mc.thePlayer);
            if (this.blockDestroySoundCounter % 4.0f == 0.0f && block != null) {
                this.mc.sndManager.playSound(block.stepSound.getStepSound(), (float)par1 + 0.5f, (float)par2 + 0.5f, (float)par3 + 0.5f, (block.stepSound.getVolume() + 1.0f) / 8.0f, block.stepSound.getPitch() * 0.5f);
            }
            this.blockDestroySoundCounter += 1.0f;
            if (this.curBlockDamage >= 1.0f) {
                this.onPlayerDestroyBlock(par1, par2, par3, par4);
                this.curBlockDamage = 0.0f;
                this.prevBlockDamage = 0.0f;
                this.blockDestroySoundCounter = 0.0f;
                this.blockHitWait = 5;
            }
        } else {
            this.curBlockDamage = 0.0f;
            this.prevBlockDamage = 0.0f;
            this.blockDestroySoundCounter = 0.0f;
            this.curBlockX = par1;
            this.curBlockY = par2;
            this.curBlockZ = par3;
        }
    }

    @Override
    public void setPartialTime(float par1) {
        if (this.curBlockDamage <= 0.0f) {
            this.mc.ingameGUI.damageGuiPartialTime = 0.0f;
            this.mc.renderGlobal.damagePartialTime = 0.0f;
        } else {
            float f;
            this.mc.ingameGUI.damageGuiPartialTime = f = this.prevBlockDamage + (this.curBlockDamage - this.prevBlockDamage) * par1;
            this.mc.renderGlobal.damagePartialTime = f;
        }
    }

    @Override
    public float getBlockReachDistance() {
        return 4.0f;
    }

    @Override
    public void onWorldChange(World par1World) {
        super.onWorldChange(par1World);
    }

    @Override
    public EntityPlayer createPlayer(World par1World) {
        EntityPlayer entityplayer = super.createPlayer(par1World);
        return entityplayer;
    }

    @Override
    public void updateController() {
        this.prevBlockDamage = this.curBlockDamage;
        this.mc.sndManager.playRandomMusicIfReady();
    }

    @Override
    public boolean onPlayerRightClick(EntityPlayer par1EntityPlayer, World par2World, ItemStack par3ItemStack, int par4, int par5, int par6, int par7) {
        int i = par2World.getBlockId(par4, par5, par6);
        if (i > 0 && Block.blocksList[i].blockActivated(par2World, par4, par5, par6, par1EntityPlayer)) {
            return true;
        }
        if (par3ItemStack == null) {
            return false;
        }
        return par3ItemStack.useItem(par1EntityPlayer, par2World, par4, par5, par6, par7);
    }

    @Override
    public boolean func_35642_f() {
        return true;
    }
}

