/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityLiving;
import net.minecraft.src.Potion;

public class PotionEffect {
    private int potionID;
    private int duration;
    private int amplifier;

    public PotionEffect(int par1, int par2, int par3) {
        this.potionID = par1;
        this.duration = par2;
        this.amplifier = par3;
    }

    public PotionEffect(PotionEffect par1PotionEffect) {
        this.potionID = par1PotionEffect.potionID;
        this.duration = par1PotionEffect.duration;
        this.amplifier = par1PotionEffect.amplifier;
    }

    public void combine(PotionEffect par1PotionEffect) {
        if (this.potionID != par1PotionEffect.potionID) {
            System.err.println("This method should only be called for matching effects!");
        }
        if (par1PotionEffect.amplifier > this.amplifier) {
            this.amplifier = par1PotionEffect.amplifier;
            this.duration = par1PotionEffect.duration;
        } else if (par1PotionEffect.amplifier == this.amplifier && this.duration < par1PotionEffect.duration) {
            this.duration = par1PotionEffect.duration;
        }
    }

    public int getPotionID() {
        return this.potionID;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean onUpdate(EntityLiving par1EntityLiving) {
        if (this.duration > 0) {
            if (Potion.potionTypes[this.potionID].isReady(this.duration, this.amplifier)) {
                this.performEffect(par1EntityLiving);
            }
            this.deincrementDuration();
        }
        return this.duration > 0;
    }

    private int deincrementDuration() {
        return --this.duration;
    }

    public void performEffect(EntityLiving par1EntityLiving) {
        if (this.duration > 0) {
            Potion.potionTypes[this.potionID].performEffect(par1EntityLiving, this.amplifier);
        }
    }

    public String getEffectName() {
        return Potion.potionTypes[this.potionID].getName();
    }

    public int hashCode() {
        return this.potionID;
    }

    public String toString() {
        String s = "";
        s = this.getAmplifier() > 0 ? this.getEffectName() + " x " + (this.getAmplifier() + 1) + ", Duration: " + this.getDuration() : this.getEffectName() + ", Duration: " + this.getDuration();
        if (Potion.potionTypes[this.potionID].isUsable()) {
            return "(" + s + ")";
        }
        return s;
    }

    public boolean equals(Object par1Obj) {
        if (!(par1Obj instanceof PotionEffect)) {
            return false;
        }
        PotionEffect potioneffect = (PotionEffect)par1Obj;
        return this.potionID == potioneffect.potionID && this.amplifier == potioneffect.amplifier && this.duration == potioneffect.duration;
    }
}

