/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBase;
import net.minecraft.src.OpenGlHelper;
import net.minecraft.src.Render;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class RenderLiving
extends Render {
    protected ModelBase mainModel;
    protected ModelBase renderPassModel;

    public RenderLiving(ModelBase par1ModelBase, float par2) {
        this.mainModel = par1ModelBase;
        this.shadowSize = par2;
    }

    public void setRenderPassModel(ModelBase par1ModelBase) {
        this.renderPassModel = par1ModelBase;
    }

    private float func_48418_a(float par1, float par2, float par3) {
        float f;
        for (f = par2 - par1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return par1 + par3 * f;
    }

    public void doRenderLiving(EntityLiving par1EntityLiving, double par2, double par4, double par6, float par8, float par9) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        this.mainModel.onGround = this.renderSwingProgress(par1EntityLiving, par9);
        if (this.renderPassModel != null) {
            this.renderPassModel.onGround = this.mainModel.onGround;
        }
        this.mainModel.isRiding = par1EntityLiving.isRiding();
        if (this.renderPassModel != null) {
            this.renderPassModel.isRiding = this.mainModel.isRiding;
        }
        this.mainModel.isChild = par1EntityLiving.isChild();
        if (this.renderPassModel != null) {
            this.renderPassModel.isChild = this.mainModel.isChild;
        }
        try {
            float f = this.func_48418_a(par1EntityLiving.prevRenderYawOffset, par1EntityLiving.renderYawOffset, par9);
            float f1 = this.func_48418_a(par1EntityLiving.prevRotationYawHead, par1EntityLiving.rotationYawHead, par9);
            float f2 = par1EntityLiving.prevRotationPitch + (par1EntityLiving.rotationPitch - par1EntityLiving.prevRotationPitch) * par9;
            this.renderLivingAt(par1EntityLiving, par2, par4, par6);
            float f3 = this.handleRotationFloat(par1EntityLiving, par9);
            this.rotateCorpse(par1EntityLiving, f3, f, par9);
            float f4 = 0.0625f;
            GL11.glEnable((int)32826);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.preRenderCallback(par1EntityLiving, par9);
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * f4 - 0.0078125f), (float)0.0f);
            float f5 = par1EntityLiving.field_705_Q + (par1EntityLiving.field_704_R - par1EntityLiving.field_705_Q) * par9;
            float f6 = par1EntityLiving.field_703_S - par1EntityLiving.field_704_R * (1.0f - par9);
            if (par1EntityLiving.isChild()) {
                f6 *= 3.0f;
            }
            if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            GL11.glEnable((int)3008);
            this.mainModel.setLivingAnimations(par1EntityLiving, f6, f5, par9);
            this.renderModel(par1EntityLiving, f6, f5, f3, f1 - f, f2, f4);
            for (int i = 0; i < 4; ++i) {
                int j = this.shouldRenderPass(par1EntityLiving, i, par9);
                if (j <= 0) continue;
                this.renderPassModel.setLivingAnimations(par1EntityLiving, f6, f5, par9);
                this.renderPassModel.render(par1EntityLiving, f6, f5, f3, f1 - f, f2, f4);
                if (j == 15) {
                    float f8 = (float)par1EntityLiving.ticksExisted + par9;
                    this.loadTexture("%blur%/misc/glint.png");
                    GL11.glEnable((int)3042);
                    float f10 = 0.5f;
                    GL11.glColor4f((float)f10, (float)f10, (float)f10, (float)1.0f);
                    GL11.glDepthFunc((int)514);
                    GL11.glDepthMask((boolean)false);
                    for (int i1 = 0; i1 < 2; ++i1) {
                        GL11.glDisable((int)2896);
                        float f13 = 0.76f;
                        GL11.glColor4f((float)(0.5f * f13), (float)(0.25f * f13), (float)(0.8f * f13), (float)1.0f);
                        GL11.glBlendFunc((int)768, (int)1);
                        GL11.glMatrixMode((int)5890);
                        GL11.glLoadIdentity();
                        float f15 = f8 * (0.001f + (float)i1 * 0.003f) * 20.0f;
                        float f16 = 0.3333333f;
                        GL11.glScalef((float)f16, (float)f16, (float)f16);
                        GL11.glRotatef((float)(30.0f - (float)i1 * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glTranslatef((float)0.0f, (float)f15, (float)0.0f);
                        GL11.glMatrixMode((int)5888);
                        this.renderPassModel.render(par1EntityLiving, f6, f5, f3, f1 - f, f2, f4);
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glMatrixMode((int)5890);
                    GL11.glDepthMask((boolean)true);
                    GL11.glLoadIdentity();
                    GL11.glMatrixMode((int)5888);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                    GL11.glDepthFunc((int)515);
                }
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
            }
            this.renderEquippedItems(par1EntityLiving, par9);
            float f7 = par1EntityLiving.getBrightness(par9);
            int k = this.getColorMultiplier(par1EntityLiving, f7, par9);
            OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
            GL11.glDisable((int)3553);
            OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
            if ((k >> 24 & 0xFF) > 0 || par1EntityLiving.hurtTime > 0 || par1EntityLiving.deathTime > 0) {
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (par1EntityLiving.hurtTime > 0 || par1EntityLiving.deathTime > 0) {
                    GL11.glColor4f((float)f7, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.mainModel.render(par1EntityLiving, f6, f5, f3, f1 - f, f2, f4);
                    for (int l = 0; l < 4; ++l) {
                        if (this.inheritRenderPass(par1EntityLiving, l, par9) < 0) continue;
                        GL11.glColor4f((float)f7, (float)0.0f, (float)0.0f, (float)0.4f);
                        this.renderPassModel.render(par1EntityLiving, f6, f5, f3, f1 - f, f2, f4);
                    }
                }
                if ((k >> 24 & 0xFF) > 0) {
                    float f9 = (float)(k >> 16 & 0xFF) / 255.0f;
                    float f11 = (float)(k >> 8 & 0xFF) / 255.0f;
                    float f12 = (float)(k & 0xFF) / 255.0f;
                    float f14 = (float)(k >> 24 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f9, (float)f11, (float)f12, (float)f14);
                    this.mainModel.render(par1EntityLiving, f6, f5, f3, f1 - f, f2, f4);
                    for (int j1 = 0; j1 < 4; ++j1) {
                        if (this.inheritRenderPass(par1EntityLiving, j1, par9) < 0) continue;
                        GL11.glColor4f((float)f9, (float)f11, (float)f12, (float)f14);
                        this.renderPassModel.render(par1EntityLiving, f6, f5, f3, f1 - f, f2, f4);
                    }
                }
                GL11.glDepthFunc((int)515);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)32826);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
        GL11.glEnable((int)3553);
        OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        this.passSpecialRender(par1EntityLiving, par2, par4, par6);
    }

    protected void renderModel(EntityLiving par1EntityLiving, float par2, float par3, float par4, float par5, float par6, float par7) {
        this.loadDownloadableImageTexture(par1EntityLiving.skinUrl, par1EntityLiving.getTexture());
        this.mainModel.render(par1EntityLiving, par2, par3, par4, par5, par6, par7);
    }

    protected void renderLivingAt(EntityLiving par1EntityLiving, double par2, double par4, double par6) {
        GL11.glTranslatef((float)((float)par2), (float)((float)par4), (float)((float)par6));
    }

    protected void rotateCorpse(EntityLiving par1EntityLiving, float par2, float par3, float par4) {
        GL11.glRotatef((float)(180.0f - par3), (float)0.0f, (float)1.0f, (float)0.0f);
        if (par1EntityLiving.deathTime > 0) {
            float f = ((float)par1EntityLiving.deathTime + par4 - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.sqrt_float(f)) > 1.0f) {
                f = 1.0f;
            }
            GL11.glRotatef((float)(f * this.getDeathMaxRotation(par1EntityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected float renderSwingProgress(EntityLiving par1EntityLiving, float par2) {
        return par1EntityLiving.getSwingProgress(par2);
    }

    protected float handleRotationFloat(EntityLiving par1EntityLiving, float par2) {
        return (float)par1EntityLiving.ticksExisted + par2;
    }

    protected void renderEquippedItems(EntityLiving entityliving, float f) {
    }

    protected int inheritRenderPass(EntityLiving par1EntityLiving, int par2, float par3) {
        return this.shouldRenderPass(par1EntityLiving, par2, par3);
    }

    protected int shouldRenderPass(EntityLiving par1EntityLiving, int par2, float par3) {
        return -1;
    }

    protected float getDeathMaxRotation(EntityLiving par1EntityLiving) {
        return 90.0f;
    }

    protected int getColorMultiplier(EntityLiving par1EntityLiving, float par2, float par3) {
        return 0;
    }

    protected void preRenderCallback(EntityLiving entityliving, float f) {
    }

    protected void passSpecialRender(EntityLiving par1EntityLiving, double par2, double par4, double par6) {
        if (!Minecraft.isDebugInfoEnabled()) {
            // empty if block
        }
    }

    protected void renderLivingLabel(EntityLiving par1EntityLiving, String par2Str, double par3, double par5, double par7, int par9) {
        float f = par1EntityLiving.getDistanceToEntity(this.renderManager.livingPlayer);
        if (f > (float)par9) {
            return;
        }
        FontRenderer fontrenderer = this.getFontRendererFromRenderManager();
        float f1 = 1.6f;
        float f2 = 0.01666667f * f1;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)par3 + 0.0f), (float)((float)par5 + 2.3f), (float)((float)par7));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-f2), (float)(-f2), (float)f2);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.instance;
        int byte0 = 0;
        if (par2Str.equals("deadmau5")) {
            byte0 = -10;
        }
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        int i = fontrenderer.getStringWidth(par2Str) / 2;
        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.addVertex(-i - 1, -1 + byte0, 0.0);
        tessellator.addVertex(-i - 1, 8 + byte0, 0.0);
        tessellator.addVertex(i + 1, 8 + byte0, 0.0);
        tessellator.addVertex(i + 1, -1 + byte0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        fontrenderer.drawString(par2Str, -fontrenderer.getStringWidth(par2Str) / 2, byte0, 0x20FFFFFF);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontrenderer.drawString(par2Str, -fontrenderer.getStringWidth(par2Str) / 2, byte0, -1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    @Override
    public void doRender(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        this.doRenderLiving((EntityLiving)par1Entity, par2, par4, par6, par8, par9);
    }
}

