/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.ISaveFormat;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.SaveFormatComparator;
import net.minecraft.src.SaveHandler;
import net.minecraft.src.WorldInfo;

public class SaveFormatOld
implements ISaveFormat {
    protected final File savesDirectory;

    public SaveFormatOld(File par1File) {
        if (!par1File.exists()) {
            par1File.mkdirs();
        }
        this.savesDirectory = par1File;
    }

    @Override
    public String getFormatName() {
        return "Old Format";
    }

    @Override
    public List getSaveList() {
        ArrayList<SaveFormatComparator> arraylist = new ArrayList<SaveFormatComparator>();
        for (int i = 0; i < 5; ++i) {
            String s = "World" + (i + 1);
            WorldInfo worldinfo = this.getWorldInfo(s);
            if (worldinfo == null) continue;
            arraylist.add(new SaveFormatComparator(s, "", worldinfo.getLastTimePlayed(), worldinfo.getSizeOnDisk(), worldinfo.getGameType(), false, worldinfo.isHardcoreModeEnabled()));
        }
        return arraylist;
    }

    @Override
    public void flushCache() {
    }

    @Override
    public WorldInfo getWorldInfo(String par1Str) {
        File file = new File(this.savesDirectory, par1Str);
        if (!file.exists()) {
            return null;
        }
        File file1 = new File(file, "level.dat");
        if (file1.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.readCompressed(new FileInputStream(file1));
                NBTTagCompound nbttagcompound2 = nbttagcompound.getCompoundTag("Data");
                return new WorldInfo(nbttagcompound2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((file1 = new File(file, "level.dat_old")).exists()) {
            try {
                NBTTagCompound nbttagcompound1 = CompressedStreamTools.readCompressed(new FileInputStream(file1));
                NBTTagCompound nbttagcompound3 = nbttagcompound1.getCompoundTag("Data");
                return new WorldInfo(nbttagcompound3);
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void renameWorld(String par1Str, String par2Str) {
        File file = new File(this.savesDirectory, par1Str);
        if (!file.exists()) {
            return;
        }
        File file1 = new File(file, "level.dat");
        if (file1.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.readCompressed(new FileInputStream(file1));
                NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("Data");
                nbttagcompound1.setString("LevelName", par2Str);
                CompressedStreamTools.writeCompressed(nbttagcompound, new FileOutputStream(file1));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void deleteWorldDirectory(String par1Str) {
        File file = new File(this.savesDirectory, par1Str);
        if (!file.exists()) {
            return;
        }
        SaveFormatOld.deleteFiles(file.listFiles());
        file.delete();
    }

    protected static void deleteFiles(File[] par0ArrayOfFile) {
        for (int i = 0; i < par0ArrayOfFile.length; ++i) {
            if (par0ArrayOfFile[i].isDirectory()) {
                System.out.println("Deleting " + par0ArrayOfFile[i]);
                SaveFormatOld.deleteFiles(par0ArrayOfFile[i].listFiles());
            }
            par0ArrayOfFile[i].delete();
        }
    }

    @Override
    public ISaveHandler getSaveLoader(String par1Str, boolean par2) {
        return new SaveHandler(this.savesDirectory, par1Str, par2);
    }

    @Override
    public boolean isOldMapFormat(String par1Str) {
        return false;
    }

    @Override
    public boolean convertMapFormat(String par1Str, IProgressUpdate par2IProgressUpdate) {
        return false;
    }
}

